/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.graalvm.visualvm.lib.profiler.Bundle;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.ui.NBSwingWorker;
import org.netbeans.api.progress.ProgressHandle;

class SaveSnapshotAction
extends AbstractAction {
    private final LoadedSnapshot snapshot;

    SaveSnapshotAction(LoadedSnapshot snapshot) {
        this.putValue("Name", Bundle.SaveSnapshotAction_ActionName());
        this.putValue("ShortDescription", Bundle.SaveSnapshotAction_ActionDescr());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Save"));
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Save"));
        this.snapshot = snapshot;
        this.updateState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new NBSwingWorker(){
            private final ProgressHandle ph = ProgressHandle.createHandle((String)Bundle.MSG_SavingSnapshot());

            protected void doInBackground() {
                this.ph.setInitialDelay(500);
                this.ph.start();
                ResultsManager.getDefault().saveSnapshot(SaveSnapshotAction.this.snapshot);
            }

            protected void done() {
                this.ph.finish();
                SaveSnapshotAction.this.updateState();
            }
        }.execute();
    }

    public void updateState() {
        this.setEnabled(!this.snapshot.isSaved());
    }
}

