/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.arguments;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.graalvm.visualvm.gotosource.arguments.SourceArguments;
import org.graalvm.visualvm.gotosource.arguments.SourceRootsArgument;
import org.graalvm.visualvm.gotosource.arguments.SourceViewerArgument;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Option;

class SourceConfigArgument {
    static final String LONG_NAME = "source-config";
    static final Option ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"source-config"), (String)"org.graalvm.visualvm.gotosource.arguments.Bundle", (String)"Argument_SourceConfig_ShortDescr");

    SourceConfigArgument() {
    }

    static void process(String[] values, String[] rootsValues, String[] viewerValues) throws CommandException {
        if (rootsValues != null || viewerValues != null) {
            throw new CommandException(0, "--source-config not allowed with --source-roots or --source-viewer");
        }
        if (values.length != 1) {
            throw new CommandException(0, "--source-config requires exactly one value");
        }
        SourceConfigArgument.setValue(values[0]);
    }

    private static void setValue(String value) throws CommandException {
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.isEmpty()) {
            SourceRootsArgument.setValue(null);
            SourceViewerArgument.setValue(null);
        } else {
            value = SourceArguments.decode(value);
            try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(value), "UTF-8");){
                String sourceViewer;
                Properties props = new Properties();
                props.load(isr);
                String sourceRoots = props.getProperty("source-roots");
                if (sourceRoots != null) {
                    SourceRootsArgument.setValue(sourceRoots);
                }
                if ((sourceViewer = props.getProperty("source-viewer")) != null) {
                    SourceViewerArgument.setValue(sourceViewer);
                }
            }
            catch (IOException e) {
                throw new CommandException(0, "--source-config failed to read config " + value + ": " + e.getMessage());
            }
        }
    }
}

