/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.impl;

import java.util.Collection;
import java.util.Collections;
import org.graalvm.visualvm.gotosource.SourcesViewer;
import org.graalvm.visualvm.gotosource.viewer.ExternalSourcesViewer;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class SourceViewers {
    private static final String PROP_SELECTED_VIEWER = "prop_SourceViewers_selected";
    private static final String DEFAULT_VIEWER_ID = "ExternalSourcesViewer";
    private static SourcesViewer FORCED_VIEWER;

    private SourceViewers() {
    }

    public static Collection<? extends SourcesViewer> getRegisteredViewers() {
        if (SourceViewers.isForcedViewer()) {
            return Collections.singletonList(FORCED_VIEWER);
        }
        return Lookup.getDefault().lookupAll(SourcesViewer.class);
    }

    public static SourcesViewer getSelectedViewer() {
        if (SourceViewers.isForcedViewer()) {
            return FORCED_VIEWER;
        }
        String selectedID = NbPreferences.forModule(SourcesViewer.class).get(PROP_SELECTED_VIEWER, DEFAULT_VIEWER_ID);
        if (selectedID != null) {
            for (SourcesViewer sourcesViewer : SourceViewers.getRegisteredViewers()) {
                if (!selectedID.equals(sourcesViewer.getID())) continue;
                return sourcesViewer;
            }
        }
        return null;
    }

    public static void saveSelectedViewer(SourcesViewer selected) {
        if (SourceViewers.isForcedViewer()) {
            return;
        }
        NbPreferences.forModule(SourcesViewer.class).put(PROP_SELECTED_VIEWER, selected.getID());
    }

    public static void forceExternalViewer(String command) {
        FORCED_VIEWER = command == null || command.isEmpty() ? null : new ExternalSourcesViewer(command);
    }

    public static boolean isForcedViewer() {
        return FORCED_VIEWER != null;
    }
}

