/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.visualvm.gotosource.java.JavaClass;
import org.graalvm.visualvm.gotosource.java.JavaSourceUtils;

final class JavaMethod {
    private final String name;
    private final String signature;
    private final int nameStart;
    private final int bodyStart;
    private final int bodyEnd;

    private JavaMethod(String name, String signature, String source, int nameStart, int bodyStart, int bodyEnd) {
        this.name = name;
        this.signature = signature;
        this.nameStart = nameStart;
        this.bodyStart = bodyStart;
        this.bodyEnd = bodyEnd;
    }

    String getName() {
        return this.name;
    }

    String getSignature() {
        return this.signature;
    }

    int getNameStart() {
        return this.nameStart;
    }

    int getBodyStart() {
        return this.bodyStart;
    }

    int getBodyEnd() {
        return this.bodyEnd;
    }

    public int hashCode() {
        return this.nameStart;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaMethod)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return ((JavaMethod)o).nameStart == this.nameStart;
    }

    public String toString() {
        return "method " + this.name + " (nameStart=" + this.nameStart + ", bodyStart=" + this.bodyStart + ", bodyEnd=" + this.bodyEnd + ")";
    }

    static JavaMethod findMethod(String methodName, String methodSignature, JavaClass cls) {
        if (methodName.contains("lambda$")) {
            return null;
        }
        String source = JavaSourceUtils.maskNonBlock(cls.getSource(), '{', '}', cls.getBodyStart(), cls.getBodyEnd());
        if ("<clinit>".equals(methodName)) {
            return JavaMethod.findClassInitializer(cls, source);
        }
        if ("<init>".equals(methodName)) {
            return JavaMethod.findInstanceInitializer(cls, methodSignature, source);
        }
        JavaMethod method = JavaMethod.findMethodWithBody(methodName, methodName, methodSignature, cls, source);
        if (method != null) {
            return method;
        }
        return JavaMethod.findMethodWithoutBody(methodName, methodSignature, cls, source);
    }

    private static JavaMethod findClassInitializer(JavaClass cls, String source) {
        int[] bodyOffsets;
        int offset = cls.getBodyStart() + 1;
        String patternS = "\\Wstatic\\s*\\{";
        Pattern pattern = Pattern.compile(patternS);
        Matcher matcher = pattern.matcher(source);
        if (!matcher.find(offset)) {
            return null;
        }
        int bodyEnd = cls.getBodyEnd();
        offset = matcher.end();
        if (offset > bodyEnd) {
            return null;
        }
        if ((bodyOffsets = JavaSourceUtils.getBlockBounds(source, --offset, '{', '}'))[0] == -1 || bodyOffsets[1] == -1 || bodyOffsets[1] > bodyEnd) {
            return null;
        }
        return new JavaMethod("<clinit>", null, source, offset, bodyOffsets[0], bodyOffsets[1]);
    }

    private static JavaMethod findInstanceInitializer(JavaClass cls, String methodSignature, String source) {
        int[] bodyOffsets;
        JavaMethod constructor = JavaMethod.findMethod(cls.getName(), "<init>", methodSignature, cls, source, "(?<prefix>[\\s\\>]){#$0#}\\s*\\(", "\\G\\s*(throws\\s+((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*,\\s*)*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)??\\s*\\{", false);
        if (constructor != null) {
            return constructor;
        }
        int offset = cls.getBodyStart();
        String patternS = "[\\{\\};]\\s*\\{";
        Pattern pattern = Pattern.compile(patternS);
        Matcher matcher = pattern.matcher(source);
        if (!matcher.find(offset)) {
            return null;
        }
        int bodyEnd = cls.getBodyEnd();
        offset = matcher.end();
        if (offset > bodyEnd) {
            return null;
        }
        if ((bodyOffsets = JavaSourceUtils.getBlockBounds(source, --offset, '{', '}'))[0] == -1 || bodyOffsets[1] == -1 || bodyOffsets[1] > bodyEnd) {
            return null;
        }
        return new JavaMethod("<init>", null, source, offset, bodyOffsets[0], bodyOffsets[1]);
    }

    private static JavaMethod findMethodWithBody(String methodName, String modelName, String methodSignature, JavaClass cls, String source) {
        return JavaMethod.findMethod(methodName, modelName, methodSignature, cls, source, "(?<prefix>[\\s\\>]){#$0#}\\s*\\(", "\\G\\s*(throws\\s+((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*,\\s*)*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)??\\s*\\{", false);
    }

    private static JavaMethod findMethodWithoutBody(String methodName, String methodSignature, JavaClass cls, String source) {
        return JavaMethod.findMethod(methodName, methodName, methodSignature, cls, source, "(?<prefix>\\Wnative[\\s\\S&&[^;]&&[^\\(]]*?[\\s\\>]){#$0#}\\s*\\(", "\\G\\s*(throws\\s+((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*,\\s*)*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)??\\s*;", true);
    }

    private static JavaMethod findMethod(String methodName, String modelName, String methodSignature, JavaClass cls, String source, String startRegEx, String endRegEx, boolean withoutBody) {
        int offset = cls.getBodyStart() + 1;
        int bodyEnd = cls.getBodyEnd();
        String patternS = startRegEx.replace("{#$0#}", methodName);
        Pattern pattern = Pattern.compile(patternS);
        Matcher startMatcher = pattern.matcher(source);
        Matcher endMatcher = null;
        while (startMatcher.find(offset) && offset < bodyEnd) {
            int nameStart = startMatcher.start() + startMatcher.group("prefix").length();
            offset = startMatcher.end() - 1;
            if (offset > bodyEnd) {
                return null;
            }
            if ((offset = JavaSourceUtils.skipBlock(source, offset, '(', ')')) > bodyEnd) {
                return null;
            }
            if (endMatcher == null) {
                pattern = Pattern.compile(endRegEx);
                endMatcher = pattern.matcher(source);
            }
            if (!endMatcher.find(offset)) continue;
            offset = endMatcher.end() - 1;
            if (offset > bodyEnd) {
                return null;
            }
            if (withoutBody && ';' == source.charAt(offset)) {
                return new JavaMethod(methodName, methodSignature, source, nameStart, -1, -1);
            }
            int[] bodyOffsets = JavaSourceUtils.getBlockBounds(source, offset, '{', '}');
            if (bodyOffsets[0] == -1 || bodyOffsets[1] == -1 || bodyOffsets[1] > bodyEnd) {
                return null;
            }
            return new JavaMethod(modelName, methodSignature, source, nameStart, bodyOffsets[0], bodyOffsets[1]);
        }
        return null;
    }
}

