/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.swing.plaf.AllLFCustoms;
import org.netbeans.swing.plaf.LFCustoms;
import org.netbeans.swing.plaf.aqua.AquaLFCustoms;
import org.netbeans.swing.plaf.gtk.GtkLFCustoms;
import org.netbeans.swing.plaf.metal.MetalLFCustoms;
import org.netbeans.swing.plaf.nimbus.NimbusLFCustoms;
import org.netbeans.swing.plaf.util.NbTheme;
import org.netbeans.swing.plaf.util.RelativeColor;
import org.netbeans.swing.plaf.util.UIBootstrapValue;
import org.netbeans.swing.plaf.util.UIUtils;
import org.netbeans.swing.plaf.winclassic.WindowsLFCustoms;
import org.netbeans.swing.plaf.windows8.Windows8LFCustoms;
import org.netbeans.swing.plaf.winvista.VistaLFCustoms;
import org.netbeans.swing.plaf.winxp.XPLFCustoms;

public final class Startup {
    private static final String FORCED_CUSTOMS = System.getProperty("nb.forceui");
    private static final boolean NO_CUSTOMIZATIONS = Boolean.getBoolean("netbeans.plaf.disable.ui.customizations");
    private static final String NIMBUS = "Nimbus";
    private static Startup instance = null;
    private LFCustoms curCustoms = null;
    private LFCustoms globalCustoms = null;
    private static URL themeURL = null;
    private static Class uiClass = null;
    private static ResourceBundle bundle;
    private boolean installed = false;
    private static ClassLoader loader;
    private LFListener listener = null;

    private Startup() {
        this.initialize();
    }

    private void initialize() {
        block10: {
            LFInstanceOrName lFInstanceOrName = this.getLookAndFeel();
            boolean bl = false;
            if (lFInstanceOrName.lf instanceof MetalLookAndFeel) {
                bl = this.installTheme(lFInstanceOrName.lf);
            }
            try {
                if (!bl && (lFInstanceOrName.lf == null || lFInstanceOrName.lf == UIManager.getLookAndFeel()) && (lFInstanceOrName.lfClassName == null || lFInstanceOrName.lfClassName.equals(UIManager.getLookAndFeel().getClass().getName()))) break block10;
                if (lFInstanceOrName.lf != null) {
                    UIManager.setLookAndFeel(lFInstanceOrName.lf);
                    uiClass = lFInstanceOrName.lf.getClass();
                    break block10;
                }
                boolean bl2 = false;
                try {
                    UIManager.setLookAndFeel(lFInstanceOrName.lfClassName);
                    bl2 = true;
                    uiClass = UIManager.getLookAndFeel().getClass();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Custom UI class " + lFInstanceOrName.lfClassName + " not found.");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("Custom UI class " + lFInstanceOrName.lfClassName + " not possible to access.");
                }
                catch (InstantiationException instantiationException) {
                    System.err.println("Custom UI class " + lFInstanceOrName.lfClassName + " not possible to instantiate.");
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    System.err.println("Custom UI class " + lFInstanceOrName.lfClassName + " not supported as a look & feel.");
                }
                if (!bl2) {
                    MetalLookAndFeel metalLookAndFeel = new MetalLookAndFeel();
                    this.installTheme(metalLookAndFeel);
                    UIManager.setLookAndFeel(metalLookAndFeel);
                    uiClass = MetalLookAndFeel.class;
                }
            }
            catch (Exception exception) {
                System.err.println("Could not install look and feel " + lFInstanceOrName.getClassName());
            }
        }
    }

    private LFInstanceOrName getLookAndFeel() {
        if (uiClass != null && uiClass.getName().contains(NIMBUS)) {
            Logger.getLogger(this.getClass().getName()).warning("L&F Warning: Nimbus L&F is not supported L&F yet and system may exhibit various drawing problems. Please use for experimental purposes only.");
        }
        if (uiClass == null) {
            ResourceBundle resourceBundle = bundle != null ? bundle : ResourceBundle.getBundle("org.netbeans.swing.plaf.Bundle");
            String string = resourceBundle.getString("LookAndFeelClassName");
            if ("default".equals(string)) {
                string = Startup.defaultLaF();
            }
            if (string.equals(MetalLookAndFeel.class.getName())) {
                return new LFInstanceOrName(new MetalLookAndFeel());
            }
            return new LFInstanceOrName(string);
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (uiClass != lookAndFeel.getClass()) {
            try {
                lookAndFeel = (LookAndFeel)uiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return new LFInstanceOrName(uiClass.getName());
            }
        }
        return new LFInstanceOrName(lookAndFeel);
    }

    private static String defaultLaF() {
        String string;
        if (Startup.isWindows()) {
            string = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        } else if (Startup.isMac()) {
            string = "com.apple.laf.AquaLookAndFeel";
        } else if (Startup.shouldUseMetal()) {
            string = "javax.swing.plaf.metal.MetalLookAndFeel";
        } else {
            string = UIManager.getSystemLookAndFeelClassName();
            String string2 = System.getProperty("java.version");
            if ("1.6.0_01".compareTo(string2) > 0 && System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").indexOf("OpenJDK") < 0) {
                if (string.indexOf("gtk") >= 0 && !Boolean.getBoolean("useGtk")) {
                    string = "javax.swing.plaf.metal.MetalLookAndFeel";
                }
            } else if (string.indexOf("gtk") >= 0 && System.getProperty("useGtk") != null && !Boolean.getBoolean("useGtk")) {
                string = "javax.swing.plaf.metal.MetalLookAndFeel";
            }
            if (string.contains(NIMBUS)) {
                string = "javax.swing.plaf.metal.MetalLookAndFeel";
            }
        }
        return string;
    }

    private boolean installTheme(LookAndFeel lookAndFeel) {
        boolean bl = false;
        if (themeURL != null) {
            bl = true;
            NbTheme nbTheme = new NbTheme(themeURL, lookAndFeel);
            MetalLookAndFeel.setCurrentTheme(nbTheme);
        }
        return bl;
    }

    private void install() {
        if (this.installed) {
            return;
        }
        if (this.globalCustoms == null) {
            this.globalCustoms = new AllLFCustoms();
            this.installLFCustoms(this.globalCustoms);
        }
        this.installPerLFDefaults();
        this.installTheme(UIManager.getLookAndFeel());
        this.runPostInstall();
        this.attachListener();
    }

    private void installPerLFDefaults() {
        boolean bl = this.curCustoms != null;
        this.curCustoms = this.findCustoms();
        if (this.curCustoms != null) {
            Integer n = (Integer)UIManager.get("customFontSize");
            if (n == null && UIManager.getLookAndFeel().getClass() == MetalLookAndFeel.class) {
                n = new Integer(11);
            }
            if (n != null && !UIUtils.isGtkLF()) {
                AllLFCustoms.initCustomFontSize(n);
            }
            this.installLFCustoms(this.curCustoms);
            if (bl) {
                this.loadAllLazyValues(this.curCustoms);
            }
            this.curCustoms.disposeValues();
        }
        this.installSmoothScrollPane();
    }

    private void installSmoothScrollPane() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Object object = uIDefaults.get("ScrollPaneUI");
        if ("javax.swing.plaf.basic.BasicScrollPaneUI".equals(object)) {
            uIDefaults.put("ScrollPaneUI", "org.netbeans.swing.plaf.util.SmoothScrollPaneUI");
        }
    }

    private void loadAllLazyValues(LFCustoms lFCustoms) {
        if (this.globalCustoms != null) {
            this.loadLazy(this.globalCustoms.getApplicationSpecificKeysAndValues());
            this.loadLazy(this.globalCustoms.getGuaranteedKeysAndValues());
            this.loadLazy(this.globalCustoms.getLookAndFeelCustomizationKeysAndValues());
        }
        this.loadLazy(lFCustoms.getApplicationSpecificKeysAndValues());
        this.loadLazy(lFCustoms.getGuaranteedKeysAndValues());
        this.loadLazy(lFCustoms.getLookAndFeelCustomizationKeysAndValues());
    }

    private void loadLazy(Object[] objectArray) {
        if (objectArray.length > 0) {
            UIDefaults uIDefaults = UIManager.getDefaults();
            for (int i = 1; i < objectArray.length; i += 2) {
                if (objectArray[i] instanceof UIBootstrapValue.Lazy) {
                    ((UIBootstrapValue.Lazy)objectArray[i]).createValue(uIDefaults);
                }
                if (!(objectArray[i] instanceof RelativeColor)) continue;
                ((RelativeColor)objectArray[i]).clear();
            }
        }
    }

    private void uninstallPerLFDefaults() {
        assert (this.globalCustoms != null);
        if (this.curCustoms != null) {
            HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(this.globalCustoms.allKeys()));
            Object[] objectArray = this.curCustoms.allKeys();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (hashSet.contains(object)) continue;
                UIManager.put(object, null);
            }
        }
    }

    private void attachListener() {
        assert (this.listener == null);
        this.listener = new LFListener();
        UIManager.addPropertyChangeListener(this.listener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.xpstyle.themeActive", this.listener);
    }

    private void installLFCustoms(LFCustoms lFCustoms) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.put("ClassLoader", new CLValue());
        uIDefaults.putDefaults(lFCustoms.getGuaranteedKeysAndValues());
        uIDefaults.putDefaults(lFCustoms.getApplicationSpecificKeysAndValues());
        if (!NO_CUSTOMIZATIONS) {
            uIDefaults.putDefaults(lFCustoms.getLookAndFeelCustomizationKeysAndValues());
        }
        if (uIDefaults.getBoolean("windowDefaultLookAndFeelDecorated")) {
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
    }

    private void runPostInstall() {
        final Object object = UIManager.get("nb.laf.postinstall.callable");
        if (object instanceof Callable) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((Callable)object).call();
                    }
                    catch (Exception exception) {
                        Logger.getLogger(Startup.class.getName()).log(Level.INFO, null, exception);
                    }
                }
            });
        }
    }

    public static void setClassLoader(ClassLoader classLoader) {
        loader = classLoader;
    }

    private LFCustoms findCustoms() {
        ResourceBundle resourceBundle = bundle != null ? bundle : ResourceBundle.getBundle("org.netbeans.swing.plaf.Bundle");
        String string = resourceBundle.getString("LookAndFeelCustomsClassName");
        if ("default".equals(string)) {
            return this.findDefaultCustoms();
        }
        try {
            Class<?> clazz = UIUtils.classForName(string);
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof LFCustoms) {
                return (LFCustoms)obj;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("LF Customs " + string + " not on classpath.");
        }
        catch (Exception exception) {
            System.err.println("While loading: " + string);
            exception.printStackTrace();
        }
        return null;
    }

    private LFCustoms findDefaultCustoms() {
        String[] stringArray;
        if (FORCED_CUSTOMS != null) {
            System.err.println("Using explicitly set UI customizations: " + FORCED_CUSTOMS);
            if ("Windows8".equals(FORCED_CUSTOMS)) {
                return new Windows8LFCustoms();
            }
            if ("Vista".equals(FORCED_CUSTOMS)) {
                return new VistaLFCustoms();
            }
            if ("XP".equals(FORCED_CUSTOMS)) {
                return new XPLFCustoms();
            }
            if ("Aqua".equals(FORCED_CUSTOMS)) {
                return new AquaLFCustoms();
            }
            if ("Metal".equals(FORCED_CUSTOMS)) {
                return new MetalLFCustoms();
            }
            if ("Windows".equals(FORCED_CUSTOMS)) {
                return new WindowsLFCustoms();
            }
            if ("GTK".equals(FORCED_CUSTOMS)) {
                return new GtkLFCustoms();
            }
            try {
                return (LFCustoms)UIUtils.classForName(FORCED_CUSTOMS).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                System.err.println("UI customizations class not found: " + FORCED_CUSTOMS);
            }
        }
        LFCustoms lFCustoms = null;
        try {
            lFCustoms = (LFCustoms)UIManager.getLookAndFeelDefaults().get("Nb.LFCustoms");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (lFCustoms == null) {
            stringArray = new StringBuffer(40);
            stringArray.append("Nb.");
            stringArray.append(UIManager.getLookAndFeel().getID());
            if (UIUtils.isXPLF()) {
                if (Startup.isWindows8() || Startup.isWindows10() || Startup.isWindows11()) {
                    stringArray.append("Windows8LFCustoms");
                } else if (Startup.isWindowsVista() || Startup.isWindows7()) {
                    stringArray.append("VistaLFCustoms");
                } else {
                    stringArray.append("XPLFCustoms");
                }
            } else {
                stringArray.append("LFCustoms");
            }
            try {
                lFCustoms = (LFCustoms)UIManager.get(stringArray.toString());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (lFCustoms == null) {
            stringArray = new String[]{"Metal", "Windows", "Aqua", "GTK", NIMBUS};
            switch (Arrays.asList(stringArray).indexOf(UIManager.getLookAndFeel().getID())) {
                case 1: {
                    if (UIUtils.isXPLF()) {
                        if (Startup.isWindows8() || Startup.isWindows10() || Startup.isWindows11()) {
                            lFCustoms = new Windows8LFCustoms();
                            break;
                        }
                        if (Startup.isWindowsVista() || Startup.isWindows7()) {
                            lFCustoms = new VistaLFCustoms();
                            break;
                        }
                        lFCustoms = new XPLFCustoms();
                        break;
                    }
                    lFCustoms = new WindowsLFCustoms();
                    break;
                }
                case 0: {
                    lFCustoms = new MetalLFCustoms();
                    break;
                }
                case 2: {
                    lFCustoms = new AquaLFCustoms();
                    break;
                }
                case 3: {
                    lFCustoms = new GtkLFCustoms();
                    break;
                }
                case 4: {
                    lFCustoms = new NimbusLFCustoms();
                    break;
                }
                default: {
                    if (UIUtils.isXPLF()) {
                        if (Startup.isWindows8() || Startup.isWindows10() || Startup.isWindows11()) {
                            lFCustoms = new Windows8LFCustoms();
                            break;
                        }
                        if (Startup.isWindowsVista() || Startup.isWindows7()) {
                            lFCustoms = new VistaLFCustoms();
                            break;
                        }
                        lFCustoms = new XPLFCustoms();
                        break;
                    }
                    lFCustoms = UIManager.getLookAndFeel() instanceof MetalLookAndFeel ? new MetalLFCustoms() : new WindowsLFCustoms();
                }
            }
        }
        return lFCustoms;
    }

    public static void run(Class clazz, int n, URL uRL) {
        Startup.run(clazz, n, uRL, null);
    }

    public static void run(Class clazz, int n, URL uRL, ResourceBundle resourceBundle) {
        if (instance == null) {
            if (n > 0) {
                Integer n2 = new Integer(n);
                UIManager.put("customFontSize", n2);
            }
            uiClass = clazz;
            themeURL = uRL;
            bundle = resourceBundle;
            instance = new Startup();
            instance.install();
        }
    }

    private static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.startsWith("Windows");
    }

    private static boolean isWindowsVista() {
        String string = System.getProperty("os.name");
        return string.indexOf("Vista") >= 0 || string.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows7() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 7") >= 0 || string.equals("Windows NT (unknown)") && "6.1".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows8() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 8") >= 0 || string.equals("Windows NT (unknown)") && "6.2".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows10() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 10") >= 0 || string.equals("Windows NT (unknown)") && "10.0".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows11() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 11") >= 0;
    }

    private static boolean isMac() {
        String string = System.getProperty("os.name");
        boolean bl = string.startsWith("Darwin") || "Mac OS X".equals(string);
        return bl;
    }

    private static boolean isSolaris10() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        boolean bl = string.startsWith("SunOS") && "5.10".equals(string2);
        return bl;
    }

    private static boolean shouldUseMetal() {
        String string = System.getProperty("os.name");
        boolean bl = !"Solaris".equals(string) && !string.startsWith("SunOS") && !string.endsWith("Linux") || UIManager.getSystemLookAndFeelClassName().indexOf("Motif") > -1 || Startup.isSolaris10();
        return bl;
    }

    private static final class LFInstanceOrName {
        final LookAndFeel lf;
        final String lfClassName;

        public LFInstanceOrName(LookAndFeel lookAndFeel) {
            this.lf = lookAndFeel;
            this.lfClassName = null;
        }

        public LFInstanceOrName(String string) {
            this.lf = null;
            this.lfClassName = string;
        }

        public String getClassName() {
            if (this.lf != null) {
                return this.lf.getClass().getName();
            }
            return this.lfClassName;
        }
    }

    private class LFListener
    implements PropertyChangeListener {
        private LFListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName()) || "win.xpstyle.themeActive".equals(propertyChangeEvent.getPropertyName())) {
                Startup.this.uninstallPerLFDefaults();
                Startup.this.installPerLFDefaults();
            }
        }
    }

    private static final class CLValue
    implements UIDefaults.ActiveValue {
        private CLValue() {
        }

        @Override
        public ClassLoader createValue(UIDefaults uIDefaults) {
            return loader != null ? loader : Thread.currentThread().getContextClassLoader();
        }
    }
}

