/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.ModeStructureSnapshot;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.view.EditorAccessor;
import org.netbeans.core.windows.view.ElementAccessor;
import org.netbeans.core.windows.view.ModeAccessor;
import org.netbeans.core.windows.view.ModeStructureAccessor;
import org.netbeans.core.windows.view.SlidingAccessor;
import org.netbeans.core.windows.view.SplitAccessor;
import org.openide.windows.TopComponent;

final class ModeStructureAccessorImpl
implements ModeStructureAccessor {
    private final ElementAccessor splitRootAccessor;
    private final Set<ModeAccessor> separateModeAccessors;
    private final Set<SlidingAccessor> slidingModeAccessors;

    public ModeStructureAccessorImpl(ElementAccessor elementAccessor, Set<ModeAccessor> set, Set<SlidingAccessor> set2) {
        this.splitRootAccessor = elementAccessor;
        this.separateModeAccessors = set;
        this.slidingModeAccessors = set2;
    }

    @Override
    public ElementAccessor getSplitRootAccessor() {
        return this.splitRootAccessor;
    }

    @Override
    public ModeAccessor[] getSeparateModeAccessors() {
        return this.separateModeAccessors.toArray(new ModeAccessor[0]);
    }

    @Override
    public SlidingAccessor[] getSlidingModeAccessors() {
        return this.slidingModeAccessors.toArray(new SlidingAccessor[0]);
    }

    public ModeAccessor findModeAccessor(String string) {
        ModeAccessor modeAccessor2 = ModeStructureAccessorImpl.findModeAccessorOfName(this.splitRootAccessor, string);
        if (modeAccessor2 != null) {
            return modeAccessor2;
        }
        for (ModeAccessor modeAccessor : this.separateModeAccessors) {
            if (!string.equals(modeAccessor.getName())) continue;
            return modeAccessor;
        }
        for (ModeAccessor modeAccessor : this.slidingModeAccessors) {
            if (!string.equals(modeAccessor.getName())) continue;
            return modeAccessor;
        }
        return null;
    }

    private static ModeAccessor findModeAccessorOfName(ElementAccessor elementAccessor, String string) {
        EditorAccessor editorAccessor;
        ModeAccessor modeAccessor;
        if (elementAccessor instanceof ModeAccessor) {
            ModeAccessor modeAccessor2 = (ModeAccessor)elementAccessor;
            if (string.equals(modeAccessor2.getName())) {
                return modeAccessor2;
            }
        } else if (elementAccessor instanceof SplitAccessor) {
            SplitAccessor splitAccessor = (SplitAccessor)elementAccessor;
            ElementAccessor[] elementAccessorArray = splitAccessor.getChildren();
            for (int i = 0; i < elementAccessorArray.length; ++i) {
                ModeAccessor modeAccessor3 = ModeStructureAccessorImpl.findModeAccessorOfName(elementAccessorArray[i], string);
                if (modeAccessor3 == null) continue;
                return modeAccessor3;
            }
        } else if (elementAccessor instanceof EditorAccessor && (modeAccessor = ModeStructureAccessorImpl.findModeAccessorOfName((editorAccessor = (EditorAccessor)elementAccessor).getEditorAreaAccessor(), string)) != null) {
            return modeAccessor;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nModesAccessorImpl hashCode=" + this.hashCode());
        stringBuffer.append("\nSplit modes:\n");
        stringBuffer.append(ModeStructureAccessorImpl.dumpAccessor(this.splitRootAccessor, 0));
        stringBuffer.append("\nSeparate Modes:");
        stringBuffer.append(ModeStructureAccessorImpl.dumpSet(this.separateModeAccessors));
        return stringBuffer.toString();
    }

    private static String dumpAccessor(ElementAccessor elementAccessor, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ModeStructureAccessorImpl.createIndentString(n);
        if (elementAccessor instanceof SplitAccessor) {
            SplitAccessor splitAccessor = (SplitAccessor)elementAccessor;
            stringBuffer.append(string + "split=" + splitAccessor);
            ++n;
            ElementAccessor[] elementAccessorArray = splitAccessor.getChildren();
            for (int i = 0; i < elementAccessorArray.length; ++i) {
                stringBuffer.append("\n" + ModeStructureAccessorImpl.dumpAccessor(elementAccessorArray[i], n));
            }
        } else if (elementAccessor instanceof ModeAccessor) {
            stringBuffer.append(string + "mode=" + elementAccessor);
        } else if (elementAccessor instanceof EditorAccessor) {
            stringBuffer.append(string + "editor=" + elementAccessor);
            stringBuffer.append(ModeStructureAccessorImpl.dumpAccessor(((EditorAccessor)elementAccessor).getEditorAreaAccessor(), ++n));
        }
        return stringBuffer.toString();
    }

    private static String createIndentString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static String dumpSet(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\nmode=" + iterator.next());
        }
        return stringBuffer.toString();
    }

    static final class EditorAccessorImpl
    extends ElementAccessorImpl
    implements EditorAccessor {
        private final ElementAccessor editorAreaAccessor;
        private final double resizeWeight;

        public EditorAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ElementSnapshot elementSnapshot, ElementAccessor elementAccessor, double d) {
            super(modelElement, elementSnapshot);
            this.editorAreaAccessor = elementAccessor;
            this.resizeWeight = d;
        }

        @Override
        public double getResizeWeight() {
            return this.resizeWeight;
        }

        @Override
        public ElementAccessor getEditorAreaAccessor() {
            return this.editorAreaAccessor;
        }

        @Override
        public String toString() {
            return super.toString() + "\n" + this.editorAreaAccessor;
        }
    }

    static final class SlidingAccessorImpl
    extends ModeAccessorImpl
    implements SlidingAccessor {
        private final String side;
        private final Map<TopComponent, Integer> slideInSizes;

        public SlidingAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ModeSnapshot modeSnapshot, String string, Map<TopComponent, Integer> map) {
            super(modelElement, modeSnapshot);
            this.side = string;
            this.slideInSizes = map;
        }

        @Override
        public String getSide() {
            return this.side;
        }

        @Override
        public Map<TopComponent, Integer> getSlideInSizes() {
            return this.slideInSizes;
        }

        @Override
        public boolean originatorEquals(ElementAccessor elementAccessor) {
            if (!super.originatorEquals(elementAccessor)) {
                return false;
            }
            SlidingAccessor slidingAccessor = (SlidingAccessor)elementAccessor;
            return this.getSide() == slidingAccessor.getSide();
        }
    }

    static class ModeAccessorImpl
    extends ElementAccessorImpl
    implements ModeAccessor {
        public ModeAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ModeSnapshot modeSnapshot) {
            super(modelElement, modeSnapshot);
        }

        private ModeStructureSnapshot.ModeSnapshot getModeSnapShot() {
            return (ModeStructureSnapshot.ModeSnapshot)this.getSnapshot();
        }

        @Override
        public boolean originatorEquals(ElementAccessor elementAccessor) {
            if (!super.originatorEquals(elementAccessor)) {
                return false;
            }
            ModeAccessor modeAccessor = (ModeAccessor)elementAccessor;
            return this.getState() == modeAccessor.getState();
        }

        @Override
        public ModeImpl getMode() {
            return this.getModeSnapShot().getMode();
        }

        @Override
        public String getName() {
            return this.getModeSnapShot().getName();
        }

        @Override
        public int getState() {
            return this.getModeSnapShot().getState();
        }

        @Override
        public int getKind() {
            return this.getModeSnapShot().getKind();
        }

        @Override
        public Rectangle getBounds() {
            return this.getModeSnapShot().getBounds();
        }

        @Override
        public int getFrameState() {
            return this.getModeSnapShot().getFrameState();
        }

        @Override
        public TopComponent getSelectedTopComponent() {
            return this.getModeSnapShot().getSelectedTopComponent();
        }

        @Override
        public TopComponent[] getOpenedTopComponents() {
            return this.getModeSnapShot().getOpenedTopComponents();
        }

        @Override
        public double getResizeWeight() {
            return this.getModeSnapShot().getResizeWeight();
        }

        @Override
        public String toString() {
            return super.toString() + "[name=" + this.getName() + " ]";
        }
    }

    static final class SplitAccessorImpl
    extends ElementAccessorImpl
    implements SplitAccessor {
        private final int orientation;
        private final double[] splitPositions;
        private final ElementAccessor[] children;
        private final double resizeWeight;

        public SplitAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ElementSnapshot elementSnapshot, int n, double[] dArray, ElementAccessor[] elementAccessorArray, double d) {
            super(modelElement, elementSnapshot);
            this.orientation = n;
            this.splitPositions = dArray;
            this.children = elementAccessorArray;
            this.resizeWeight = d;
        }

        @Override
        public int getOrientation() {
            return this.orientation;
        }

        @Override
        public double[] getSplitWeights() {
            return this.splitPositions;
        }

        @Override
        public ElementAccessor[] getChildren() {
            return this.children;
        }

        @Override
        public double getResizeWeight() {
            return this.resizeWeight;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append("[orientation=" + this.orientation);
            stringBuffer.append(", splitPosition=");
            for (int i = 0; i < this.splitPositions.length; ++i) {
                stringBuffer.append(this.splitPositions[i]);
                if (i >= this.splitPositions.length - 1) continue;
                stringBuffer.append(" : ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    static abstract class ElementAccessorImpl
    implements ElementAccessor {
        private final ModelElement originator;
        private final ModeStructureSnapshot.ElementSnapshot snapshot;

        public ElementAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ElementSnapshot elementSnapshot) {
            this.originator = modelElement;
            this.snapshot = elementSnapshot;
        }

        @Override
        public final ModelElement getOriginator() {
            return this.originator;
        }

        @Override
        public final ModeStructureSnapshot.ElementSnapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        public boolean originatorEquals(ElementAccessor elementAccessor) {
            if (elementAccessor instanceof ElementAccessorImpl) {
                return this.getClass().equals(elementAccessor.getClass()) && ((ElementAccessorImpl)elementAccessor).originator == this.originator;
            }
            return false;
        }

        public String toString() {
            return super.toString() + "[originatorHash=" + (this.originator != null ? Integer.toHexString(this.originator.hashCode()) : "null") + "]";
        }
    }
}

