/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat.application;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.core.properties.PropertiesPanel;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.jvmstat.application.ConnectionDescriptor;
import org.graalvm.visualvm.jvmstat.application.ConnectionsTable;
import org.graalvm.visualvm.uisupport.JExtendedSpinner;
import org.graalvm.visualvm.uisupport.UISupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ConnectionsCustomizer
extends PropertiesPanel {
    private static final Border SELECTED_BORDER = ConnectionsCustomizer.selectedBorder();
    private static final Border EMPTY_BORDER = ConnectionsCustomizer.emptyBorder(SELECTED_BORDER);
    private static final ConnectionDescriptor DEFAULT_CONNECTION = ConnectionDescriptor.createDefault();
    private static final String DATA_VIEW = "DATA_VIEW";
    private static final String NO_DATA_VIEW = "NO_DATA_VIEW";
    private static int TABLE_WIDTH = -1;
    private static int ROW_HEIGHT = -1;
    private final DefaultTableModel model;
    private JPanel viewPanel;
    private ConnectionsTable table;
    private JButton addDefault;
    private JButton remove;

    ConnectionsCustomizer(Set<ConnectionDescriptor> descriptors) {
        this.model = ConnectionsCustomizer.getModel(descriptors);
        this.initComponents();
        this.update();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConnectionsCustomizer.this.model.getRowCount() > 0) {
                    ConnectionsCustomizer.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        });
    }

    public Set<ConnectionDescriptor> getDescriptors() {
        return ConnectionsCustomizer.getDescriptors(this.model);
    }

    private static DefaultTableModel getModel(Set<ConnectionDescriptor> descriptors) {
        DefaultTableModel model = new DefaultTableModel(new Object[]{"Connections"}, 0);
        for (ConnectionDescriptor descriptor : descriptors) {
            model.addRow(new Object[]{descriptor});
        }
        return model;
    }

    private static Set<ConnectionDescriptor> getDescriptors(DefaultTableModel model) {
        HashSet<ConnectionDescriptor> descriptors = new HashSet<ConnectionDescriptor>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            descriptors.add((ConnectionDescriptor)model.getValueAt(i, 0));
        }
        return descriptors;
    }

    private static Border selectedBorder() {
        Border b = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
        if (b == null) {
            b = UIManager.getBorder("Table.focusCellHighlightBorder");
        }
        if (b != null) {
            b = new SafeBorder(b);
        }
        return b;
    }

    private static Border emptyBorder(Border border) {
        Insets i = border == null ? null : border.getBorderInsets(new JTextField());
        return i == null ? BorderFactory.createEmptyBorder() : BorderFactory.createEmptyBorder(i.top, i.left, i.bottom, i.right);
    }

    private void addDefault() {
        this.model.addRow(new Object[]{ConnectionDescriptor.createDefault()});
        int row = this.table.getRowCount() - 1;
        this.table.getSelectionModel().setSelectionInterval(row, row);
    }

    private void addCustom() {
        ConnectionDescriptor d = new ConnectionDescriptor(this.getUnusedPort(), GlobalPreferences.sharedInstance().getMonitoredHostPoll());
        this.model.addRow(new Object[]{d});
        int row = this.table.getRowCount() - 1;
        this.table.getSelectionModel().setSelectionInterval(row, row);
    }

    private void removeSelected() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        this.table.clearSelection();
        this.model.removeRow(selectedRow);
        if (selectedRow < this.table.getRowCount()) {
            this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        } else if (selectedRow > 0) {
            this.table.getSelectionModel().setSelectionInterval(selectedRow - 1, selectedRow - 1);
        }
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CardLayout cl = (CardLayout)ConnectionsCustomizer.this.viewPanel.getLayout();
                cl.show(ConnectionsCustomizer.this.viewPanel, ConnectionsCustomizer.this.model.getRowCount() > 0 ? ConnectionsCustomizer.DATA_VIEW : ConnectionsCustomizer.NO_DATA_VIEW);
                ConnectionsCustomizer.this.addDefault.setEnabled(!ConnectionsCustomizer.this.containsConnection(DEFAULT_CONNECTION));
                ConnectionsCustomizer.this.remove.setEnabled(ConnectionsCustomizer.this.table.getSelectedRow() != -1);
            }
        });
    }

    private boolean containsConnection(ConnectionDescriptor d) {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.table.getValueAt(i, 0).equals(d)) continue;
            return true;
        }
        return false;
    }

    private int getUnusedPort() {
        int i;
        HashSet<Integer> ports = new HashSet<Integer>();
        for (i = 0; i < this.table.getRowCount(); ++i) {
            ports.add(((ConnectionDescriptor)this.table.getValueAt(i, 0)).getPort());
        }
        for (i = ConnectionDescriptor.createDefault().getPort() + 1; i < 65536; ++i) {
            if (ports.contains(i)) continue;
            return i;
        }
        return -1;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        CellRenderer renderer = new CellRenderer();
        CellEditor editor = new CellEditor(new Runnable(){

            @Override
            public void run() {
                ConnectionsCustomizer.this.update();
            }
        });
        this.table = new ConnectionsTable(this.model, renderer, editor){

            @Override
            public int getRowHeight() {
                return ROW_HEIGHT;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                ps.width = TABLE_WIDTH;
                return ps;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension ms = super.getMinimumSize();
                ms.width = TABLE_WIDTH;
                return ms;
            }
        };
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension());
        this.table.setOpaque(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConnectionsCustomizer.this.update();
            }
        });
        if (TABLE_WIDTH == -1) {
            TABLE_WIDTH = editor.getTableCellEditorComponent((JTable)this.table, (Object)new ConnectionDescriptor((int)1, (double)1.0), (boolean)false, (int)1, (int)1).getPreferredSize().width;
            editor.stopCellEditing();
        }
        if (ROW_HEIGHT == -1) {
            ROW_HEIGHT = renderer.getTableCellRendererComponent((JTable)this.table, (Object)new ConnectionDescriptor((int)1, (double)1.0), (boolean)false, (boolean)false, (int)1, (int)1).getPreferredSize().height;
        }
        JScrollPane impl = new JScrollPane();
        ScrollableContainer scroll = new ScrollableContainer((JComponent)this.table);
        scroll.setBorder(impl.getBorder());
        if (!UISupport.isNimbusLookAndFeel()) {
            scroll.setViewportBorder(impl.getViewportBorder());
        }
        scroll.getViewport().setOpaque(true);
        scroll.getViewport().setBackground(UISupport.getDefaultBackground());
        scroll.setPreferredSize(new Dimension(TABLE_WIDTH + 20, 1));
        JLabel noConnection = new JLabel(NbBundle.getMessage(ConnectionsCustomizer.class, (String)"LBL_NoConnection"), 0);
        noConnection.setEnabled(false);
        noConnection.setOpaque(false);
        noConnection.setMinimumSize(new Dimension());
        JScrollPane emptyScroll = new JScrollPane(noConnection, 21, 31);
        emptyScroll.getViewport().setOpaque(true);
        emptyScroll.getViewport().setBackground(UISupport.getDefaultBackground());
        emptyScroll.setOpaque(false);
        if (UISupport.isNimbusLookAndFeel()) {
            emptyScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        }
        this.viewPanel = new JPanel(new CardLayout());
        this.viewPanel.setOpaque(false);
        this.viewPanel.add((Component)emptyScroll, NO_DATA_VIEW);
        this.viewPanel.add((Component)scroll, DATA_VIEW);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 10);
        this.add(this.viewPanel, c);
        this.addDefault = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ConnectionsCustomizer.this.addDefault();
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)this.addDefault, (String)NbBundle.getMessage(ConnectionsCustomizer.class, (String)"BTN_AddDefault"));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 0);
        this.add(this.addDefault, c);
        JButton addCustom = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ConnectionsCustomizer.this.addCustom();
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)addCustom, (String)NbBundle.getMessage(ConnectionsCustomizer.class, (String)"BTN_AddCustom"));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(3, 0, 3, 0);
        this.add(addCustom, c);
        this.remove = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ConnectionsCustomizer.this.removeSelected();
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)this.remove, (String)NbBundle.getMessage(ConnectionsCustomizer.class, (String)"BTN_Remove"));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(3, 0, 0, 0);
        this.add(this.remove, c);
    }

    private static class CellEditor
    extends JPanel
    implements TableCellEditor {
        private static final int BORDER_HEIGHT = 6;
        private static final Color BACKGROUND_COLOR = UIManager.getColor("Tree.selectionBackground");
        private static final Color FOREGROUND_COLOR = UIManager.getColor("Tree.selectionForeground");
        private Runnable updater;
        private JTable table;
        private ConnectionDescriptor cd;
        private JLabel portLabel;
        private JSpinner portSpinner;
        private JLabel refreshLabel;
        private JSpinner refreshSpinner;
        private JLabel refreshUnitsLabel;
        private PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.updateBorder();
                    }
                });
            }
        };

        CellEditor(Runnable updater) {
            this.updater = updater;
            this.initComponents();
        }

        private void updateBorder() {
            if (this.displayFocus()) {
                this.setBorder(SELECTED_BORDER);
            } else {
                this.setBorder(EMPTY_BORDER);
            }
        }

        private boolean displayFocus() {
            if (this.table == null) {
                return false;
            }
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            return focusOwner != null ? focusOwner == this.table || SwingUtilities.isDescendingFrom(focusOwner, this) : false;
        }

        private void initComponents() {
            this.portLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(ConnectionsCustomizer.class, (String)"LBL_Port2"));
            this.portLabel.setFont(this.portLabel.getFont().deriveFont(1));
            this.portSpinner = new JExtendedSpinner((SpinnerModel)new SpinnerNumberModel(0, 0, 65535, 1));
            this.portLabel.setLabelFor(this.portSpinner);
            this.refreshLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.refreshLabel, (String)NbBundle.getMessage(ConnectionsCustomizer.class, (String)"LBL_Refresh2"));
            this.refreshLabel.setFont(this.refreshLabel.getFont().deriveFont(1));
            this.refreshSpinner = new JExtendedSpinner((SpinnerModel)new SpinnerNumberModel(3.0, 1.0, 9999.0, 1.0));
            this.refreshLabel.setLabelFor(this.refreshSpinner);
            this.refreshUnitsLabel = new JLabel(NbBundle.getMessage(ConnectionsCustomizer.class, (String)"LBL_RefreshUnits"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(6, 5, 6, 0);
            this.add((Component)this.portLabel, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(6, 5, 6, 0);
            this.add((Component)this.portSpinner, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(6, 15, 6, 0);
            this.add((Component)this.refreshLabel, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(6, 5, 6, 0);
            this.add((Component)this.refreshSpinner, c);
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(6, 5, 6, 5);
            this.add((Component)this.refreshUnitsLabel, c);
            c = new GridBagConstraints();
            c.gridx = 5;
            c.gridy = 0;
            c.gridwidth = 0;
            c.gridheight = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 18;
            c.insets = new Insets(0, 5, 0, 0);
            this.add((Component)Spacer.create(), c);
            this.setOpaque(true);
            this.setBackground(BACKGROUND_COLOR);
            this.portLabel.setForeground(FOREGROUND_COLOR);
            this.refreshLabel.setForeground(FOREGROUND_COLOR);
            this.refreshUnitsLabel.setForeground(FOREGROUND_COLOR);
            JComponent portEditor = this.portSpinner.getEditor();
            if (portEditor instanceof JSpinner.DefaultEditor) {
                final JFormattedTextField tf = ((JSpinner.DefaultEditor)portEditor).getTextField();
                tf.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.commitEdit();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.commitEdit();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.commitEdit();
                    }

                    private void commitEdit() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    int val = (Integer)tf.getFormatter().stringToValue(tf.getText().trim());
                                    if (cd != null) {
                                        cd.setPort(val);
                                        updater.run();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                });
            } else {
                this.portSpinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (cd != null) {
                            cd.setPort((Integer)portSpinner.getValue());
                        }
                    }
                });
            }
            JComponent refreshEditor = this.refreshSpinner.getEditor();
            if (refreshEditor instanceof JSpinner.DefaultEditor) {
                final JFormattedTextField tf = ((JSpinner.DefaultEditor)refreshEditor).getTextField();
                tf.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.commitEdit();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.commitEdit();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.commitEdit();
                    }

                    private void commitEdit() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    int val = (Integer)tf.getFormatter().stringToValue(tf.getText().trim());
                                    if (cd != null) {
                                        cd.setRefreshRate(val);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                });
            } else {
                this.refreshSpinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (cd != null) {
                            cd.setRefreshRate(((Integer)refreshSpinner.getValue()).intValue());
                        }
                    }
                });
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.table = table;
            this.cd = (ConnectionDescriptor)value;
            this.portSpinner.setValue(this.cd.getPort());
            this.refreshSpinner.setValue(this.cd.getRefreshRate());
            this.updateBorder();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.listener);
            return this;
        }

        @Override
        public Object getCellEditorValue() {
            return this.cd;
        }

        @Override
        public boolean stopCellEditing() {
            this.cleanup();
            return true;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.cleanup();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }

        private void cleanup() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.listener);
            this.table = null;
            this.cd = null;
        }
    }

    private static class CellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final int BORDER_HEIGHT = 4;
        private static final Color BACKGROUND;
        private static final Color DARKER_BACKGROUND;
        private JLabel portLabel;
        private JLabel portValueLabel;
        private JLabel refreshLabel;
        private JLabel refreshValueLabel;
        private JLabel refreshUnitsLabel;
        private final NumberFormat format = NumberFormat.getInstance();

        CellRenderer() {
            this.initComponents();
        }

        private void initComponents() {
            this.portLabel = new JLabel(NbBundle.getMessage(ConnectionsCustomizer.class, (String)"LBL_Port1"));
            this.portLabel.setFont(this.portLabel.getFont().deriveFont(1));
            final int w = new JExtendedSpinner((SpinnerModel)new SpinnerNumberModel((int)0, (int)0, (int)65535, (int)0)).getPreferredSize().width;
            this.portValueLabel = new JLabel(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension ps = super.getPreferredSize();
                    ps.width = w;
                    return ps;
                }
            };
            this.refreshLabel = new JLabel(NbBundle.getMessage(ConnectionsCustomizer.class, (String)"LBL_Refresh1"));
            this.refreshLabel.setFont(this.refreshLabel.getFont().deriveFont(1));
            this.refreshValueLabel = new JLabel();
            this.refreshUnitsLabel = new JLabel(NbBundle.getMessage(ConnectionsCustomizer.class, (String)"LBL_RefreshUnits"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(4, 5, 4, 0);
            this.add((Component)this.portLabel, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(4, 5, 4, 0);
            this.add((Component)this.portValueLabel, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(4, 15, 4, 0);
            this.add((Component)this.refreshLabel, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(4, 5, 4, 0);
            this.add((Component)this.refreshValueLabel, c);
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(4, 5, 4, 0);
            this.add((Component)this.refreshUnitsLabel, c);
            c = new GridBagConstraints();
            c.gridx = 5;
            c.gridy = 0;
            c.gridwidth = 0;
            c.gridheight = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 18;
            c.insets = new Insets(0, 5, 0, 0);
            this.add((Component)Spacer.create(), c);
            this.setOpaque(true);
            this.setBorder(EMPTY_BORDER);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ConnectionDescriptor cd = (ConnectionDescriptor)value;
            this.portValueLabel.setText(this.format.format(cd.getPort()));
            this.refreshValueLabel.setText(this.format.format(cd.getRefreshRate()));
            if (!isSelected) {
                boolean oddRow = row % 2 == 0;
                this.setBackground(oddRow ? DARKER_BACKGROUND : BACKGROUND);
            }
            return this;
        }

        private static Color darker(Color c) {
            if (c == null) {
                return null;
            }
            int r = Math.abs(c.getRed() - 11);
            int g = Math.abs(c.getGreen() - 11);
            int b = Math.abs(c.getBlue() - 11);
            int a = c.getAlpha();
            return new Color(r, g, b, a);
        }

        static {
            int darkerB;
            int darkerG;
            BACKGROUND = UISupport.getDefaultBackground();
            int darkerR = BACKGROUND.getRed() - 11;
            if (darkerR < 0) {
                darkerR += 26;
            }
            if ((darkerG = BACKGROUND.getGreen() - 11) < 0) {
                darkerG += 26;
            }
            if ((darkerB = BACKGROUND.getBlue() - 11) < 0) {
                darkerB += 26;
            }
            DARKER_BACKGROUND = new Color(darkerR, darkerG, darkerB);
        }
    }

    private static class SafeBorder
    implements Border {
        private final Border impl;

        SafeBorder(Border impl) {
            this.impl = impl;
        }

        @Override
        public void paintBorder(Component cmpnt, Graphics grphcs, int i, int i1, int i2, int i3) {
            this.impl.paintBorder(cmpnt, grphcs, i, i1, i2, i3);
        }

        @Override
        public Insets getBorderInsets(Component cmpnt) {
            Insets insets = this.impl.getBorderInsets(cmpnt);
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return this.impl.isBorderOpaque();
        }
    }
}

