/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.core.datasupport.Positionable;
import org.graalvm.visualvm.jmx.EnvironmentProvider;
import org.graalvm.visualvm.jmx.JmxConnectionCustomizer;

public final class JmxConnectionSupportImpl {
    private static final Map<String, EnvironmentProvider> providers = Collections.synchronizedMap(new HashMap());
    private static final Map<String, JmxConnectionCustomizer> customizers = Collections.synchronizedMap(new HashMap());
    private static JmxConnectionCustomizer defaultCustomizer;
    private static boolean defaultHidden;

    public static void registerProviderImpl(EnvironmentProvider provider) {
        String providerId = provider.getId();
        if (providers.containsKey(providerId)) {
            throw new UnsupportedOperationException("Provider with id '" + providerId + "' already registered");
        }
        providers.put(providerId, provider);
    }

    public static void unregisterProviderImpl(EnvironmentProvider provider) {
        providers.remove(provider.getId());
    }

    public static EnvironmentProvider getProvider(String providerId) {
        return providers.get(providerId);
    }

    public static void registerCustomizer(JmxConnectionCustomizer customizer) {
        String customizerId = customizer.getId();
        if (customizers.containsKey(customizerId)) {
            throw new UnsupportedOperationException("Customizer with id '" + customizerId + "' already registered");
        }
        customizers.put(customizerId, customizer);
        defaultHidden = defaultHidden || customizer.hidesDefault();
    }

    public static void unregisterCustomizer(JmxConnectionCustomizer customizer) {
        customizers.remove(customizer.getId());
        if (customizer.hidesDefault()) {
            JmxConnectionSupportImpl.updateDefaultHidden();
        }
    }

    public static JmxConnectionCustomizer getCustomizer(String customizerId) {
        return customizers.get(customizerId);
    }

    public static List<JmxConnectionCustomizer> getCustomizers() {
        List<JmxConnectionCustomizer> list = JmxConnectionSupportImpl.customizers();
        if (defaultHidden && defaultCustomizer != null) {
            list.remove((Object)defaultCustomizer);
        }
        Collections.sort(list, Positionable.COMPARATOR);
        return list;
    }

    public static void setDefaultCustomizer(JmxConnectionCustomizer customizer) {
        if (defaultCustomizer != null) {
            throw new UnsupportedOperationException("Default customizer already set");
        }
        defaultCustomizer = customizer;
    }

    static JmxConnectionCustomizer getDefaultCustomizer() {
        return defaultCustomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<JmxConnectionCustomizer> customizers() {
        ArrayList<JmxConnectionCustomizer> list = new ArrayList<JmxConnectionCustomizer>();
        Map<String, JmxConnectionCustomizer> map = customizers;
        synchronized (map) {
            list.addAll(customizers.values());
        }
        return list;
    }

    private static void updateDefaultHidden() {
        boolean newDefaultHidden = false;
        List<JmxConnectionCustomizer> list = JmxConnectionSupportImpl.customizers();
        for (JmxConnectionCustomizer customizer : list) {
            if (!customizer.hidesDefault()) continue;
            newDefaultHidden = true;
            break;
        }
        defaultHidden = newDefaultHidden;
    }

    static {
        defaultHidden = false;
    }
}

