;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; msp430 include file generated by make_include.py
;; part of the naken430asm msp430 assembler
;;
;; Generated by: Michael Kohn (mike@mikekohn.net)
;;   Input File: msp430g2x31.txt
;;         Date: 2011-06-19 14:26
;;        Parts: msp430g2x31
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ADC10 (MSP430G2x31 only)

ADC10SA equ 0x01bc        ; ADC data transfer start address
ADC10CTL0 equ 0x01b0      ; ADC control 0
ADC10CTL1 equ 0x01b2      ; ADC control 1
ADC10MEM equ 0x01b4       ; ADC memory

SREF_0 equ 0x0000 ; Vr+ = Vcc and Vr- = Vss
SREF_1 equ 0x2000 ; Vr+ = Vref+ and Vr- = Vss
SREF_2 equ 0x4000 ; Vr+ = Veref+ and Vr- = Vss
SREF_3 equ 0x6000 ; Vr+ = Buffered Veref+ and Vr- = Vss
SREF_4 equ 0x8000 ; Vr+ = Vcc and Vr- = Vref- / Veref-
SREF_5 equ 0xa000 ; Vr+ = Vref+ and Vr- = Vref- / Veref-
SREF_6 equ 0xc000 ; Vr+ = Veref+ and Vr- = Vref- / Veref-
SREF_7 equ 0xe000 ; Vr+ = Buffered Veref+ and Vr- = Vref- / Veref-

ADC10SHT_0 equ 0x0000 ; 4 * ADC10CLKs
ADC10SHT_1 equ 0x0800 ; 8 * ADC10CLKs
ADC10SHT_2 equ 0x1000 ; 16 * ADC10CLKs
ADC10SHT_3 equ 0x1800 ; 64 * ADC10CLKs

ADC10SR equ 0x0400  ; ADC10 sampling rate
REFOUT equ 0x0200   ; reference output
REFBURST equ 0x0100 ; reference burst
MISC equ 0x0080     ; mutiple sample and conversion
REF2_5V equ 0x0040  ; reference generator voltage
REFON equ 0x0020    ; reference generator on
ADC10ON equ 0x0010  ; ADC10 on
ADC10IE equ 0x0008  ; ADC10 interrupt enable
ADC10IFG equ 0x0004 ; ADC10 interrupt flag
ENC equ 0x0002      ; enable conversion
ADC10SC equ 0x0001  ; start sample and conversion

INCH_0 equ 0x0000   ; input channel A0
INCH_1 equ 0x1000   ; input channel A1
INCH_2 equ 0x2000   ; input channel A2
INCH_3 equ 0x3000   ; input channel A3
INCH_4 equ 0x4000   ; input channel A4
INCH_5 equ 0x5000   ; input channel A5
INCH_6 equ 0x6000   ; input channel A6
INCH_7 equ 0x7000   ; input channel A7
INCH_8 equ 0x8000   ; VeREF+
INCH_9 equ 0x9000   ; VREF-/Veref-
INCH_10 equ 0xa000  ; temperature sensor
INCH_11 equ 0xb000  ; (Vcc-Vss)/2
INCH_12 equ 0xc000  ; (Vcc-Vss)/2, A12 on MSP430x22xx
INCH_13 equ 0xd000  ; (Vcc-Vss)/2, A13 on MSP430x22xx
INCH_14 equ 0xe000  ; (Vcc-Vss)/2, A14 on MSP430x22xx
INCH_15 equ 0xf000  ; (Vcc-Vss)/2, A15 on MSP430x22xx

SHS_0 equ 0x0000 ; sample-and-hold select ADC10SC
SHS_1 equ 0x0400 ; sample-and-hold Timer_A.OUT1
SHS_2 equ 0x0800 ; sample-and-hold Timer_A.OUT0
SHS_3 equ 0x0c00 ; sample-and-hold Timer_A.OUT2 (Timer_A.OUT1 on MSP430x20x2)

ADC10DF equ 0x0200 ; 2's complement data format (0 for straight binary)
ISSH equ 0x0100    ; sample-input signal inverted

ADC10DIV_0 equ 0x0000 ; /1 ADC clock divider
ADC10DIV_1 equ 0x0020 ; /2 ADC clock divider
ADC10DIV_2 equ 0x0040 ; /3 ADC clock divider
ADC10DIV_3 equ 0x0060 ; /4 ADC clock divider
ADC10DIV_4 equ 0x0080 ; /5 ADC clock divider
ADC10DIV_5 equ 0x00a0 ; /6 ADC clock divider
ADC10DIV_6 equ 0x00c0 ; /7 ADC clock divider
ADC10DIV_7 equ 0x00e0 ; /8 ADC clock divider

ADC10SSEL_0 equ 0x0000 ; ADC10OSC
ADC10SSEL_1 equ 0x0008 ; ACLK
ADC10SSEL_2 equ 0x0010 ; MCLK
ADC10SSEL_3 equ 0x0018 ; SMCLK

CONSEQ_0 equ 0x0000 ; single channel conversion
CONSEQ_1 equ 0x0002 ; sequence of channels
CONSEQ_2 equ 0x0004 ; repeat single channel
CONSEQ_3 equ 0x0006 ; repeqt sequence of channels

ADC10BUSY equ 0x0001 ; a sequence, sample, or conversion is active

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Timer_A

TACCR1 equ 0x0174         ; Capture/compare register
TACCR0 equ 0x0172         ; Capture/compare register
TAR equ 0x0170            ; Timer_A register
TACCTL0 equ 0x0162        ; Capture/compare control
TACCTL1 equ 0x0164        ; Capture/compare control
TACTL equ 0x0160          ; Timer_A control
TAIV equ 0x012e           ; Timer_A interrupt vector

TASSEL_0 equ 0   ; TACLK
TASSEL_1 equ 256 ; ACLK
TASSEL_2 equ 512 ; SMCLK
TASSEL_3 equ 768 ; INCLK

ID_0 equ 0   ; div by 1
ID_1 equ 64  ; div by 2
ID_2 equ 128 ; div by 4
ID_3 equ 192 ; div by 8

MC_0 equ 0  ; timer is halted
MC_1 equ 16 ; timer counts up to TACCR0
MC_2 equ 32 ; timer counts up to 0xffff
MC_3 equ 48 ; up/down timer counts up to TACCR0 then down to 0x0000

TACLR equ 4 ; Timer_A clear
TAIE equ 2  ; interrupt enable
TAIFG equ 1 ; timer interrupt flag

CM_0 equ 0x0000 ; no capture
CM_1 equ 0x4000 ; capture on rising edge
CM_2 equ 0x8000 ; capture on falling edge
CM_3 equ 0xc000 ; capture on both rising and falling edges

CCIS_0 equ 0x0000 ; capture from CCIxA
CCIS_1 equ 0x1000 ; capture from CCIxB
CCIS_2 equ 0x2000 ; capture from GND
CCIS_3 equ 0x3000 ; capture from Vcc

SCS equ 0x0800  ; synchronous capture
SCCI equ 0x0400 ; synchronize capture/compare input
CAP equ 0x0100  ; capture mode

OUTMOD_0 equ 0x0000 ; OUT bit value
OUTMOD_1 equ 0x0020 ; Set
OUTMOD_2 equ 0x0040 ; Toggle/reset
OUTMOD_3 equ 0x0060 ; Set/reset
OUTMOD_4 equ 0x0080 ; Toggle
OUTMOD_5 equ 0x00a0 ; Reset
OUTMOD_6 equ 0x00c0 ; Toggle/set
OUTMOD_7 equ 0x00e0 ; Reset/set

CCIE equ 0x0010  ; capture/compare interrupt enable
CCI equ 0x0008   ; capture/compare input
OUT equ 0x0004   ; output high
COV equ 0x0002   ; capture overflow
CCIFG equ 0x0001 ; interrupt pending

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Flash Memory

FCTL3 equ 0x012c          ; Flash control 3
FCTL2 equ 0x012a          ; Flash control 2
FCTL1 equ 0x0128          ; Flash control 1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Watchdog Timer+

WDTCTL equ 0x0120         ; Watchdog/timer control
;WDTPW equ (0x5A<<8)
;WDTHOLD equ (1<<7)

WDTPW equ 0x5a00
WDTHOLD equ 0x0080
WDTNMIES equ 0x0040
WDTNMI equ 0x0020
WDTTMSEL equ 0x0010
WDTCNTCL equ 0x0008
WDTSSEL equ 0x0004
WDTIS0 equ 0x0000
WDTIS1 equ 0x0001
WDTIS2 equ 0x0002
WDTIS3 equ 0x0003

NMIIE equ 0x10
WDTIE equ 0x01

NMIFG equ 0x10
WDTIFG equ 0x01

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ADC10 (MSP430G2x31 only)

ADC10AE0 equ 0x004a       ; ADC analog enable
ADC10DTC1 equ 0x0049      ; ADC data transfer control 1
ADC10DTC0 equ 0x0048      ; ADC data transfer control 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; USI

USICTL0 equ 0x0078        ; USI control 0
USICTL1 equ 0x0079        ; USI control 1
USICKCTL equ 0x007a       ; USI clock control
USICNT equ 0x007b         ; USI bit counter
USISRL equ 0x007c         ; USI shift register low
USISRH equ 0x007d         ; USI shift register high

; word access defines
USICTL equ 0x0078         ; USI control
USICCTL equ 0x007a        ; USI clock and counter control register
USISR equ 0x007c          ; USI shift register

USIPE7   equ 128
USIPE6   equ 64
USIPE5   equ 32
USILSB   equ 16
USIMST   equ 8
USIGE    equ 4
USIOE    equ 2
USISWRST equ 1

USICKPH  equ 128
USII2C   equ 64
USISTTIE equ 32
USIIE    equ 16
USIAL    equ 8
USISTP   equ 4
USISTTIFG equ 2
USIIFG   equ 1

USIDIV_0 equ 0x00
USIDIV_1 equ 0x20
USIDIV_2 equ 0x40
USIDIV_3 equ 0x60
USIDIV_4 equ 0x80
USIDIV_5 equ 0xa0
USIDIV_6 equ 0xc0
USIDIV_7 equ 0xe0

USISSEL_0 equ 0x00
USISSEL_1 equ 0x04
USISSEL_2 equ 0x08
USISSEL_3 equ 0x0c
USISSEL_4 equ 0x10
USISSEL_5 equ 0x14
USISSEL_6 equ 0x18
USISSEL_7 equ 0x1c

USICKPL equ 2
USISWCLK equ 1

USISCLREL equ 128
USI16B equ 64
USIIFGCC equ 32

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Basic Clock System+

BCSCTL3 equ 0x0053        ; Basic clock system control 3
BCSCTL2 equ 0x0058        ; Basic clock system control 2
BCSCTL1 equ 0x0057        ; Basic clock system control 1
DCOCTL equ 0x0056         ; DCO clock frequency control

DCO_0 equ 0x00
DCO_1 equ 0x20
DCO_2 equ 0x40
DCO_3 equ 0x60
DCO_4 equ 0x80
DCO_5 equ 0xa0
DCO_6 equ 0xc0
DCO_7 equ 0xe0

MOD_0 equ 0x00
MOD_1 equ 0x01
MOD_2 equ 0x02
MOD_3 equ 0x03
MOD_4 equ 0x04
MOD_5 equ 0x05
MOD_6 equ 0x06
MOD_7 equ 0x07
MOD_8 equ 0x08
MOD_9 equ 0x09
MOD_10 equ 0x0a
MOD_11 equ 0x0b
MOD_12 equ 0x0c
MOD_13 equ 0x0d
MOD_14 equ 0x0e
MOD_15 equ 0x0f
MOD_16 equ 0x10
MOD_17 equ 0x11
MOD_18 equ 0x12
MOD_19 equ 0x13
MOD_20 equ 0x14
MOD_21 equ 0x15
MOD_22 equ 0x16
MOD_23 equ 0x17
MOD_24 equ 0x18
MOD_25 equ 0x19
MOD_26 equ 0x1a
MOD_27 equ 0x1b
MOD_28 equ 0x1c
MOD_29 equ 0x1d
MOD_30 equ 0x1e
MOD_31 equ 0x1f

XT2OFF  equ 128  ; turn of XT2 oscillator
XTS     equ 64   ; high freq mode

DIVA_0 equ 0x00  ; /1 for ACLK
DIVA_1 equ 0x10  ; /2 for ACLK
DIVA_2 equ 0x20  ; /4 for ACLK
DIVA_3 equ 0x30  ; /8 for ACLK

RSEL_0 equ 0x00
RSEL_1 equ 0x01
RSEL_2 equ 0x02
RSEL_3 equ 0x03
RSEL_4 equ 0x04
RSEL_5 equ 0x05
RSEL_6 equ 0x06
RSEL_7 equ 0x07
RSEL_8 equ 0x08
RSEL_9 equ 0x09
RSEL_10 equ 0x0a
RSEL_11 equ 0x0b
RSEL_12 equ 0x0c
RSEL_13 equ 0x0d
RSEL_14 equ 0x0e
RSEL_15 equ 0x0f


SELM_0  equ 0   ; MCLK is DOCLK
SELM_1  equ 64  ; MCLK is DCOLK
SELM_2  equ 128 ; MCLK is XT2CLK, LFXT1CLK, or VLOCLK
SELM_3  equ 192 ; MCLK is LFX1CLK or VLOCLK

DIVM_0 equ 0x00 ; /1 for MCLK
DIVM_1 equ 0x10 ; /2 for MCLK
DIVM_2 equ 0x20 ; /4 for MCLK
DIVM_3 equ 0x30 ; /8 for MCLK

SELS    equ 8   ; XT2CLK or LFX1CLK or VLOCLK

DIVS_0 equ 0x00 ; /1 for SMCLK
DIVS_1 equ 0x02 ; /2 for SMCLK
DIVS_2 equ 0x04 ; /4 for SMCLK
DIVS_3 equ 0x06 ; /8 for SMCLK

DCOR equ 1  ; external resistor

XT2S_0 equ 0x00
XT2S_1 equ 0x40
XT2S_2 equ 0x80
XT2S_3 equ 0xc0

LFXT1S_0 equ 0x00
LFXT1S_1 equ 0x10
LFXT1S_2 equ 0x20
LFXT1S_3 equ 0x30

XCAP_0 equ 0x00
XCAP_1 equ 0x04
XCAP_2 equ 0x08
XCAP_3 equ 0x0c

XT2OF equ 0x02
LFXT1OF equ 0x01

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Port P2

P2REN equ 0x002f          ; Port P2 resistor enable
P2SEL equ 0x002e          ; Port P2 selection
P2IE equ 0x002d           ; Port P2 interrupt enable
P2IES equ 0x002c          ; Port P2 interrupt edge select
P2IFG equ 0x002b          ; Port P2 interrupt flag
P2DIR equ 0x002a          ; Port P2 direction
P2OUT equ 0x0029          ; Port P2 output
P2IN equ 0x0028           ; Port P2 input

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Port P1

P1REN equ 0x0027          ; Port P1 resistor enable
P1SEL equ 0x0026          ; Port P1 selection
P1IE equ 0x0025           ; Port P1 interrupt enable
P1IES equ 0x0024          ; Port P1 interrupt edge select
P1IFG equ 0x0023          ; Port P1 interrupt flag
P1DIR equ 0x0022          ; Port P1 direction
P1OUT equ 0x0021          ; Port P1 output
P1IN equ 0x0020           ; Port P1 input

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SFR Special Function

IFG2 equ 0x0003           ; SFR interrupt flag 2
IFG1 equ 0x0002           ; SFR interrupt flag 1
IE2 equ 0x0001            ; SFR interrupt enable 2
IE1 equ 0x0000            ; SFR interrupt enable 1

OSCOFF equ 32
OFIFG   equ 2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


