"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTableHeaderCell", {
  enumerable: true,
  get: function get() {
    return _table_header_cell.EuiTableHeaderCell;
  }
});
exports.OuiTableHeaderCell = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _accessibility = require("../accessibility");

var _icon = require("../icon");

var _utils = require("./utils");

var _inner_text = require("../inner_text");

var _services = require("../../services");

var _i18n = require("../i18n");

var _table_header_cell = require("../../eui_components/table/table_header_cell");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; } /*
                                                                                                                                                                                                                                                                                                                     * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                     *
                                                                                                                                                                                                                                                                                                                     * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                     * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                     * compatible open source license.
                                                                                                                                                                                                                                                                                                                     *
                                                                                                                                                                                                                                                                                                                     * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                     * GitHub history for details.
                                                                                                                                                                                                                                                                                                                     */ /*
                                                                                                                                                                                                                                                                                                                         * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                         * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                         * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                         * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                         * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                         * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                         * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                         *
                                                                                                                                                                                                                                                                                                                         *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                         *
                                                                                                                                                                                                                                                                                                                         * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                         * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                         * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                         * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                         * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                         * under the License.
                                                                                                                                                                                                                                                                                                                         */

var CellContents = function CellContents(_ref) {
  var className = _ref.className,
      description = _ref.description,
      children = _ref.children,
      isSorted = _ref.isSorted,
      isSortAscending = _ref.isSortAscending,
      showSortMsg = _ref.showSortMsg;
  return /*#__PURE__*/_react.default.createElement("span", {
    className: className
  }, /*#__PURE__*/_react.default.createElement(_inner_text.OuiInnerText, null, function (ref, innerText) {
    return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiTableHeaderCell.titleTextWithDesc",
      default: "{innerText}; {description}",
      values: {
        innerText: innerText,
        description: description
      }
    }, function (titleTextWithDesc) {
      return /*#__PURE__*/_react.default.createElement("span", {
        title: description ? titleTextWithDesc : innerText,
        ref: ref,
        className: "ouiTableCellContent__text"
      }, children);
    });
  }), description && /*#__PURE__*/_react.default.createElement(_accessibility.OuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, description)), showSortMsg && isSorted && /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
    className: "ouiTableSortIcon",
    type: isSortAscending ? 'sortUp' : 'sortDown',
    size: "m"
  }));
};

var OuiTableHeaderCell = function OuiTableHeaderCell(_ref2) {
  var children = _ref2.children,
      _ref2$align = _ref2.align,
      align = _ref2$align === void 0 ? _services.LEFT_ALIGNMENT : _ref2$align,
      onSort = _ref2.onSort,
      isSorted = _ref2.isSorted,
      isSortAscending = _ref2.isSortAscending,
      className = _ref2.className,
      _ref2$scope = _ref2.scope,
      scope = _ref2$scope === void 0 ? 'col' : _ref2$scope,
      _ref2$mobileOptions = _ref2.mobileOptions,
      mobileOptions = _ref2$mobileOptions === void 0 ? {
    show: true
  } : _ref2$mobileOptions,
      width = _ref2.width,
      style = _ref2.style,
      readOnly = _ref2.readOnly,
      isMobileHeader = _ref2.isMobileHeader,
      hideForMobile = _ref2.hideForMobile,
      description = _ref2.description,
      rest = _objectWithoutProperties(_ref2, ["children", "align", "onSort", "isSorted", "isSortAscending", "className", "scope", "mobileOptions", "width", "style", "readOnly", "isMobileHeader", "hideForMobile", "description"]);

  var classes = (0, _classnames.default)('ouiTableHeaderCell', className, {
    'ouiTableHeaderCell--hideForDesktop': mobileOptions.only || isMobileHeader,
    'ouiTableHeaderCell--hideForMobile': !mobileOptions.show || hideForMobile
  });
  var contentClasses = (0, _classnames.default)('ouiTableCellContent', className, {
    'ouiTableCellContent--alignRight': align === _services.RIGHT_ALIGNMENT,
    'ouiTableCellContent--alignCenter': align === _services.CENTER_ALIGNMENT
  });
  var styleObj = (0, _utils.resolveWidthAsStyle)(style, width);
  var CellComponent = children ? 'th' : 'td';

  if (onSort || isSorted) {
    var buttonClasses = (0, _classnames.default)('ouiTableHeaderButton', {
      'ouiTableHeaderButton-isSorted': isSorted
    });
    var ariaSortValue = 'none';

    if (isSorted) {
      ariaSortValue = isSortAscending ? 'ascending' : 'descending';
    }

    var cellContents = /*#__PURE__*/_react.default.createElement(CellContents, {
      className: contentClasses,
      description: description,
      showSortMsg: true,
      children: children,
      isSorted: isSorted,
      isSortAscending: isSortAscending
    });

    return /*#__PURE__*/_react.default.createElement(CellComponent, _extends({
      className: classes,
      scope: scope,
      role: "columnheader",
      "aria-sort": ariaSortValue,
      "aria-live": "polite",
      style: styleObj
    }, rest), onSort && !readOnly ? /*#__PURE__*/_react.default.createElement("button", {
      type: "button",
      className: buttonClasses,
      onClick: onSort,
      "data-test-subj": "tableHeaderSortButton"
    }, cellContents) : cellContents);
  }

  return /*#__PURE__*/_react.default.createElement(CellComponent, _extends({
    className: classes,
    scope: scope,
    role: "columnheader",
    style: styleObj
  }, rest), /*#__PURE__*/_react.default.createElement(CellContents, {
    className: contentClasses,
    description: description,
    showSortMsg: false,
    children: children,
    isSorted: isSorted,
    isSortAscending: isSortAscending
  }));
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiTableHeaderCell = OuiTableHeaderCell;
OuiTableHeaderCell.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  align: _propTypes.default.oneOf(["left", "right", "center"]),

  /**
       * _DEPRECATED: use `mobileOptions.show = false`_ Indicates if the
       * column should not show for mobile users (typically hidden because a
       * custom mobile header utilizes the column's contents)
       */
  hideForMobile: _propTypes.default.bool,

  /**
       * _DEPRECATED: use `mobileOptions.only = true`_ Indicates if the
       * column was created to be the row's heading in mobile view (this
       * column will be hidden at larger screens)
       */
  isMobileHeader: _propTypes.default.bool,
  isSortAscending: _propTypes.default.bool,
  isSorted: _propTypes.default.bool,

  /**
       * Mobile options for displaying differently at small screens
       */
  mobileOptions: _propTypes.default.shape({
    /**
           * If false, will not render the column at all for mobile
           */
    show: _propTypes.default.bool,

    /**
           * Only show for mobile? If true, will not render the column at all
           * for desktop
           */
    only: _propTypes.default.bool
  }),
  onSort: _propTypes.default.func,
  scope: _propTypes.default.oneOf(["col", "row", "colgroup", "rowgroup"]),
  width: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
  description: _propTypes.default.string,

  /**
       * Shows the sort indicator but removes the button
       */
  readOnly: _propTypes.default.bool
};
/* OUI -> EUI Aliases: Build-Time */