"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiCheckbox", {
  enumerable: true,
  get: function get() {
    return _checkbox.EuiCheckbox;
  }
});
Object.defineProperty(exports, "EuiCompressedCheckbox", {
  enumerable: true,
  get: function get() {
    return _checkbox.EuiCompressedCheckbox;
  }
});
exports.OuiCompressedCheckbox = exports.OuiCheckbox = exports.TYPES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../../common");

var _checkbox = require("../../../eui_components/form/checkbox/checkbox");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } } /*
                                                                                                                                                                                                                                                                                                                                      * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                                      * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                                      * compatible open source license.
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                                      * GitHub history for details.
                                                                                                                                                                                                                                                                                                                                      */ /*
                                                                                                                                                                                                                                                                                                                                          * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                                          * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                                          * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                                          * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                                          * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                                          * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                                          * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                                          * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                                          * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                                          * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                                          * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                                          * under the License.
                                                                                                                                                                                                                                                                                                                                          */

var typeToClassNameMap = {
  inList: 'ouiCheckbox--inList'
};
var TYPES = (0, _common.keysOf)(typeToClassNameMap);
exports.TYPES = TYPES;

var OuiCheckbox = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(OuiCheckbox, _Component);

  var _super = _createSuper(OuiCheckbox);

  function OuiCheckbox() {
    var _this;

    (0, _classCallCheck2.default)(this, OuiCheckbox);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "inputRef", undefined);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setInputRef", function (input) {
      _this.inputRef = input;

      if (_this.props.inputRef) {
        _this.props.inputRef(input);
      }

      _this.invalidateIndeterminate();
    });
    return _this;
  }

  (0, _createClass2.default)(OuiCheckbox, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.invalidateIndeterminate();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.invalidateIndeterminate();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          className = _this$props.className,
          id = _this$props.id,
          checked = _this$props.checked,
          label = _this$props.label,
          onChange = _this$props.onChange,
          type = _this$props.type,
          disabled = _this$props.disabled,
          compressed = _this$props.compressed,
          indeterminate = _this$props.indeterminate,
          inputRef = _this$props.inputRef,
          labelProps = _this$props.labelProps,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["className", "id", "checked", "label", "onChange", "type", "disabled", "compressed", "indeterminate", "inputRef", "labelProps"]);
      var classes = (0, _classnames.default)('ouiCheckbox', type && typeToClassNameMap[type], {
        'ouiCheckbox--noLabel': !label,
        'ouiCheckbox--compressed': compressed
      }, className);
      var labelClasses = (0, _classnames.default)('ouiCheckbox__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
      var optionalLabel;

      if (label) {
        optionalLabel = /*#__PURE__*/_react.default.createElement("label", (0, _extends2.default)({}, labelProps, {
          className: labelClasses,
          htmlFor: id
        }), label);
      }

      return /*#__PURE__*/_react.default.createElement("div", {
        className: classes
      }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
        className: "ouiCheckbox__input",
        type: "checkbox",
        id: id,
        checked: checked,
        onChange: onChange,
        disabled: disabled,
        ref: this.setInputRef
      }, rest)), /*#__PURE__*/_react.default.createElement("div", {
        className: "ouiCheckbox__square"
      }), optionalLabel);
    }
  }, {
    key: "invalidateIndeterminate",
    value: function invalidateIndeterminate() {
      if (this.inputRef) {
        this.inputRef.indeterminate = this.props.indeterminate;
      }
    }
  }]);
  return OuiCheckbox;
}(_react.Component); // @internal


exports.OuiCheckbox = OuiCheckbox;
(0, _defineProperty2.default)(OuiCheckbox, "defaultProps", {
  checked: false,
  disabled: false,
  indeterminate: false,
  compressed: false
});
OuiCheckbox.propTypes = {
  id: _propTypes.default.string.isRequired,
  checked: _propTypes.default.bool,
  onChange: _propTypes.default.any.isRequired,
  // overriding to make it required
  inputRef: _propTypes.default.func,
  label: _propTypes.default.node,
  type: _propTypes.default.oneOf(["inList"]),
  disabled: _propTypes.default.bool,

  /**
     * when `true` creates a shorter height checkbox row
     */
  compressed: _propTypes.default.bool,
  indeterminate: _propTypes.default.bool,

  /**
     * Object of props passed to the <label/>
     */
  labelProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

// @internal
var OuiCompressedCheckbox = /*#__PURE__*/function (_OuiCheckbox) {
  (0, _inherits2.default)(OuiCompressedCheckbox, _OuiCheckbox);

  var _super2 = _createSuper(OuiCompressedCheckbox);

  function OuiCompressedCheckbox() {
    (0, _classCallCheck2.default)(this, OuiCompressedCheckbox);
    return _super2.apply(this, arguments);
  }

  return OuiCompressedCheckbox;
}(OuiCheckbox);
/* OUI -> EUI Aliases: Build-Time */


exports.OuiCompressedCheckbox = OuiCompressedCheckbox;
(0, _defineProperty2.default)(OuiCompressedCheckbox, "defaultProps", _objectSpread(_objectSpread({}, OuiCheckbox.defaultProps), {}, {
  compressed: true
}));
/* OUI -> EUI Aliases: Build-Time */