# -*- coding: utf-8 -*- #
# Copyright 2024 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The command group for key-handles."""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from googlecloudsdk.api_lib.cloudkms import base as cloudkms_base
from googlecloudsdk.calliope import base
from googlecloudsdk.command_lib.kms import flags
from googlecloudsdk.core import resources


@base.UniverseCompatible
@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
class KeyHandles(base.Group):
  """Create and manage key-handles.

  A key-handle is a resource which contains a reference to a KMS CryptoKey
  resource that can be used through existing CMEK channels
  """

  category = base.IDENTITY_AND_SECURITY_CATEGORY

  @classmethod
  def Args(cls, parser):
    parser.display_info.AddUriFunc(
        cloudkms_base.MakeGetUriFunc(flags.KEY_HANDLE_COLLECTION)
    )
