/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.table.ProfileTableModel;
import ca.sqlpower.architect.swingui.table.SQLObjectTableCellRenderer;
import ca.sqlpower.architect.swingui.table.ValueTableCellRenderer;
import ca.sqlpower.swingui.table.DateTableCellRenderer;
import ca.sqlpower.swingui.table.PercentTableCellRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class MultiFreqValueCountTableModel
extends AbstractTableModel {
    private final TableModelListener profileListListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            MultiFreqValueCountTableModel.this.refresh();
        }
    };
    private final ProfileTableModel tm;
    private final List<ColumnValueCount> cvcList = new ArrayList<ColumnValueCount>();

    public MultiFreqValueCountTableModel(ProfileTableModel tm) {
        this.tm = tm;
        tm.addTableModelListener(this.profileListListener);
        this.refresh();
    }

    public void refresh() {
        this.cvcList.clear();
        for (TableProfileResult tpr : this.tm.getTableResultsToScan()) {
            for (ColumnProfileResult cpr : tpr.getColumnProfileResults()) {
                this.cvcList.addAll(cpr.getValueCount());
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.cvcList.size();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Table";
            }
            case 1: {
                return "Column";
            }
            case 2: {
                return "Value";
            }
            case 3: {
                return "Count";
            }
            case 4: {
                return "%";
            }
            case 5: {
                return "Creation Time";
            }
        }
        throw new IllegalArgumentException("Column " + column + " does not exist.");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ColumnValueCount cvc = this.cvcList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return cvc.getParent().getParent().getProfiledObject();
            }
            case 1: {
                return cvc.getParent().getProfiledObject();
            }
            case 2: {
                return cvc.getValue();
            }
            case 3: {
                return cvc.getCount();
            }
            case 4: {
                return cvc.getPercent();
            }
            case 5: {
                return cvc.getParent().getParent().getCreateStartTime();
            }
        }
        throw new IllegalArgumentException("Column at index " + columnIndex + " does not exist.");
    }

    public TableCellRenderer getCellRenderer(int colIndex) {
        switch (colIndex) {
            case 0: 
            case 1: {
                return new SQLObjectTableCellRenderer();
            }
            case 2: 
            case 3: {
                return new ValueTableCellRenderer();
            }
            case 4: {
                return new PercentTableCellRenderer();
            }
            case 5: {
                return new DateTableCellRenderer();
            }
        }
        throw new IllegalArgumentException("No cell renderer for column " + colIndex);
    }
}

