/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileoutput;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.Messages;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileOutput
extends BaseStep
implements StepInterface {
    private static final String FILE_COMPRESSION_TYPE_ZIP = TextFileOutputMeta.fileCompressionTypeCodes[1];
    private static final String FILE_COMPRESSION_TYPE_GZIP = TextFileOutputMeta.fileCompressionTypeCodes[2];
    private TextFileOutputMeta meta;
    private TextFileOutputData data;

    public TextFileOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        boolean result = true;
        Object[] r = this.getRow();
        if (r != null && this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            if (this.data.delayedHeaderWrite) {
                this.writeFieldNames();
            }
            if (this.meta.isFileNameInField()) {
                this.data.fileNameFieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getFileNameField());
                if (this.data.fileNameFieldIndex < 0) {
                    throw new KettleStepException(Messages.getString("TextFileOutput.Exception.FileNameFieldNotFound", this.meta.getFileNameField()));
                }
                this.data.fileNameMeta = this.getInputRowMeta().getValueMeta(this.data.fileNameFieldIndex);
            } else if (this.meta.isDoNotOpenNewFileInit()) {
                this.openNewFile(this.meta.getFileName());
                this.data.oneFileOpened = true;
                this.initBinaryDataFields();
            }
            if (this.meta.getOutputFields() != null) {
                this.data.fieldnrs = new int[this.meta.getOutputFields().length];
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    this.data.fieldnrs[i] = this.data.outputRowMeta.indexOfValue(this.meta.getOutputFields()[i].getName());
                    if (this.data.fieldnrs[i] >= 0) continue;
                    throw new KettleStepException("Field [" + this.meta.getOutputFields()[i].getName() + "] couldn't be found in the input stream!");
                }
            }
        }
        if (r != null) {
            if (this.meta.isFileNameInField()) {
                this.setOutputMetaForFilename(this.data.fileNameMeta.getString(r[this.data.fileNameFieldIndex]));
            }
            if (this.needToSplitFile()) {
                this.closeFile();
                ++this.data.outputMeta.splitnr;
                this.openNewFile(this.meta.getFileName());
            }
        } else {
            this.setOutputDone();
            return false;
        }
        this.writeRowToFile(this.data.outputRowMeta, r);
        this.putRow(this.data.outputRowMeta, r);
        if (this.checkFeedback(this.getLinesOutput())) {
            this.logBasic("linenr " + this.getLinesOutput());
        }
        return result;
    }

    boolean needToSplitFile() {
        long lines = this.getLinesOutput() - this.data.extraLinesWritten;
        int splitEvery = this.meta.getSplitEvery();
        return this.data.isSplitting && lines > 0L && lines % (long)splitEvery == 0L;
    }

    void setOutputMetaForFilename(String filename) throws KettleException {
        if (filename.equals(this.data.lastRowFileName)) {
            return;
        }
        try {
            this.data.lastRowFileName = filename;
            this.data.outputMeta = this.data.outputMetaMap.get(filename);
            if (this.data.outputMeta == null) {
                this.openNewFile(filename);
                this.data.outputMetaMap.put(filename, this.data.outputMeta);
            } else if (this.data.parentZipOutputMeta != null) {
                this.logError("Filenames in row field are not sorted. This is not supported for multi file Zip writing.");
                this.setErrors(1L);
                this.stopAll();
            }
        }
        catch (NullPointerException e) {
            this.logError("Filename in row field was null");
            this.setErrors(1L);
            this.stopAll();
        }
    }

    void writeRowToFile(RowMetaInterface rowMeta, Object[] r) throws KettleStepException {
        try {
            if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                for (int i = 0; i < rowMeta.size(); ++i) {
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.outputMeta.writer.write(this.data.binarySeparator);
                    }
                    ValueMetaInterface v = rowMeta.getValueMeta(i);
                    Object valueData = r[i];
                    this.writeField(v, valueData, null);
                }
                this.data.outputMeta.writer.write(this.data.binaryNewline);
            } else {
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.outputMeta.writer.write(this.data.binarySeparator);
                    }
                    ValueMetaInterface v = rowMeta.getValueMeta(this.data.fieldnrs[i]);
                    Object valueData = r[this.data.fieldnrs[i]];
                    this.writeField(v, valueData, this.data.binaryNullValue[i]);
                }
                this.data.outputMeta.writer.write(this.data.binaryNewline);
            }
            this.incrementLinesOutput();
        }
        catch (Exception e) {
            throw new KettleStepException("Error writing line", (Throwable)e);
        }
    }

    byte[] formatField(ValueMetaInterface v, Object valueData) throws KettleValueException {
        if (v.isString()) {
            String svalue = valueData instanceof String ? (String)valueData : v.getString(valueData);
            return this.convertStringToBinaryString(v, Const.trimToType((String)svalue, (int)v.getTrimType()));
        }
        return v.getBinaryString(valueData);
    }

    byte[] convertStringToBinaryString(ValueMetaInterface v, String string) throws KettleValueException {
        byte[] text;
        int length = v.getLength();
        if (string == null) {
            return new byte[0];
        }
        if (length > -1 && length < string.length()) {
            String tmp = string.substring(0, length);
            if (Const.isEmpty((String)v.getStringEncoding())) {
                return tmp.getBytes();
            }
            try {
                return tmp.getBytes(v.getStringEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new KettleValueException("Unable to convert String to Binary with specified string encoding [" + v.getStringEncoding() + "]", (Throwable)e);
            }
        }
        if (Const.isEmpty((String)v.getStringEncoding())) {
            text = string.getBytes();
        } else {
            try {
                text = string.getBytes(v.getStringEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new KettleValueException("Unable to convert String to Binary with specified string encoding [" + v.getStringEncoding() + "]", (Throwable)e);
            }
        }
        if (length > string.length()) {
            byte[] filler = " ".getBytes();
            int size = text.length + filler.length * (length - string.length());
            byte[] bytes = new byte[size];
            System.arraycopy(text, 0, bytes, 0, text.length);
            if (filler.length == 1) {
                Arrays.fill(bytes, text.length, size, filler[0]);
            }
            return bytes;
        }
        return text;
    }

    byte[] getBinaryString(String string) throws KettleStepException {
        try {
            if (this.data.hasEncoding) {
                return string.getBytes(this.meta.getEncoding());
            }
            return string.getBytes();
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    void writeField(ValueMetaInterface v, Object valueData, byte[] nullString) throws KettleStepException {
        try {
            byte[] str = nullString != null && v.isNull(valueData) ? nullString : (this.meta.isFastDump() ? (valueData instanceof byte[] ? (byte[])valueData : this.getBinaryString(valueData == null ? "" : valueData.toString())) : this.formatField(v, valueData));
            if (str != null && str.length > 0) {
                List<Integer> enclosures = null;
                if (v.isString() && this.meta.isEnclosureForced() && !this.meta.isPadded()) {
                    this.data.outputMeta.writer.write(this.data.binaryEnclosure);
                    enclosures = this.getEnclosurePositions(str);
                }
                if (enclosures == null) {
                    this.data.outputMeta.writer.write(str);
                } else {
                    int from = 0;
                    for (int i = 0; i < enclosures.size(); ++i) {
                        int position = (Integer)enclosures.get(i);
                        this.data.outputMeta.writer.write(str, from, position + this.data.binaryEnclosure.length - from);
                        this.data.outputMeta.writer.write(this.data.binaryEnclosure);
                        from = position + this.data.binaryEnclosure.length;
                    }
                    if (from < str.length) {
                        this.data.outputMeta.writer.write(str, from, str.length - from);
                    }
                }
                if (v.isString() && this.meta.isEnclosureForced() && !this.meta.isPadded()) {
                    this.data.outputMeta.writer.write(this.data.binaryEnclosure);
                }
            }
        }
        catch (Exception e) {
            throw new KettleStepException("Error writing field content to file", (Throwable)e);
        }
    }

    List<Integer> getEnclosurePositions(byte[] str) {
        ArrayList<Integer> positions = null;
        if (this.data.binaryEnclosure != null && this.data.binaryEnclosure.length > 0) {
            for (int i = 0; i < str.length - this.data.binaryEnclosure.length + 1; ++i) {
                boolean found = true;
                for (int x = 0; found && x < this.data.binaryEnclosure.length; ++x) {
                    if (str[i + x] == this.data.binaryEnclosure[x]) continue;
                    found = false;
                }
                if (!found) continue;
                if (positions == null) {
                    positions = new ArrayList<Integer>();
                }
                positions.add(i);
            }
        }
        return positions;
    }

    void writeEndedLine() {
        try {
            String sLine = this.meta.getEndedLine();
            if (sLine != null && sLine.trim().length() > 0) {
                this.data.outputMeta.writer.write(this.getBinaryString(sLine));
                this.data.outputMeta.writer.write(this.data.binaryNewline);
                this.incrementLinesOutput();
                ++this.data.extraLinesWritten;
            }
        }
        catch (Exception e) {
            this.logError("Error writing ended tag line: " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
        }
    }

    void writeFieldNames() throws KettleException {
        RowMetaInterface rowMeta = this.data.outputRowMeta;
        boolean bl = this.data.delayedHeaderWrite = rowMeta == null;
        if (this.data.delayedHeaderWrite) {
            return;
        }
        try {
            if (this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0) {
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    String fieldName = this.meta.getOutputFields()[i].getName();
                    ValueMetaInterface v = rowMeta.searchValueMeta(fieldName);
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.outputMeta.writer.write(this.data.binarySeparator);
                    }
                    if (this.meta.isEnclosureForced() && this.data.binaryEnclosure.length > 0 && v != null && v.isString()) {
                        this.data.outputMeta.writer.write(this.data.binaryEnclosure);
                    }
                    this.data.outputMeta.writer.write(this.getBinaryString(fieldName));
                    if (!this.meta.isEnclosureForced() || this.data.binaryEnclosure.length <= 0 || v == null || !v.isString()) continue;
                    this.data.outputMeta.writer.write(this.data.binaryEnclosure);
                }
                this.data.outputMeta.writer.write(this.data.binaryNewline);
            } else {
                for (int i = 0; i < rowMeta.size(); ++i) {
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.outputMeta.writer.write(this.data.binarySeparator);
                    }
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
                    if (this.meta.isEnclosureForced() && this.data.binaryEnclosure.length > 0 && valueMeta.isString()) {
                        this.data.outputMeta.writer.write(this.data.binaryEnclosure);
                    }
                    this.data.outputMeta.writer.write(this.getBinaryString(valueMeta.getName()));
                    if (!this.meta.isEnclosureForced() || this.data.binaryEnclosure.length <= 0 || !valueMeta.isString()) continue;
                    this.data.outputMeta.writer.write(this.data.binaryEnclosure);
                }
                this.data.outputMeta.writer.write(this.data.binaryNewline);
            }
        }
        catch (Exception e) {
            this.logError("Error writing header line: " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
        }
        this.incrementLinesOutput();
        ++this.data.extraLinesWritten;
    }

    public String buildFilename(String filename, boolean ziparchive) {
        return TextFileOutputMeta.buildFilename(filename, this.meta.getExtension(), this, this.getCopy(), this.getPartitionID(), this.data.outputMeta.splitnr, ziparchive, this.meta);
    }

    public void openNewFile(String baseFilename) throws KettleException {
        if (this.data.outputMeta == null) {
            this.data.outputMeta = new TextFileOutputData.OutputMeta();
        }
        this.data.outputMeta.writer = null;
        boolean fileAlreadyExisted = false;
        this.data.outputMeta.name = this.buildFilename(this.environmentSubstitute(baseFilename), false);
        try {
            if (this.meta.isFileAsCommand()) {
                if (this.log.isDebug()) {
                    this.logDebug("Spawning external process");
                }
                if (this.data.outputMeta.cmdProc != null) {
                    this.logError("Previous command not correctly terminated");
                    this.setErrors(1L);
                }
                String cmdstr = this.environmentSubstitute(this.meta.getFileName());
                if (Const.getOS().equals("Windows 95")) {
                    cmdstr = "command.com /C " + cmdstr;
                } else if (Const.getOS().startsWith("Windows")) {
                    cmdstr = "cmd.exe /C " + cmdstr;
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("Starting: " + cmdstr);
                }
                Runtime r = Runtime.getRuntime();
                this.data.outputMeta.cmdProc = r.exec(cmdstr, EnvUtil.getEnvironmentVariablesForRuntimeExec());
                this.data.outputMeta.writer = this.data.outputMeta.cmdProc.getOutputStream();
                StreamLogger stdoutLogger = new StreamLogger(this.data.outputMeta.cmdProc.getInputStream(), "(stdout)");
                StreamLogger stderrLogger = new StreamLogger(this.data.outputMeta.cmdProc.getErrorStream(), "(stderr)");
                new Thread((Runnable)stdoutLogger).start();
                new Thread((Runnable)stderrLogger).start();
            } else {
                OutputStream outputStream;
                if (FILE_COMPRESSION_TYPE_ZIP.equals(this.meta.getFileCompression())) {
                    if (this.data.parentZipOutputMeta == null) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Opening output stream in zipped mode", new Object[0]);
                        }
                        fileAlreadyExisted = false;
                        this.data.parentZipOutputMeta = new TextFileOutputData.OutputMeta();
                        this.data.parentZipOutputMeta.name = this.meta.isFileNameInField() ? this.buildFilename(this.environmentSubstitute(this.meta.getFileName()), true) : this.buildFilename(this.environmentSubstitute(baseFilename), true);
                        this.data.parentZipOutputStream = new ZipOutputStream(KettleVFS.getOutputStream((FileObject)KettleVFS.getFileObject((String)this.data.parentZipOutputMeta.name), (boolean)this.meta.isFileAppended()));
                        outputStream = this.data.parentZipOutputStream;
                    } else {
                        this.data.parentZipOutputMeta.writer.flush();
                        outputStream = null;
                    }
                    ZipEntry zipEntry = new ZipEntry(this.data.outputMeta.name);
                    zipEntry.setComment("Compressed by Kettle");
                    this.data.parentZipOutputStream.putNextEntry(zipEntry);
                } else {
                    FileObject f = KettleVFS.getFileObject((String)this.data.outputMeta.name);
                    fileAlreadyExisted = f.exists();
                    outputStream = KettleVFS.getOutputStream((FileObject)f, (boolean)this.meta.isFileAppended());
                    if (FILE_COMPRESSION_TYPE_GZIP.equals(this.meta.getFileCompression())) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "Opening output stream in gzipped mode", new Object[0]);
                        }
                        outputStream = new GZIPOutputStream(outputStream);
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Opening output stream in nocompress mode", new Object[0]);
                    }
                }
                if (this.data.hasEncoding) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Opening output stream in encoding: " + this.meta.getEncoding(), new Object[0]);
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Opening output stream in default encoding", new Object[0]);
                }
                if (FILE_COMPRESSION_TYPE_ZIP.equals(this.meta.getFileCompression())) {
                    if (this.data.parentZipOutputMeta.writer == null) {
                        this.data.parentZipOutputMeta.writer = new BufferedOutputStream(outputStream, 5000);
                    }
                    this.data.outputMeta.writer = this.data.parentZipOutputMeta.writer;
                } else {
                    this.data.outputMeta.writer = new BufferedOutputStream(outputStream, 5000);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("Opened new file with name [" + this.data.outputMeta.name + "]");
                }
                if (this.meta.isAddToResultFiles()) {
                    ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)this.data.outputMeta.name), this.getTransMeta().getName(), this.getStepname());
                    resultFile.setComment("This file was created with a text file output step");
                    this.addResultFile(resultFile);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Error opening new file : " + e.toString());
        }
        if (!(!this.meta.isHeaderEnabled() || fileAlreadyExisted && this.meta.isFileAppended())) {
            this.writeFieldNames();
        }
        this.incrementLinesUpdated();
    }

    void closeFile() {
        block11: {
            if (this.data.outputMeta.writer == null) {
                return;
            }
            try {
                int procStatus;
                block12: {
                    if (!this.meta.isFileAppended()) {
                        if (this.meta.isFooterEnabled()) {
                            this.writeFieldNames();
                        }
                        this.writeEndedLine();
                    }
                    if (this.log.isDebug()) {
                        this.logDebug("Closing output stream: " + this.data.outputMeta.name);
                    }
                    this.data.outputMeta.writer.close();
                    if (this.log.isDebug()) {
                        this.logDebug("Closed output stream: " + this.data.outputMeta.name);
                    }
                    this.data.outputMeta.writer = null;
                    this.data.parentZipOutputMeta = null;
                    this.data.parentZipOutputStream = null;
                    if (this.data.outputMeta.cmdProc == null) break block11;
                    if (this.log.isDebug()) {
                        this.logDebug("Waiting for external command to terminate: " + this.data.outputMeta.name);
                    }
                    procStatus = this.data.outputMeta.cmdProc.waitFor();
                    try {
                        this.data.outputMeta.cmdProc.getErrorStream().close();
                        this.data.outputMeta.cmdProc.getInputStream().close();
                    }
                    catch (IOException e) {
                        if (!this.log.isDetailed()) break block12;
                        this.logDetailed("Warning: Error closing external command stream (" + this.data.outputMeta.name + "): " + e.getMessage());
                    }
                }
                this.data.outputMeta.cmdProc = null;
                if (this.log.isBasic() && procStatus != 0) {
                    this.logBasic("External command exit status (" + this.data.outputMeta.name + "): " + procStatus);
                }
            }
            catch (Exception e) {
                this.logError("Exception trying to close file (" + this.data.outputMeta.name + "): " + e.toString());
                this.setErrors(1L);
            }
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.isDoNotOpenNewFileInit() && !this.meta.isFileNameInField()) {
                try {
                    this.openNewFile(this.meta.getFileName());
                    this.data.oneFileOpened = true;
                }
                catch (Exception e) {
                    this.logError("Couldn't open file " + this.meta.getFileName(), e);
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            try {
                this.initBinaryDataFields();
            }
            catch (Exception e) {
                this.logError("Couldn't initialize binary data fields", e);
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.isSplitting = this.meta.getSplitEvery() > 0;
            return true;
        }
        return false;
    }

    void initBinaryDataFields() throws KettleException {
        try {
            this.data.hasEncoding = !Const.isEmpty((String)this.meta.getEncoding());
            this.data.binarySeparator = new byte[0];
            this.data.binaryEnclosure = new byte[0];
            this.data.binaryNewline = new byte[0];
            if (this.data.hasEncoding) {
                if (!Const.isEmpty((String)this.meta.getSeparator())) {
                    this.data.binarySeparator = this.environmentSubstitute(this.meta.getSeparator()).getBytes(this.meta.getEncoding());
                }
                if (!Const.isEmpty((String)this.meta.getEnclosure())) {
                    this.data.binaryEnclosure = this.environmentSubstitute(this.meta.getEnclosure()).getBytes(this.meta.getEncoding());
                }
                if (!Const.isEmpty((String)this.meta.getNewline())) {
                    this.data.binaryNewline = this.meta.getNewline().getBytes(this.meta.getEncoding());
                }
            } else {
                if (!Const.isEmpty((String)this.meta.getSeparator())) {
                    this.data.binarySeparator = this.environmentSubstitute(this.meta.getSeparator()).getBytes();
                }
                if (!Const.isEmpty((String)this.meta.getEnclosure())) {
                    this.data.binaryEnclosure = this.environmentSubstitute(this.meta.getEnclosure()).getBytes();
                }
                if (!Const.isEmpty((String)this.meta.getNewline())) {
                    this.data.binaryNewline = this.environmentSubstitute(this.meta.getNewline()).getBytes();
                }
            }
            if (this.meta.getOutputFields() != null) {
                this.data.binaryNullValue = new byte[this.meta.getOutputFields().length][];
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    this.data.binaryNullValue[i] = null;
                    String nullString = this.meta.getOutputFields()[i].getNullString();
                    if (Const.isEmpty((String)nullString)) continue;
                    this.data.binaryNullValue[i] = this.data.hasEncoding ? nullString.getBytes(this.meta.getEncoding()) : nullString.getBytes();
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error while encoding binary fields", (Throwable)e);
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        if (this.data.oneFileOpened) {
            this.closeFile();
        } else {
            Iterator<TextFileOutputData.OutputMeta> i$ = this.data.outputMetaMap.values().iterator();
            while (i$.hasNext()) {
                TextFileOutputData.OutputMeta outputMeta;
                this.data.outputMeta = outputMeta = i$.next();
                this.closeFile();
            }
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

