/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import com.google.common.collect.Ordering;
import io.usethesource.capsule.Set;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.configurationcache.extensions.CharSequenceExtensionsKt;
import org.gradle.configurationcache.problems.ConfigurationCacheProblemsSummaryKt;
import org.gradle.configurationcache.problems.ProblemSeverity;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.UniquePropertyProblem;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/BC\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u001a0\u001a2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001cJ(\u0010(\u001a\u00020)*\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/gradle/configurationcache/problems/Summary;", "", "problemCount", "", "failureCount", "suppressedCount", "uniqueProblems", "Lio/usethesource/capsule/Set$Immutable;", "Lorg/gradle/configurationcache/problems/UniquePropertyProblem;", "causes", "", "", "overflowed", "", "(IIILio/usethesource/capsule/Set$Immutable;Ljava/util/List;Z)V", "getCauses", "()Ljava/util/List;", "getFailureCount", "()I", "nonSuppressedProblemCount", "getNonSuppressedProblemCount", "getOverflowed", "()Z", "getProblemCount", "getSuppressedCount", "buildSummaryReportLink", "", "reportFile", "Ljava/io/File;", "clickableUrlFor", "kotlin.jvm.PlatformType", "file", "insert", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "severity", "Lorg/gradle/configurationcache/problems/ProblemSeverity;", "textForConsole", "cacheActionText", "htmlReportFile", "appendSummaryHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "cacheAction", "totalProblemCount", "uniqueProblemCount", "Companion", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheProblemsSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/configurationcache/problems/Summary\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1#2:219\n1855#3,2:220\n*S KotlinDebug\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/configurationcache/problems/Summary\n*L\n145#1:220,2\n*E\n"})
public final class Summary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int problemCount;
    private final int failureCount;
    private final int suppressedCount;
    @NotNull
    private final Set.Immutable<UniquePropertyProblem> uniqueProblems;
    @NotNull
    private final List<Throwable> causes;
    private final boolean overflowed;
    @NotNull
    private static final Summary empty;

    private Summary(int problemCount, int failureCount, int suppressedCount, Set.Immutable<UniquePropertyProblem> uniqueProblems, List<? extends Throwable> causes, boolean overflowed) {
        this.problemCount = problemCount;
        this.failureCount = failureCount;
        this.suppressedCount = suppressedCount;
        this.uniqueProblems = uniqueProblems;
        this.causes = causes;
        this.overflowed = overflowed;
    }

    public final int getProblemCount() {
        return this.problemCount;
    }

    public final int getFailureCount() {
        return this.failureCount;
    }

    public final int getSuppressedCount() {
        return this.suppressedCount;
    }

    @NotNull
    public final List<Throwable> getCauses() {
        return this.causes;
    }

    public final boolean getOverflowed() {
        return this.overflowed;
    }

    public final int getNonSuppressedProblemCount() {
        return this.problemCount - this.suppressedCount;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Summary insert(@NotNull PropertyProblem problem, @NotNull ProblemSeverity severity) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        newProblemCount = this.problemCount + 1;
        newFailureCount = severity == ProblemSeverity.Failure ? this.failureCount + 1 : this.failureCount;
        v0 = newSuppressedCount = severity == ProblemSeverity.Suppressed ? this.suppressedCount + 1 : this.suppressedCount;
        if (this.overflowed || newProblemCount > 4096) {
            return new Summary(newProblemCount, newFailureCount, newSuppressedCount, this.uniqueProblems, this.causes, true);
        }
        uniqueProblem = UniquePropertyProblem.Companion.of(problem);
        newUniqueProblems = this.uniqueProblems.__insert((Object)uniqueProblem);
        var10_8 = problem;
        it = var10_8;
        $i$a$-takeIf-Summary$insert$newCauses$1 = false;
        v1 = var9_11 = (newUniqueProblems != this.uniqueProblems && this.causes.size() < 5) != false ? var10_8 : null;
        if (var9_11 == null || (var10_8 = var9_11.getException()) == null) ** GOTO lbl-1000
        it = var10_8;
        $i$a$-let-Summary$insert$newCauses$2 = false;
        var11_9 = CollectionsKt.plus((Collection)this.causes, (Object)it);
        if (var11_9 != null) {
            v2 = var11_9;
        } else lbl-1000:
        // 2 sources

        {
            v2 = this.causes;
        }
        newCauses = v2;
        Intrinsics.checkNotNullExpressionValue((Object)newUniqueProblems, (String)"newUniqueProblems");
        return new Summary(newProblemCount, newFailureCount, newSuppressedCount, (Set.Immutable<UniquePropertyProblem>)newUniqueProblems, newCauses, false);
    }

    @NotNull
    public final String textForConsole(@NotNull String cacheActionText, @NotNull File htmlReportFile) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)cacheActionText, (String)"cacheActionText");
        Intrinsics.checkNotNullParameter((Object)htmlReportFile, (String)"htmlReportFile");
        DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        int uniqueProblemCount = this.uniqueProblems.size();
        StringBuilder $this$textForConsole_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$textForConsole_u24lambda_u244.append('\n'), (String)"append('\\n')");
        this.appendSummaryHeader($this$textForConsole_u24lambda_u244, cacheActionText, this.problemCount, uniqueProblemCount);
        Intrinsics.checkNotNullExpressionValue((Object)$this$textForConsole_u24lambda_u244.append('\n'), (String)"append('\\n')");
        List list = Ordering.from((Comparator)ConfigurationCacheProblemsSummaryKt.access$consoleComparator()).leastOf((Iterable)this.uniqueProblems, 15);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"from(consoleComparator()\u2026lems, maxConsoleProblems)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            UniquePropertyProblem problem2 = (UniquePropertyProblem)element$iv;
            boolean bl2 = false;
            $this$textForConsole_u24lambda_u244.append("- ");
            $this$textForConsole_u24lambda_u244.append(CharSequenceExtensionsKt.capitalized(problem2.getUserCodeLocation()));
            $this$textForConsole_u24lambda_u244.append(": ");
            StringBuilder stringBuilder2 = $this$textForConsole_u24lambda_u244.append(problem2.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            if (problem2.getDocumentationSection() == null) continue;
            boolean bl3 = false;
            StringBuilder stringBuilder3 = $this$textForConsole_u24lambda_u244.append("  See " + documentationRegistry.getDocumentationFor("configuration_cache", it));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        if (uniqueProblemCount > 15) {
            StringBuilder stringBuilder4 = $this$textForConsole_u24lambda_u244.append("plus " + (uniqueProblemCount - 15) + " more problems. Please see the report for details.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$textForConsole_u24lambda_u244.append('\n'), (String)"append('\\n')");
        $this$textForConsole_u24lambda_u244.append(this.buildSummaryReportLink(htmlReportFile));
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply {\n\u2026le))\n        }.toString()");
        return string2;
    }

    private final void appendSummaryHeader(StringBuilder $this$appendSummaryHeader, String cacheAction, int totalProblemCount, int uniqueProblemCount) {
        $this$appendSummaryHeader.append(totalProblemCount);
        $this$appendSummaryHeader.append(totalProblemCount == 1 ? " problem was found " : " problems were found ");
        $this$appendSummaryHeader.append(cacheAction);
        $this$appendSummaryHeader.append(" the configuration cache");
        if (this.overflowed) {
            $this$appendSummaryHeader.append(", only the first ");
            $this$appendSummaryHeader.append(4096);
            $this$appendSummaryHeader.append(" were considered");
        }
        if (totalProblemCount != uniqueProblemCount) {
            $this$appendSummaryHeader.append(", ");
            $this$appendSummaryHeader.append(uniqueProblemCount);
            $this$appendSummaryHeader.append(" of which ");
            $this$appendSummaryHeader.append(uniqueProblemCount == 1 ? "seems unique" : "seem unique");
        }
        $this$appendSummaryHeader.append(".");
    }

    private final String buildSummaryReportLink(File reportFile) {
        return "See the complete report at " + this.clickableUrlFor(reportFile);
    }

    private final String clickableUrlFor(File file) {
        return new ConsoleRenderer().asClickableFileUrl(file);
    }

    static {
        Set.Immutable immutable = Set.Immutable.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutable, (String)"of()");
        empty = new Summary(0, 0, 0, (Set.Immutable<UniquePropertyProblem>)immutable, CollectionsKt.emptyList(), false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gradle/configurationcache/problems/Summary$Companion;", "", "()V", "empty", "Lorg/gradle/configurationcache/problems/Summary;", "getEmpty", "()Lorg/gradle/configurationcache/problems/Summary;", "configuration-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Summary getEmpty() {
            return empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

