/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.util.exception.ExceptionUtil;

public class XmlFileIndexerProvider
extends AbstractIndexerProvider {
    protected XMLInputFactory factory = XMLInputFactory.newInstance();

    public XmlFileIndexerProvider() {
        this.factory.setProperty("javax.xml.stream.supportDTD", false);
    }

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(API api, Container.Entry entry, Indexes indexes) {
        HashSet<String> stringSet = new HashSet<String>();
        HashSet<String> typeReferenceSet = new HashSet<String>();
        XMLStreamReader reader = null;
        try {
            reader = this.factory.createXMLStreamReader(entry.getInputStream());
            stringSet.add(reader.getVersion());
            stringSet.add(reader.getEncoding());
            stringSet.add(reader.getCharacterEncodingScheme());
            block20: while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        int i;
                        boolean beanFlag = reader.getLocalName().equals("bean");
                        stringSet.add(reader.getLocalName());
                        for (i = reader.getAttributeCount() - 1; i >= 0; --i) {
                            String attributeName = reader.getAttributeLocalName(i);
                            stringSet.add(attributeName);
                            if (beanFlag && attributeName.equals("class")) {
                                typeReferenceSet.add(reader.getAttributeValue(i).replace(".", "/"));
                                continue;
                            }
                            stringSet.add(reader.getAttributeValue(i));
                        }
                        for (i = reader.getNamespaceCount() - 1; i >= 0; --i) {
                            stringSet.add(reader.getNamespacePrefix(i));
                            stringSet.add(reader.getNamespaceURI(i));
                        }
                        continue block20;
                    }
                    case 3: {
                        stringSet.add(reader.getPITarget());
                        stringSet.add(reader.getPIData());
                        break;
                    }
                    case 7: {
                        stringSet.add(reader.getVersion());
                        stringSet.add(reader.getEncoding());
                        stringSet.add(reader.getCharacterEncodingScheme());
                        break;
                    }
                    case 9: {
                        stringSet.add(reader.getLocalName());
                        stringSet.add(reader.getText());
                        break;
                    }
                    case 10: {
                        stringSet.add(reader.getPrefix());
                        stringSet.add(reader.getNamespaceURI());
                        stringSet.add(reader.getLocalName());
                        stringSet.add(reader.getText());
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 11: 
                    case 12: {
                        stringSet.add(reader.getText().trim());
                        break;
                    }
                    case 13: {
                        int i;
                        for (i = reader.getNamespaceCount() - 1; i >= 0; --i) {
                            stringSet.add(reader.getNamespacePrefix(i));
                            stringSet.add(reader.getNamespaceURI(i));
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            assert (ExceptionUtil.printStackTrace(e));
        }
        finally {
            block30: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block30;
                        throw new AssertionError();
                    }
                }
            }
        }
        Map<String, Collection> stringIndex = indexes.getIndex("strings");
        Map<String, Collection> typeReferenceIndex = indexes.getIndex("typeReferences");
        for (String string : stringSet) {
            if (string == null || string.isEmpty()) continue;
            stringIndex.get(string).add(entry);
        }
        for (String ref : typeReferenceSet) {
            if (ref == null || ref.isEmpty()) continue;
            typeReferenceIndex.get(ref).add(entry);
        }
    }
}

