/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.view.component.HyperlinkPage;
import org.jd.gui.view.component.TypeReferencePage;

public class OneTypeReferencePerLinePage
extends TypeReferencePage
implements UriGettable,
IndexesChangeListener {
    protected API api;
    protected Container.Entry entry;
    protected Collection<Future<Indexes>> collectionOfFutureIndexes;

    public OneTypeReferencePerLinePage(API api, Container.Entry entry) {
        StringBuilder sb;
        block16: {
            this.collectionOfFutureIndexes = Collections.emptyList();
            this.api = api;
            this.entry = entry;
            sb = new StringBuilder();
            int offset = 0;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(entry.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    String trim = line.trim();
                    if (trim.length() > 0) {
                        int startIndex = offset + line.indexOf(trim);
                        int endIndex = startIndex + trim.length();
                        String internalTypeName = trim.replace('.', '/');
                        this.addHyperlink(new TypeReferencePage.TypeHyperlinkData(startIndex, endIndex, internalTypeName));
                    }
                    offset += line.length() + 1;
                    sb.append(line).append('\n');
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block16;
                throw new AssertionError();
            }
        }
        this.setText(sb.toString());
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkPage.HyperlinkData hyperlinkData) {
        return ((TypeReferencePage.TypeHyperlinkData)hyperlinkData).enabled;
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkPage.HyperlinkData hyperlinkData) {
        block7: {
            TypeReferencePage.TypeHyperlinkData data = (TypeReferencePage.TypeHyperlinkData)hyperlinkData;
            if (data.enabled) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel(new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    String internalTypeName = data.internalTypeName;
                    List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, internalTypeName);
                    String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                    ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                    for (Container.Entry entry : entries) {
                        if (!entry.getUri().toString().startsWith(rootUri)) continue;
                        sameContainerEntries.add(entry);
                    }
                    if (sameContainerEntries.size() > 0) {
                        this.api.openURI(x, y, sameContainerEntries, null, data.internalTypeName);
                    } else if (entries.size() > 0) {
                        this.api.openURI(x, y, entries, null, data.internalTypeName);
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        for (Map.Entry entry : this.hyperlinks.entrySet()) {
            TypeReferencePage.TypeHyperlinkData entryData = (TypeReferencePage.TypeHyperlinkData)entry.getValue();
            String internalTypeName = entryData.internalTypeName;
            boolean enabled = IndexesUtil.containsInternalTypeName(collectionOfFutureIndexes, internalTypeName);
            if (entryData.enabled == enabled) continue;
            entryData.enabled = enabled;
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }
}

