/*
 * Decompiled with CFR 0.152.
 */
package tr.runtime;

import org.openide.util.Utilities;
import tr.runtime.StreamConsumer;

public class Runtime {
    private static final String osName = System.getProperty("os.name").toLowerCase();
    public static final boolean linux = Utilities.getOperatingSystem() == 16;
    public static final boolean macosx = Utilities.getOperatingSystem() == 4096;
    public static final boolean win95 = Utilities.getOperatingSystem() == 2;
    public static final boolean win98 = Utilities.getOperatingSystem() == 4;
    public static final boolean windows = Utilities.isWindows();
    public static final boolean unix = Utilities.isUnix();

    public static void exec(String[] cmd) {
        try {
            Process process = java.lang.Runtime.getRuntime().exec(cmd);
            StreamConsumer stderrConsumer = new StreamConsumer(process.getErrorStream());
            StreamConsumer stdoutConsumer = new StreamConsumer(process.getInputStream());
            stderrConsumer.start();
            stdoutConsumer.start();
            process.waitFor();
            stderrConsumer.terminate();
            stdoutConsumer.terminate();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

