/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SessionTicketTLSExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SessionTicketTLSExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.SessionTicketTLSExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.SessionTicketTLSExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionTicketTlsExtensionHandler
extends ExtensionHandler<SessionTicketTLSExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SessionTicketTlsExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public SessionTicketTLSExtensionParser getParser(byte[] message, int pointer) {
        return new SessionTicketTLSExtensionParser(pointer, message);
    }

    public SessionTicketTLSExtensionPreparator getPreparator(SessionTicketTLSExtensionMessage message) {
        return new SessionTicketTLSExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public SessionTicketTLSExtensionSerializer getSerializer(SessionTicketTLSExtensionMessage message) {
        return new SessionTicketTLSExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(SessionTicketTLSExtensionMessage message) {
        if ((Integer)message.getExtensionLength().getValue() > 65535) {
            LOGGER.warn("The SessionTLS ticket length shouldn't exceed 2 bytes as defined in RFC 4507. Length was " + message.getExtensionLength().getValue());
        }
        this.context.setSessionTicketTLS((byte[])message.getTicket().getValue());
        LOGGER.debug("The context SessionTLS ticket was set to " + ArrayConverter.bytesToHexString((ModifiableByteArray)message.getTicket()));
    }
}

