/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignedCertificateTimestampExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SignedCertificateTimestampExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.SignedCertificateTimestampExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.SignedCertificateTimestampExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignedCertificateTimestampExtensionHandler
extends ExtensionHandler<SignedCertificateTimestampExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SignedCertificateTimestampExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public SignedCertificateTimestampExtensionParser getParser(byte[] message, int pointer) {
        return new SignedCertificateTimestampExtensionParser(pointer, message);
    }

    public SignedCertificateTimestampExtensionPreparator getPreparator(SignedCertificateTimestampExtensionMessage message) {
        return new SignedCertificateTimestampExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public SignedCertificateTimestampExtensionSerializer getSerializer(SignedCertificateTimestampExtensionMessage message) {
        return new SignedCertificateTimestampExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(SignedCertificateTimestampExtensionMessage message) {
        if ((Integer)message.getExtensionLength().getValue() > 65535) {
            LOGGER.warn("The SingedCertificateTimestamp length shouldn't exceed 2 bytes as defined in RFC 6962. Length was " + message.getExtensionLength().getValue());
        }
        this.context.setSignedCertificateTimestamp((byte[])message.getSignedTimestamp().getValue());
        LOGGER.debug("The context SignedCertificateTimestamp was set to " + ArrayConverter.bytesToHexString((ModifiableByteArray)message.getSignedTimestamp()));
    }
}

