/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import org.netbeans.core.UIExceptions;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class HtmlBrowser {

    public static class FactoryEditor
    extends PropertyEditorSupport {
        private static final String EA_HIDDEN = "hidden";
        private static final String BROWSER_FOLDER = "Services/Browsers";

        @Override
        public String getAsText() {
            try {
                HtmlBrowser.Factory factory = (HtmlBrowser.Factory)this.getValue();
                Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)factory));
                if (item != null) {
                    return item.getDisplayName();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            return NbBundle.getMessage(FactoryEditor.class, (String)"CTL_UnspecifiedBrowser");
        }

        @Override
        public void setAsText(String string) throws IllegalArgumentException {
            try {
                if (NbBundle.getMessage(FactoryEditor.class, (String)"CTL_UnspecifiedBrowser").equals(string) || string == null) {
                    this.setValue(null);
                    return;
                }
                Lookup.Result result = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);
                for (Lookup.Item item : result.allItems()) {
                    if (!string.equals(item.getDisplayName())) continue;
                    this.setValue(item.getInstance());
                    return;
                }
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exception.getMessage());
                String string2 = exception.getLocalizedMessage();
                if (string2 == null) {
                    string2 = MessageFormat.format(NbBundle.getMessage(HtmlBrowser.class, (String)"FMT_EXC_GENERIC_BAD_VALUE"), string);
                }
                UIExceptions.annotateUser(illegalArgumentException, string, string2, exception, new Date());
                throw illegalArgumentException;
            }
        }

        @Override
        public String[] getTags() {
            String[] stringArray2;
            ArrayList<String> arrayList = new ArrayList<String>(6);
            Lookup.Result result = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);
            for (String[] stringArray2 : result.allItems()) {
                arrayList.add(stringArray2.getDisplayName());
            }
            FileObject fileObject = FileUtil.getConfigFile((String)BROWSER_FOLDER);
            if (fileObject != null) {
                stringArray2 = DataFolder.findFolder((FileObject)fileObject);
                DataObject[] dataObjectArray = stringArray2.getChildren();
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    if (!Boolean.TRUE.equals(dataObjectArray[i].getPrimaryFile().getAttribute(EA_HIDDEN)) && dataObjectArray[i].getCookie(InstanceCookie.class) != null) continue;
                    FileObject fileObject2 = dataObjectArray[i].getPrimaryFile();
                    String string = fileObject2.getName();
                    try {
                        string = fileObject2.getFileSystem().getDecorator().annotateName(string, dataObjectArray[i].files());
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                    arrayList.remove(string);
                }
            }
            stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            return stringArray2;
        }
    }
}

