untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEiyl/qtFfXfDbX7zuiP15xPBL3O026r+ANF9WzRbRswK7TsCYexi7AxeDAVVEFP9OKQNwxYQvA5Q7+JBYoeyUQM=

OpenBSD 6.1 errata 030, October 4th, 2017:

Correctly handle exceptions when restoring an invalid FPU context.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 030_xrstor.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/fpu.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/fpu.c,v
retrieving revision 1.35
diff -u -p -u -r1.35 fpu.c
--- sys/arch/amd64/amd64/fpu.c	29 May 2017 14:19:49 -0000	1.35
+++ sys/arch/amd64/amd64/fpu.c	3 Oct 2017 04:38:35 -0000
@@ -55,6 +55,8 @@
 
 #include <dev/isa/isavar.h>
 
+void	xrstor_user(struct savefpu *_addr, uint64_t _mask);
+
 /*
  * We do lazy initialization and switching using the TS bit in cr0 and the
  * MDP_USEDFPU bit in mdproc.
@@ -253,7 +255,7 @@ fpudna(struct cpu_info *ci)
 		p->p_md.md_flags |= MDP_USEDFPU;
 	} else {
 		if (xsave_mask) {
-			xrstor(sfp, xsave_mask);
+			xrstor_user(sfp, xsave_mask);
 		} else {
 			static double	zero = 0.0;
 
Index: sys/arch/amd64/amd64/locore.S
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/locore.S,v
retrieving revision 1.87
diff -u -p -u -r1.87 locore.S
--- sys/arch/amd64/amd64/locore.S	6 Jul 2017 06:17:04 -0000	1.87
+++ sys/arch/amd64/amd64/locore.S	3 Oct 2017 04:38:35 -0000
@@ -691,6 +691,15 @@ _C_LABEL(doreti_iret):
 	iretq
 #endif /* !defined(GPROF) && defined(DDBPROF) */
 
+ENTRY(xrstor_user)
+	movq	%rsi, %rdx
+	movl	%esi, %eax
+	shrq	$32, %rdx
+	.globl	xrstor_fault
+xrstor_fault:
+	xrstor	(%rdi)
+	ret
+
 ENTRY(pagezero)
 	movq    $-PAGE_SIZE,%rdx
 	subq    %rdx,%rdi
Index: sys/arch/amd64/amd64/trap.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/trap.c,v
retrieving revision 1.58
diff -u -p -u -r1.58 trap.c
--- sys/arch/amd64/amd64/trap.c	16 Sep 2017 02:03:40 -0000	1.58
+++ sys/arch/amd64/amd64/trap.c	3 Oct 2017 04:38:35 -0000
@@ -144,7 +144,7 @@ trap(struct trapframe *frame)
 	struct proc *p = curproc;
 	int type = (int)frame->tf_trapno;
 	struct pcb *pcb;
-	extern char doreti_iret[], resume_iret[];
+	extern char doreti_iret[], resume_iret[], xrstor_fault[];
 	caddr_t onfault;
 	int error;
 	uint64_t cr2;
@@ -204,6 +204,15 @@ trap(struct trapframe *frame)
 		/*NOTREACHED*/
 
 	case T_PROTFLT:
+		/*
+		 * Check for xrstor faulting because of invalid xstate
+		 * We do this by looking at the address of the
+		 * instruction that faulted.
+		 */
+		if (frame->tf_rip == (u_int64_t)xrstor_fault && p != NULL) {
+			fpusave_proc(p, 0);
+			goto user_trap;
+		}
 	case T_SEGNPFLT:
 	case T_ALIGNFLT:
 	case T_TSSFLT:
@@ -231,6 +240,7 @@ copyfault:
 	case T_TSSFLT|T_USER:
 	case T_SEGNPFLT|T_USER:
 	case T_STKFLT|T_USER:
+user_trap:
 #ifdef TRAP_SIGDEBUG
 		printf("pid %d (%s): %s at rip %llx addr %llx\n",
 		    p->p_p->ps_pid, p->p_p->ps_comm, "BUS",
