untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTU2AT3ZkTD2GOFlSLAW6A8X8OV8Igk3MHkF5I7yutfIc4FYKQ31mE6v+GtvflVUGM0AyeKTxli8AKMGOWnz51Qo=

OpenBSD 7.1 errata 020, January 21, 2023:

vmm(4) exposed unsupported cpuid feature flags to guests.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 020_vmm.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/vmm.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/vmm.c,v
retrieving revision 1.305
diff -u -p -u -r1.305 vmm.c
--- sys/arch/amd64/amd64/vmm.c	28 Mar 2022 06:28:47 -0000	1.305
+++ sys/arch/amd64/amd64/vmm.c	19 Jan 2023 16:25:02 -0000
@@ -7007,7 +7007,8 @@ vmm_handle_cpuid(struct vcpu *vcpu)
 		if (subleaf == 0) {
 			*rax = 0;	/* Highest subleaf supported */
 			*rbx = curcpu()->ci_feature_sefflags_ebx & VMM_SEFF0EBX_MASK;
-			*rcx = curcpu()->ci_feature_sefflags_ecx & VMM_SEFF0ECX_MASK;
+#define VMM_SEFF0ECX_MASK_T (SEFF0ECX_UMIP)
+			*rcx = curcpu()->ci_feature_sefflags_ecx & VMM_SEFF0ECX_MASK_T;
 			*rdx = curcpu()->ci_feature_sefflags_edx & VMM_SEFF0EDX_MASK;
 		} else {
 			/* Unsupported subleaf */
