untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8Ew4TMhKHkAA7e7xhS0x/wV0rXJHsteFzvx+uRHbcTVysmsyIZY0UAUydRT8kQVfz2tmXccy7X6yVtlPBedaRQs=

OpenBSD 7.2 errata 029, July 12, 2023:

A malformed HTTP request can crash httpd(8), if fastcgi is in use.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 029_httpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install httpd(8):
    cd /usr/src/usr.sbin/httpd
    make obj
    make
    make install

Index: usr.sbin/httpd/httpd.h
===================================================================
RCS file: /cvs/src/usr.sbin/httpd/httpd.h,v
diff -u -p -u -r1.161 httpd.h
--- usr.sbin/httpd/httpd.h	15 Aug 2022 12:29:17 -0000	1.161
+++ usr.sbin/httpd/httpd.h	10 Jul 2023 11:42:11 -0000
@@ -353,6 +353,7 @@ struct client {
 	int			 clt_inflight;
 	struct range_data	 clt_ranges;
 	struct fcgi_data	 clt_fcgi;
+	const char		*clt_fcgi_error;
 	char			*clt_remote_user;
 	struct evbuffer		*clt_srvevb;
 
Index: usr.sbin/httpd/server.c
===================================================================
RCS file: /cvs/src/usr.sbin/httpd/server.c,v
diff -u -p -u -r1.126 server.c
--- usr.sbin/httpd/server.c	14 Jul 2021 13:33:57 -0000	1.126
+++ usr.sbin/httpd/server.c	10 Jul 2023 11:42:11 -0000
@@ -1300,6 +1300,11 @@ server_close(struct client *clt, const c
 {
 	struct server		*srv = clt->clt_srv;
 
+	if (clt->clt_fcgi_error != NULL) {
+		clt->clt_fcgi_error = msg;
+		return;
+	}
+
 	SPLAY_REMOVE(client_tree, &srv->srv_clients, clt);
 
 	/* free the HTTP descriptors incl. headers */
Index: usr.sbin/httpd/server_fcgi.c
===================================================================
RCS file: /cvs/src/usr.sbin/httpd/server_fcgi.c,v
diff -u -p -u -r1.95 server_fcgi.c
--- usr.sbin/httpd/server_fcgi.c	15 Aug 2022 12:29:17 -0000	1.95
+++ usr.sbin/httpd/server_fcgi.c	10 Jul 2023 11:42:11 -0000
@@ -372,7 +372,18 @@ server_fcgi(struct httpd *env, struct cl
 	    srv_conf->timeout.tv_sec, srv_conf->timeout.tv_sec);
 	bufferevent_enable(clt->clt_srvbev, EV_READ|EV_WRITE);
 	if (clt->clt_toread != 0) {
+		/*
+		 * XXX - Work around UAF: server_read_httpcontent() can call
+		 * server_close(), normally freeing clt. If clt->clt_fcgi_error
+		 * changed, call server_close() via server_abort_http().
+		 */
+		clt->clt_fcgi_error = "";
 		server_read_httpcontent(clt->clt_bev, clt);
+		errstr = clt->clt_fcgi_error;
+		clt->clt_fcgi_error = NULL;
+		if (errstr == NULL || errstr[0] != '\0')
+			goto fail;
+		errstr = NULL;
 		bufferevent_enable(clt->clt_bev, EV_READ);
 	} else {
 		bufferevent_disable(clt->clt_bev, EV_READ);
