untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8IztPYzRDRnQsmIIPNi7u3HIj4xXHBM65rnTYC3hIi0qP1azrdNuEObqS+4cl+fXfrOZoeBr9LtLJmspgMWj7QY=

OpenBSD 7.2 errata 031, July 12, 2023:

When tracking nexthops over IPv6 multipath routes, or when receiving
a NOTIFICATION while reaching an internal limit, bgpd(8) could crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 031_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpd(8):
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install

Index: usr.sbin/bgpd/kroute.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/kroute.c,v
diff -u -p -u -r1.300 kroute.c
--- usr.sbin/bgpd/kroute.c	21 Sep 2022 21:12:03 -0000	1.300
+++ usr.sbin/bgpd/kroute.c	10 Jul 2023 12:45:50 -0000
@@ -1856,7 +1856,7 @@ kroute6_remove(struct ktable *kt, struct
 	}
 
 	/* check whether a nexthop depends on this kroute */
-	if (kr->flags & F_NEXTHOP) {
+	if (krm->flags & F_NEXTHOP) {
 		RB_FOREACH(n, knexthop_tree, KT2KNT(kt)) {
 			if (n->kroute == krm)
 				knexthop_validate(kt, n);
Index: usr.sbin/bgpd/session.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/session.c,v
diff -u -p -u -r1.435 session.c
--- usr.sbin/bgpd/session.c	31 Aug 2022 15:51:44 -0000	1.435
+++ usr.sbin/bgpd/session.c	10 Jul 2023 12:45:50 -0000
@@ -1963,6 +1963,8 @@ session_process_msg(struct peer *p)
 		}
 	}
 
+	if (p->rbuf == NULL)
+		return;
 	if (rpos < av) {
 		left = av - rpos;
 		memmove(&p->rbuf->buf, p->rbuf->buf + rpos, left);
