![Build
Status](https://travis-ci.org/araraloren/perl6-getopt-advance.svg?branch=master)
![Windows Build
Status](https://ci.appveyor.com/api/projects/status/1aknogb99475ak53/branch/master?svg=true)

An advance command line parse tool replace Getopt::Kinoko

# Description

`Getopt::Advance` is a powerful command line option parsing module, it
suppot many style such as: `unix-style`、`gnu-style`、`bsd-style`.etc. It
support `Hash`、`Array` option compared to traditional command line
tools. In addition, it also support `radio`、`multi` group mechanism
which can manage option realtionship. And to handle non-option argument,
it provide `main`、`pos` and `cmd` feature.

# Usage

## Try it

### Normal version

``` perl6
use Getopt::Advance;

my OptionSet $os .= new();

$os.push(
    "h|help=b",
    "print help message.",
    callback => sub ($, $) {
        say "The h option is set by user";
    });

&getopt($os);
say "Exit!";
```

### With react

``` perl6
use Getopt::Advance;

my OptionSet $os .= new();

$os.push("h|help=b", "print help message.");

react {
    whenever $os.Supply("h") {
        say "The h option is set by user";
    }
    whenever &getopt($os) {
        say "Exit!";
        done;
    }
}
```

## Feature

The feature support by this module, more information please refer
documents.

  - Option with type
    
      - Long and short option supported, such as `-o` and `--option`.
    
      - X-style option supported, such as `-option`.
    
      - Combing-style option supported, such as `-abc` is same as `-a`
        `-b` `-c`.
    
      - BSD-style supported, such as `abc` is set the boolean option
        `a`, `b` and `c`.
    
      - Multiple style provide option arguments, such as `-a=b`, `-a b`,
        `-ab` is mean set the value of option `a` to `b`.
    
      - Deactivate-style support, mean you can disable some option by
        using `-/o`.
    
      - Type supported, such as `Boolean`, `Integer`, `Array`, and
        `String`, i.e. will check the option argument provide by user.

  - Non Option with index
    
      - Sub command supported, it can provide different feature to user,
        such as `script.p6 add …​` and `script.p6 del …​`.
    
      - Position argument base on index supported, such as `script.p6
        <file>` will capture the first non-option argument provide by
        user.
    
      - Main function supported. Main function will call with all the
        non-option arguments.

  - Option rule
    
      - With `radio` group, can only set one by user, or must set one by
        user.
    
      - With `multi` group, can limiting the options set at least one.
    
      - Must be set by user if optional of option is False.

  - Callback of Option/Non Option
    
      - Can set the callback of Option/Non Option, it will be called
        when it set by user.

  - Auto-generated help, version message
    
      - It can generate help and version message for you.
    
      - If `autohv` is set, it can automate print help or version
        message when corresponding option set by user.

  - PreParser
    
      - With the parser, you can process some option first, and process
        other with another call.

  - Interrupt the program
    
      - With sub such as `ga-want-helper`, you can interrupt the program
        and print help immediately.

  - Default value of Option

  - Load option from class/sub (not implement)

  - Load from the configure file easily
    
      - Refer the example [make-cpan-pack](sample/make-cpan-pack.p6).

  - Thing can Custom by user
    
      - Help generator.
    
      - Option Parser.
    
      - Style supported and the priority of them.
    
      - The order of `Option` value assignment and `Pos`, `Cmd` process.

## Document

[Getopt-Advance](doc/Getopt/Advance.adoc)

## Example

### App::snippet

[Run your c/c++ code.](https://github.com/araraloren/perl6-app-snippet)

### App::FindSource

[Find your source file
easily\!](https://github.com/araraloren/perl6-app-findsource)

### xcp

A [script](sample/xcp.p6) display the copy progress.

### pdnf

[pdnf](sample/pdnf.p6) added some sort command to dnf(package manager of
some linux distribution).

### find-file

[find-file](sample/find-file.p6)

#### usage

**help.**

``` shell
$ ./find-file.p6
Usage:
./sample/find-file.p6 [directory] OPTIONs

-d               specify file type to directory

-v|--version     print program version.

--size=<integer> the minimum size limit of file.

-?               same as -h.

-h|--help        print this help.

-f               specify file type to normal file

-l               specify file type to symlink
```

**find.**

``` shell
$ ./find-file.p6 ../t '1\d.*t$'
../t/11-bsd-style.t
../t/10-x-style.t
```

# Installation

  - install with zef
    
        zef install Getopt::Advance

# Lincese

The MIT License (MIT).

# TODO

  - Update documents

  - Update subs feature
