# This Makefile.PL for ZMQ-FFI was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.47.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

# inserted by Dist::Zilla::Plugin::FFI::CheckLib 1.03
use FFI::CheckLib;
check_lib_or_exit(
  lib => 'zmq',
);

use ExtUtils::MakeMaker;

use FFI::Platypus;
# Can't currently support unthreaded BSD perls
# See GH #13
my $badbsd;
if ($^O eq 'freebsd') {
   (!grep /libthr/, `procstat -v $$`) && ($badbsd = 1);
} elsif ($^O =~ m/bsd/i) {
   !FFI::Platypus->new(lib => [undef])
                 ->find_symbol('pthread_self')
                 && ($badbsd = 1);
}
if ($badbsd) {
  print "On BSD ZMQ::FFI requires a perl built to support threads.";
  print " Can't continue\n";
  exit;
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "version agnostic Perl bindings for zeromq using ffi",
  "AUTHOR" => "Dylan Cali <calid1984\@gmail.com>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "FFI::CheckLib" => "0.11",
    "FFI::Platypus" => "0.86"
  },
  "DISTNAME" => "ZMQ-FFI",
  "LICENSE" => "perl",
  "NAME" => "ZMQ::FFI",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Class::XSAccessor" => "1.18",
    "Exporter" => 0,
    "FFI::Platypus" => "0.86",
    "FFI::Platypus::Buffer" => 0,
    "FFI::Platypus::Memory" => 0,
    "Import::Into" => "1.002005",
    "Math::BigInt" => "1.997",
    "Moo" => "1.004005",
    "Moo::Role" => 0,
    "Scalar::Util" => 0,
    "Sub::Exporter" => 0,
    "Try::Tiny" => 0,
    "bytes" => 0,
    "feature" => 0,
    "if" => 0,
    "namespace::clean" => 0,
    "strict" => 0,
    "threads" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "AnyEvent" => 0,
    "List::Util" => 0,
    "Math::BigInt" => "1.997",
    "POSIX" => 0,
    "Sub::Override" => 0,
    "Sys::SigAction" => 0,
    "Test::Deep" => 0,
    "Test::Exception" => 0,
    "Test::More" => 0,
    "Test::NoWarnings" => 0,
    "Test::Warnings" => 0,
    "Time::HiRes" => 0,
    "locale" => 0,
    "utf8" => 0
  },
  "VERSION" => "1.16_01",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "AnyEvent" => 0,
  "Carp" => 0,
  "Class::XSAccessor" => "1.18",
  "Exporter" => 0,
  "FFI::Platypus" => "0.86",
  "FFI::Platypus::Buffer" => 0,
  "FFI::Platypus::Memory" => 0,
  "Import::Into" => "1.002005",
  "List::Util" => 0,
  "Math::BigInt" => "1.997",
  "Moo" => "1.004005",
  "Moo::Role" => 0,
  "POSIX" => 0,
  "Scalar::Util" => 0,
  "Sub::Exporter" => 0,
  "Sub::Override" => 0,
  "Sys::SigAction" => 0,
  "Test::Deep" => 0,
  "Test::Exception" => 0,
  "Test::More" => 0,
  "Test::NoWarnings" => 0,
  "Test::Warnings" => 0,
  "Time::HiRes" => 0,
  "Try::Tiny" => 0,
  "bytes" => 0,
  "feature" => 0,
  "if" => 0,
  "locale" => 0,
  "namespace::clean" => 0,
  "strict" => 0,
  "threads" => 0,
  "utf8" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
