package Net::Kubernetes::Role::ResourceFetcher;
$Net::Kubernetes::Role::ResourceFetcher::VERSION = '1.08';
# ABSTRACT: Role to give access to get_* methods.

use Moose::Role;
use MooseX::Aliases;
use syntax "try";
require Net::Kubernetes::Resource::Service;
require Net::Kubernetes::Resource::Pod;
require Net::Kubernetes::Resource::ReplicationController;

with 'Net::Kubernetes::Role::ResourceFactory';
with 'Net::Kubernetes::Role::ResourceCatalog';

sub get_resource_by_name {
    my ($self, $name, $type) = @_;
    my $resource_path = $self->get_resource_path(lc($type));
    my ($res) = $self->ua->request($self->create_request(GET => "$resource_path/$name"));
    if ($res->is_success) {
        return $self->create_resource_object($self->json->decode($res->content));
    }
    else {
        my $message;
        try {
            my $obj = $self->json->decode($res->content);
            $message = $obj->{message};
        }
        catch($e) {
            $message = $res->message;
            } Net::Kubernetes::Exception->throw(
                code    => $res->code,
                message => $message
            );
    }
}

return 42;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::Kubernetes::Role::ResourceFetcher - Role to give access to get_* methods.

=head1 VERSION

version 1.08

=head1 AUTHOR

Dave Mueller <dave@perljedi.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Liquid Web Inc.

This is free software, licensed under:

  The MIT (X11) License

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Net::Kubernetes|Net::Kubernetes>

=back

=head1 CONSUMES

=over 4

=item * L<Net::Kubernetes::Role::ResourceCatalog>

=item * L<Net::Kubernetes::Role::ResourceFactory>

=back

=cut
