
use strict;
use warnings;

use 5.010000;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "API to Fogbugz XML webservice",
  "AUTHOR" => "Gareth Kirwan <gbjk\@thermeon.com>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "WebService-FogBugz-XML",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "WebService::FogBugz::XML",
  "PREREQ_PM" => {
    "Config::Any" => 0,
    "Data::Dumper" => 0,
    "HTTP::Request" => 0,
    "IO::Prompt" => 0,
    "LWP::UserAgent" => 0,
    "Moose" => 0,
    "XML::LibXML" => 0,
    "common::sense" => 0,
    "namespace::autoclean" => 0
  },
  "TEST_REQUIRES" => {
    "Term::ReadKey" => 0,
    "Test::More" => 0,
    "lib" => 0
  },
  "VERSION" => "1.0001",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



