package App::Manoc::Netwalker::Poller::TaskReport;

use Moose;
our $VERSION = '2.99.2'; ##TRIAL VERSION

use MooseX::Storage;

with Storage( 'format' => 'YAML' );

has 'warning' => (
    traits  => ['Array'],
    is      => 'rw',
    isa     => 'ArrayRef',
    default => sub { [] },
    handles => {
        add_warning   => 'push',
        map_warning   => 'map',
        warning_count => 'count',
        all_warning   => 'elements',
    },
);

has 'error' => (
    traits  => ['Array'],
    is      => 'rw',
    isa     => 'ArrayRef',
    default => sub { [] },
    handles => {
        add_error   => 'push',
        map_error   => 'map',
        error_count => 'count',
        has_error   => 'count',
        all_errors  => 'elements',
    },
);

has 'host' => (
    is       => 'rw',
    isa      => 'Str',
    required => 1,
);

has 'visited' => (
    is      => 'rw',
    isa     => 'Bool',
    default => 0,
);

has 'new_devices' => (
    is      => 'rw',
    isa     => 'Int',
    default => 0,
);

has 'cdp_entries' => (
    is      => 'rw',
    isa     => 'Int',
    default => 0,
);

has 'mat_entries' => (
    is      => 'rw',
    isa     => 'Int',
    default => 0,
);

has 'arp_entries' => (
    is      => 'rw',
    isa     => 'Int',
    default => 0,
);

1;

__END__

=pod

=head1 NAME

App::Manoc::Netwalker::Poller::TaskReport

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
