package App::Manoc::Form::LanSegment;
#ABSTRACT: Manoc Form for editing lan segment.

use HTML::FormHandler::Moose;

our $VERSION = '2.99.3'; ##TRIAL VERSION

extends 'App::Manoc::Form::BaseDBIC';
with
    'App::Manoc::Form::TraitFor::SaveButton',
    'App::Manoc::Form::TraitFor::Horizontal';

use namespace::autoclean;

has '+item_class' => ( default => 'LanSegment' );
has '+name'       => ( default => 'form-lansegment' );

has_field 'name' => (
    type     => 'Text',
    required => 1,
);

has_field 'vtp_domain' => (
    type     => 'Text',
    required => 0,
);

has_field 'notes' => ( type => 'TextArea' );

__PACKAGE__->meta->make_immutable;
no HTML::FormHandler::Moose;

__END__

=pod

=head1 NAME

App::Manoc::Form::LanSegment - Manoc Form for editing lan segment.

=head1 VERSION

version 2.99.3

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
