#!/usr/bin/perl
########################################################################
#
# $Id$
#
# Copyright (c) 2002 Okunev Igor <gosha@prv.mts-nn.ru>
#
########################################################################
use strict;

$^W = 1;

if ( defined ( my $i = shift ) ) {
	print digit_to_money_string( $i ), "\n";
} else {
	print ": " if -t STDIN;
	while ( defined ( $i = <STDIN> ) ) {
		chomp $i;
		print digit_to_money_string( $i ), "\n";
		print ": " if -t STDIN;
	}
}

sub digit_to_money_string {
	my $digit = shift;
	local $_;

	#
	#    
	#
	my $sign = 1 if $digit =~ s/^-+//;

	#
	#     
	#
	$digit =~ s#^0+##;

	my ( $b_dig, $s_dig ) = ( split( m/[,.]/, $digit, 2 ) );

	#
	#    `'  ( 100_000,43 )
	#
	if ( defined $b_dig and length $b_dig ) {
		$b_dig =~ s#[^\d]##sg;
	} else {
		$b_dig = 0;
	}
	if ( defined $s_dig and length $s_dig ) {
		$s_dig =~ s#[^\d]##sg;
	} else {
		$s_dig = 0;
	}
	
	#
	#     ,    
	#  ,     b_dig (  )
	#
	if ( sprintf('%0.2f', "0.$s_dig" ) == 1 ) {
		$b_dig ++;
		$s_dig = '00';
	} else {
		$s_dig = substr( sprintf('%0.2f', "0.$s_dig" ), 2 );
	}

	my @array = split( //, ( $b_dig || 0 ) );

	#
	#   .
	#
	my $class_id = int( scalar ( @array ) / 3);
	$class_id++ if ( scalar ( @array ) % 3 );

	#
	#  .
	#
	return $digit if $class_id > 12;

	my $digits_name = {
			0	=> ['',			'',				''			],
			1	=> [['',''],	'',		''		],
			2	=> [['',''],		'',		''	],
			3	=> ['',		'',		''	],
			4	=> ['',	'',		''	],
			5	=> ['',		'',	''	],
			6	=> ['',	'',	''	],
			7	=> ['',		'',	''	],
			8	=> ['',	'',	''	],
			9	=> ['',	'',	''	],
		};

	my $dec_digits = {
				11	=> '',
				12	=> '',
				13	=> '',
				14	=> '',
				15	=> '',
				16	=> '',
				17	=> '',
				18	=> '',
				19	=> ''
			};

	my $digits_class = {
			'-1'=>	[ 1,	'',		'',		''	],
			0	=>	[ 0,	'',		'',		''		],
			1	=>	[ 1,	'',		'',		''	],
			2	=>	[ 0,	'',		'',	''	],
			3	=>	[ 0,	'',		'',	''	],
			4	=>	[ 0,	'',		'',	''	],
			5	=>	[ 0,	'',	'',	'' ],
			6	=>	[ 0,	'',	'',''],
			7	=>	[ 0,	'',	'',''],
			8	=>	[ 0,	'',	'',	''],
			9	=>	[ 0,	'',		'',	''	],
			10	=>	[ 0,	'',	'',	''],
			11	=>	[ 0,	'',	'',	'' ]
		};
	
	#
	#    `'...
	#
	my $id = 0;
	unless ( ( scalar @array ) % 3 ) {
		$id = 2;
	} else {
		$id = ( ( scalar @array ) % 3 ) - 1;
	}

	my $str		= '';
	my $sub_str	= 0;
	my $tvar	= 0;

	if ( $array[0] == 0 ) {
		#
		#    ,     ' ',
		#        ...
		#
		$str .= $digits_name->{'0'}->[0] . ' ' . $digits_class->{'0'}->[2] . ' ';
	} else {
		while ( defined ( $_ = shift @array ) ) {
			if ( $_ > 0 ) {
				if ( $_ == 1 and $id == 1 ) {
					#
					#      sub num()
					#
					$sub_str += $_ * 10;
					if ( defined ( $tvar = shift @array ) and $tvar > 0 ) {
						$str .= $dec_digits->{ $_ . $tvar };
						$sub_str += $tvar;
						$id--;
					} else {
						unshift @array, $tvar;
						if ( ref $digits_name->{$_}->[$id] eq 'ARRAY' ) {
							$str .= $digits_name->{$_}->[$id]->[$digits_class->{$class_id-1}->[0]];
						} else {
							$str .= $digits_name->{$_}->[$id];
						}
					}
				} else {
					#
					#      sub num()
					#
					$sub_str += ( $_ * ( 10 ** $id ) );
					if ( ref $digits_name->{$_}->[$id]  eq 'ARRAY' ) {
						$str .= $digits_name->{$_}->[$id]->[$digits_class->{$class_id-1}->[0]];
					} else {
						$str .= $digits_name->{$_}->[$id];
					}
				}
				$str .= ' ';
			}
			if ( --$id == -1 ) {
				$id = 2;
				$class_id--;
				if ( $sub_str > 0 ) {
					$str .= num( $sub_str, ( @{ $digits_class->{$class_id} } )[ 1 .. 3 ] ) . ' ';
				} elsif ( $class_id == 0 ) {
					$str .= $digits_class->{$class_id}->[2] . ' ';
				}
				$sub_str = 0;
			}
		}
	}

	$str .= $s_dig . ' ' . num( $s_dig, ( @{ $digits_class->{ '-1' } } )[ 1 .. 3 ] );

	if ( defined $sign ) {
		$str = ' ' . $str;
	}

	$s_dig = substr( $str, 0, 1 );
	#
	#        
	# ,   use locale & ucfirst...
	#
	if ( $s_dig =~ tr/ţ// ) {
		substr( $str, 0, 1, $s_dig );
	}

	return $str;
}

#
#        ..
#

sub num {
	my $d1 = $_[0] % 10;
	my $d2 = int( ( $_[0] % 100 ) / 10 );
	return $_[2] if ( ( $d2 == 1 ) or ( $d1 =~ /[05-9]/ ) );
	return $_[1] if ( $d1==1 );
	return $_[3];
}

