use strict;
use warnings;

use lib '.';
use inc::Module::Install;

name			'WWW-Search-PubMed';
all_from		'lib/WWW/Search/PubMed.pm';
author			'Gregory Todd Williams <gwilliams@cpan.org>';
license			'perl';

perl_version	'5.008001';

requires		'WWW::Search'				=> 0;
requires		'LWP::UserAgent'			=> 0;
requires		'XML::DOM'					=> 0;

resources(
	'homepage'		=> "https://metacpan.org/release/WWW-Search-PubMed",
	'repository'	=> "https://github.com/kasei/pubmed/",
	'bugtracker'	=> "https://github.com/kasei/pubmed/issues"
);

author_tests('xt');

write_doap_changes "meta/changes.ttl", "Changes", "turtle";

sign;
WriteAll;
