# Generated by default/object.tt
package Paws::FraudDetector::EventType;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CreatedTime => (is => 'ro', isa => 'Str', request_name => 'createdTime', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has EntityTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'entityTypes', traits => ['NameInRequest']);
  has EventVariables => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'eventVariables', traits => ['NameInRequest']);
  has Labels => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'labels', traits => ['NameInRequest']);
  has LastUpdatedTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedTime', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FraudDetector::EventType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FraudDetector::EventType object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FraudDetector::EventType object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The event type details.

=head1 ATTRIBUTES


=head2 Arn => Str

The entity type ARN.


=head2 CreatedTime => Str

Timestamp of when the event type was created.


=head2 Description => Str

The event type description.


=head2 EntityTypes => ArrayRef[Str|Undef]

The event type entity types.


=head2 EventVariables => ArrayRef[Str|Undef]

The event type event variables.


=head2 Labels => ArrayRef[Str|Undef]

The event type labels.


=head2 LastUpdatedTime => Str

Timestamp of when the event type was last updated.


=head2 Name => Str

The event type name.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FraudDetector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

