/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LogConditionalObjectiveFunction;
import edu.stanford.nlp.classify.LogPrior;
import edu.stanford.nlp.math.ArrayMath;
import java.util.Arrays;

public class AdaptedGaussianPriorObjectiveFunction<L, F>
extends LogConditionalObjectiveFunction<L, F> {
    double[] weights;

    @Override
    protected void calculate(double[] x) {
        if (this.useSummedConditionalLikelihood) {
            this.calculateSCL(x);
        } else {
            this.calculateCL(x);
        }
    }

    private void calculateSCL(double[] x) {
        throw new UnsupportedOperationException();
    }

    private void calculateCL(double[] x) {
        this.value = 0.0;
        if (this.derivativeNumerator == null) {
            this.derivativeNumerator = new double[x.length];
            for (int d = 0; d < this.data.length; ++d) {
                int[] features = this.data[d];
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], this.labels[d]);
                    if (this.dataweights == null) {
                        int n = i;
                        this.derivativeNumerator[n] = this.derivativeNumerator[n] - 1.0;
                        continue;
                    }
                    int n = i;
                    this.derivativeNumerator[n] = this.derivativeNumerator[n] - (double)this.dataweights[d];
                }
            }
        }
        AdaptedGaussianPriorObjectiveFunction.copy(this.derivative, this.derivativeNumerator);
        double[] sums = new double[this.numClasses];
        double[] probs = new double[this.numClasses];
        for (int d = 0; d < this.data.length; ++d) {
            int[] features = this.data[d];
            Arrays.fill(sums, 0.0);
            for (int c = 0; c < this.numClasses; ++c) {
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], c);
                    int n = c;
                    sums[n] = sums[n] + x[i];
                }
            }
            double total = ArrayMath.logSum(sums);
            for (int c = 0; c < this.numClasses; ++c) {
                probs[c] = Math.exp(sums[c] - total);
                if (this.dataweights != null) {
                    int n = c;
                    probs[n] = probs[n] * (double)this.dataweights[d];
                }
                for (int f = 0; f < features.length; ++f) {
                    int i;
                    int n = i = this.indexOf(features[f], c);
                    this.derivative[n] = this.derivative[n] + probs[c];
                }
            }
            double dV = sums[this.labels[d]] - total;
            if (this.dataweights != null) {
                dV *= (double)this.dataweights[d];
            }
            this.value -= dV;
        }
        double[] newX = ArrayMath.pairwiseSubtract(x, this.weights);
        this.value += this.prior.compute(newX, this.derivative);
    }

    @Override
    protected void rvfcalculate(double[] x) {
        throw new UnsupportedOperationException();
    }

    public AdaptedGaussianPriorObjectiveFunction(GeneralDataset<L, F> dataset, LogPrior prior, double[][] weights) {
        super(dataset, prior);
        this.weights = this.to1D(weights);
    }

    public double[] to1D(double[][] x2) {
        double[] x = new double[this.numFeatures * this.numClasses];
        for (int i = 0; i < this.numFeatures; ++i) {
            for (int j = 0; j < this.numClasses; ++j) {
                x[this.indexOf((int)i, (int)j)] = x2[i][j];
            }
        }
        return x;
    }
}

