package Evo::GA::Population;

sub new {
	my ($class) = @_;

	my $self = { genes => (), };

	$class = ref($class) || $class;

	bless $self, $class;
}

### estimate fitness function
sub fitness_simple {
	my ($self) = @_;
	my $sum = 0.0;

	for (my $i = 0; $i < scalar $self->{genes}; $i++) {
		$sum += $self->{genes}[$i];
	}

	return ($sum / scalar $self->{genes});	
}

sub norm {
	my ($self) = @_;

	my $dotp = 0.0;

	for (my $i = 0; $i < scalar $self->{genes}; $i++) {
		$dotp += $self->{genes}[$i] * $self->{genes}[$i];
	}
	
	return $dotp;
}

1;
