#!/bin/bash

if [ -n "$1" ]; then
    files=("$1")
    shift
else
    files=($(ls ./queries/*.tq))
fi

i=0
fail=0
failed=()
for f in "${files[@]}"; do

  ./bin/grammar.pl < "$f" &>/dev/null
  if [ "${?}" -ne "0" ] ; then
    echo -n "${f} has "
    echo -e "\E[31mfailed!"
    fail=$((fail+1))
    failed[${#failed[*]}]="$f"
  else
    echo -n "${f} is "
    echo -e "\E[32mok!"
  fi
  i=$((i+1))
  tput sgr0
done

echo "Total of ${fail} of ${i} tests has failed";
if [ $fail -gt 0 ]; then
  echo "Failed files:";
  for f in "${failed[@]}"; do
    echo $f
  done
fi