use strict;
use warnings;

use Test::More tests => 4;
use blib;

my $perl = $^X;
my $result = `$perl t/basic1.xml`;
ok($result, "example file can be run by perl: [".length($result)." bytes]");

my $expected;
$expected = 'Content-length: 201';
like($result, qr($expected), "content-length is like expected: [$expected]");

$expected = 'Content-Type: text/html; charset=UTF-8';
like($result, qr($expected), "content-type is like expected: [$expected]");

$expected = 'Color: red';
like($result, qr($expected), "custom header is like expected: [$expected]");

print $result;