/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Value;

public class PrependIterator
implements AxisIterator {
    NodeInfo start;
    AxisIterator base;
    int position = 0;

    public PrependIterator(NodeInfo start, AxisIterator base) {
        this.start = start;
        this.base = base;
    }

    public boolean moveNext() {
        return this.next() != null;
    }

    public NodeInfo next() {
        if (this.position == 0) {
            this.position = 1;
            return this.start;
        }
        Object n = this.base.next();
        this.position = n == null ? -1 : ++this.position;
        return n;
    }

    public NodeInfo current() {
        if (this.position() == 1) {
            return this.start;
        }
        if (this.position < 1) {
            return null;
        }
        return this.base.current();
    }

    public int position() {
        return this.position;
    }

    public void close() {
        this.base.close();
    }

    public AxisIterator iterateAxis(byte axis, NodeTest test) {
        return this.current().iterateAxis(axis, test);
    }

    public Value atomize() throws XPathException {
        return this.current().atomize();
    }

    public CharSequence getStringValue() {
        return this.current().getStringValueCS();
    }

    public AxisIterator getAnother() {
        return new PrependIterator(this.start, this.base);
    }

    public int getProperties() {
        return 0;
    }
}

