#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 560_Slurm-SAQos-parse.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::Qos;

my $testDir = dirname(abs_path($0));
my $num_tests_run = 0; 

#Set up expected results
my @fakedata =
(	
	{ name=>'high-priority', description=>'High priority QoS',
		gracetime=>120, 
		grpcpumins=>6000, grpcpus=>50, grpnodes=>10,
		grpjobs=>75, grpsubmitjobs=>100, grpwall=>600,
		maxcpumins=>12000, maxcpus=>100, maxnodes=>20,
		maxjobs=>75, maxsubmitjobs=>100, maxwall=>600,
		maxcpusperuser=>25, maxnodesperuser=>5,
		preempt=>'scavenger', preemptmode=>'cluster',
		priority=>500, usagefactor=>2,
	},

	{ name=>'standard', description=>'standard priority QoS',
		gracetime=>60, 
		maxcpumins=>24000, maxcpus=>200, maxnodes=>40,
		maxjobs=>150, maxsubmitjobs=>200, maxwall=>1200,
		maxcpusperuser=>50, maxnodesperuser=>10,
		preempt=>'scavenger', preemptmode=>'cluster',
		priority=>100, usagefactor=>1,
	},

	{ name=>'scavenger', description=>'bottom feeder QoS',
		gracetime=>10, preemptmode=>'cluster',
		priority=>0, usagefactor=>0,
	},

);
my @fake_data = ();
foreach my $fakedatum (@fakedata)
{	my $name = $fakedatum->{name};	
	my $obj = new_ok('Slurm::Sacctmgr::Qos' => 
		[ %$fakedatum ],
		"$name" );
	$num_tests_run++;

	push @fake_data, $obj;
}
#Make sure @fake_data is alphabetically by username
#@fake_data = sort { $a->account cmp $b->account } @fake_data;

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/fake_sacctmgr_qos");
my $saqos = 'Slurm::Sacctmgr::Qos';

my $results;
my $args;
my $temp;
my $val;
my @temp;

#Test various commands with echo sacctmgr
#$sa->verbose(1);

$results = $saqos->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all qoses');
$num_tests_run++;

$val = 'high-priority';
@temp = ( name => $val );
$temp = [ grep { $_->name eq $val } @fake_data ];
$results = $saqos->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list qos by name (hi)');
$num_tests_run++;

$val = 'standard';
@temp = ( name => $val );
$temp = [ grep { $_->name eq $val } @fake_data ];
$results = $saqos->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list qos by name (hi)');
$num_tests_run++;

$val = 'scavenger';
@temp = ( name => $val );
$temp = [ grep { $_->name eq $val } @fake_data ];
$results = $saqos->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list qos by name (hi)');
$num_tests_run++;

#Test for match failing
$val = 'zzz';
@temp = ( name => $val );
$temp = [ grep { $_->name eq $val } @fake_data ];
$results = $saqos->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list qos by name (no match)');
$num_tests_run++;

#Test that still works when in dryrun mode
$sa->dryrun(1);
$results = $saqos->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all qoses (dryrun)');
$num_tests_run++;

done_testing($num_tests_run);

