#!perl

use strict;
use warnings;

use Test::More tests => 2554;

my $class;

BEGIN { $class = 'Math::BigInt::Lite'; }
BEGIN { use_ok($class, '0.16'); }

while (<DATA>) {
    s/#.*$//;           # remove comments
    s/\s+$//;           # remove trailing whitespace
    next unless length; # skip empty lines

    my ($in0, $out0) = split /:/;
    my $x;

    my $test = qq|\$x = $class -> from_oct("$in0");|;
    my $desc = $test;

    eval $test;
    die $@ if $@;       # this should never happen

    subtest $desc, sub {
        plan tests => 2,

        # Check output.

        # Explcitly setting Math::BigInt here is bad. We should use be able to
        # use Math::BigInt::Lite -> config("upgrade"), but that doesn't work
        # yet. FIXME!

        my $xref = ref($x);
        ok($xref eq $class || $xref eq 'Math::BigInt',
           "output arg is a $class or a Math::BigInt");

        is($x, $out0, 'output arg has the right value');
    };

}

__END__

NaN:NaN
+inf:NaN
-inf:NaN

###############################################################################
# Absolute value is close to 2^1 = 2
###############################################################################

# Unsigned

00:0
01:1
02:2
03:3
04:4

0:0
1:1
2:2
3:3
4:4

# Positive

+00:0
+01:1
+02:2
+03:3
+04:4

+0:0
+1:1
+2:2
+3:3
+4:4

# Negative

-00:0
-01:-1
-02:-2
-03:-3
-04:-4

-0:0
-1:-1
-2:-2
-3:-3
-4:-4

###############################################################################
# Absolute value is close to 2^2 = 4
###############################################################################

# Unsigned

02:2
03:3
04:4
05:5
06:6

2:2
3:3
4:4
5:5
6:6

# Positive

+02:2
+03:3
+04:4
+05:5
+06:6

+2:2
+3:3
+4:4
+5:5
+6:6

# Negative

-02:-2
-03:-3
-04:-4
-05:-5
-06:-6

-2:-2
-3:-3
-4:-4
-5:-5
-6:-6

###############################################################################
# Absolute value is close to 2^3 = 8
###############################################################################

# Unsigned

06:6
07:7
010:8
011:9
012:10

6:6
7:7
10:8
11:9
12:10

# Positive

+06:6
+07:7
+010:8
+011:9
+012:10

+6:6
+7:7
+10:8
+11:9
+12:10

# Negative

-06:-6
-07:-7
-010:-8
-011:-9
-012:-10

-6:-6
-7:-7
-10:-8
-11:-9
-12:-10

###############################################################################
# Absolute value is close to 2^4 = 16
###############################################################################

# Unsigned

016:14
017:15
020:16
021:17
022:18

16:14
17:15
20:16
21:17
22:18

# Positive

+016:14
+017:15
+020:16
+021:17
+022:18

+16:14
+17:15
+20:16
+21:17
+22:18

# Negative

-016:-14
-017:-15
-020:-16
-021:-17
-022:-18

-16:-14
-17:-15
-20:-16
-21:-17
-22:-18

###############################################################################
# Absolute value is close to 2^5 = 32
###############################################################################

# Unsigned

036:30
037:31
040:32
041:33
042:34

36:30
37:31
40:32
41:33
42:34

# Positive

+036:30
+037:31
+040:32
+041:33
+042:34

+36:30
+37:31
+40:32
+41:33
+42:34

# Negative

-036:-30
-037:-31
-040:-32
-041:-33
-042:-34

-36:-30
-37:-31
-40:-32
-41:-33
-42:-34

###############################################################################
# Absolute value is close to 2^6 = 64
###############################################################################

# Unsigned

076:62
077:63
0100:64
0101:65
0102:66

76:62
77:63
100:64
101:65
102:66

# Positive

+076:62
+077:63
+0100:64
+0101:65
+0102:66

+76:62
+77:63
+100:64
+101:65
+102:66

# Negative

-076:-62
-077:-63
-0100:-64
-0101:-65
-0102:-66

-76:-62
-77:-63
-100:-64
-101:-65
-102:-66

###############################################################################
# Absolute value is close to 2^7 = 128
###############################################################################

# Unsigned

0176:126
0177:127
0200:128
0201:129
0202:130

176:126
177:127
200:128
201:129
202:130

# Positive

+0176:126
+0177:127
+0200:128
+0201:129
+0202:130

+176:126
+177:127
+200:128
+201:129
+202:130

# Negative

-0176:-126
-0177:-127
-0200:-128
-0201:-129
-0202:-130

-176:-126
-177:-127
-200:-128
-201:-129
-202:-130

###############################################################################
# Absolute value is close to 2^8 = 256
###############################################################################

# Unsigned

0376:254
0377:255
0400:256
0401:257
0402:258

376:254
377:255
400:256
401:257
402:258

# Positive

+0376:254
+0377:255
+0400:256
+0401:257
+0402:258

+376:254
+377:255
+400:256
+401:257
+402:258

# Negative

-0376:-254
-0377:-255
-0400:-256
-0401:-257
-0402:-258

-376:-254
-377:-255
-400:-256
-401:-257
-402:-258

###############################################################################
# Absolute value is close to 2^9 = 512
###############################################################################

# Unsigned

0776:510
0777:511
01000:512
01001:513
01002:514

776:510
777:511
1000:512
1001:513
1002:514

# Positive

+0776:510
+0777:511
+01000:512
+01001:513
+01002:514

+776:510
+777:511
+1000:512
+1001:513
+1002:514

# Negative

-0776:-510
-0777:-511
-01000:-512
-01001:-513
-01002:-514

-776:-510
-777:-511
-1000:-512
-1001:-513
-1002:-514

###############################################################################
# Absolute value is close to 2^10 = 1024
###############################################################################

# Unsigned

01776:1022
01777:1023
02000:1024
02001:1025
02002:1026

1776:1022
1777:1023
2000:1024
2001:1025
2002:1026

# Positive

+01776:1022
+01777:1023
+02000:1024
+02001:1025
+02002:1026

+1776:1022
+1777:1023
+2000:1024
+2001:1025
+2002:1026

# Negative

-01776:-1022
-01777:-1023
-02000:-1024
-02001:-1025
-02002:-1026

-1776:-1022
-1777:-1023
-2000:-1024
-2001:-1025
-2002:-1026

###############################################################################
# Absolute value is close to 2^11 = 2048
###############################################################################

# Unsigned

03776:2046
03777:2047
04000:2048
04001:2049
04002:2050

3776:2046
3777:2047
4000:2048
4001:2049
4002:2050

# Positive

+03776:2046
+03777:2047
+04000:2048
+04001:2049
+04002:2050

+3776:2046
+3777:2047
+4000:2048
+4001:2049
+4002:2050

# Negative

-03776:-2046
-03777:-2047
-04000:-2048
-04001:-2049
-04002:-2050

-3776:-2046
-3777:-2047
-4000:-2048
-4001:-2049
-4002:-2050

###############################################################################
# Absolute value is close to 2^12 = 4096
###############################################################################

# Unsigned

07776:4094
07777:4095
010000:4096
010001:4097
010002:4098

7776:4094
7777:4095
10000:4096
10001:4097
10002:4098

# Positive

+07776:4094
+07777:4095
+010000:4096
+010001:4097
+010002:4098

+7776:4094
+7777:4095
+10000:4096
+10001:4097
+10002:4098

# Negative

-07776:-4094
-07777:-4095
-010000:-4096
-010001:-4097
-010002:-4098

-7776:-4094
-7777:-4095
-10000:-4096
-10001:-4097
-10002:-4098

###############################################################################
# Absolute value is close to 2^13 = 8192
###############################################################################

# Unsigned

017776:8190
017777:8191
020000:8192
020001:8193
020002:8194

17776:8190
17777:8191
20000:8192
20001:8193
20002:8194

# Positive

+017776:8190
+017777:8191
+020000:8192
+020001:8193
+020002:8194

+17776:8190
+17777:8191
+20000:8192
+20001:8193
+20002:8194

# Negative

-017776:-8190
-017777:-8191
-020000:-8192
-020001:-8193
-020002:-8194

-17776:-8190
-17777:-8191
-20000:-8192
-20001:-8193
-20002:-8194

###############################################################################
# Absolute value is close to 2^14 = 16384
###############################################################################

# Unsigned

037776:16382
037777:16383
040000:16384
040001:16385
040002:16386

37776:16382
37777:16383
40000:16384
40001:16385
40002:16386

# Positive

+037776:16382
+037777:16383
+040000:16384
+040001:16385
+040002:16386

+37776:16382
+37777:16383
+40000:16384
+40001:16385
+40002:16386

# Negative

-037776:-16382
-037777:-16383
-040000:-16384
-040001:-16385
-040002:-16386

-37776:-16382
-37777:-16383
-40000:-16384
-40001:-16385
-40002:-16386

###############################################################################
# Absolute value is close to 2^15 = 32768
###############################################################################

# Unsigned

077776:32766
077777:32767
0100000:32768
0100001:32769
0100002:32770

77776:32766
77777:32767
100000:32768
100001:32769
100002:32770

# Positive

+077776:32766
+077777:32767
+0100000:32768
+0100001:32769
+0100002:32770

+77776:32766
+77777:32767
+100000:32768
+100001:32769
+100002:32770

# Negative

-077776:-32766
-077777:-32767
-0100000:-32768
-0100001:-32769
-0100002:-32770

-77776:-32766
-77777:-32767
-100000:-32768
-100001:-32769
-100002:-32770

###############################################################################
# Absolute value is close to 2^16 = 65536
###############################################################################

# Unsigned

0177776:65534
0177777:65535
0200000:65536
0200001:65537
0200002:65538

177776:65534
177777:65535
200000:65536
200001:65537
200002:65538

# Positive

+0177776:65534
+0177777:65535
+0200000:65536
+0200001:65537
+0200002:65538

+177776:65534
+177777:65535
+200000:65536
+200001:65537
+200002:65538

# Negative

-0177776:-65534
-0177777:-65535
-0200000:-65536
-0200001:-65537
-0200002:-65538

-177776:-65534
-177777:-65535
-200000:-65536
-200001:-65537
-200002:-65538

###############################################################################
# Absolute value is close to 2^17 = 131072
###############################################################################

# Unsigned

0377776:131070
0377777:131071
0400000:131072
0400001:131073
0400002:131074

377776:131070
377777:131071
400000:131072
400001:131073
400002:131074

# Positive

+0377776:131070
+0377777:131071
+0400000:131072
+0400001:131073
+0400002:131074

+377776:131070
+377777:131071
+400000:131072
+400001:131073
+400002:131074

# Negative

-0377776:-131070
-0377777:-131071
-0400000:-131072
-0400001:-131073
-0400002:-131074

-377776:-131070
-377777:-131071
-400000:-131072
-400001:-131073
-400002:-131074

###############################################################################
# Absolute value is close to 2^18 = 262144
###############################################################################

# Unsigned

0777776:262142
0777777:262143
01000000:262144
01000001:262145
01000002:262146

777776:262142
777777:262143
1000000:262144
1000001:262145
1000002:262146

# Positive

+0777776:262142
+0777777:262143
+01000000:262144
+01000001:262145
+01000002:262146

+777776:262142
+777777:262143
+1000000:262144
+1000001:262145
+1000002:262146

# Negative

-0777776:-262142
-0777777:-262143
-01000000:-262144
-01000001:-262145
-01000002:-262146

-777776:-262142
-777777:-262143
-1000000:-262144
-1000001:-262145
-1000002:-262146

###############################################################################
# Absolute value is close to 2^19 = 524288
###############################################################################

# Unsigned

01777776:524286
01777777:524287
02000000:524288
02000001:524289
02000002:524290

1777776:524286
1777777:524287
2000000:524288
2000001:524289
2000002:524290

# Positive

+01777776:524286
+01777777:524287
+02000000:524288
+02000001:524289
+02000002:524290

+1777776:524286
+1777777:524287
+2000000:524288
+2000001:524289
+2000002:524290

# Negative

-01777776:-524286
-01777777:-524287
-02000000:-524288
-02000001:-524289
-02000002:-524290

-1777776:-524286
-1777777:-524287
-2000000:-524288
-2000001:-524289
-2000002:-524290

###############################################################################
# Absolute value is close to 2^20 = 1048576
###############################################################################

# Unsigned

03777776:1048574
03777777:1048575
04000000:1048576
04000001:1048577
04000002:1048578

3777776:1048574
3777777:1048575
4000000:1048576
4000001:1048577
4000002:1048578

# Positive

+03777776:1048574
+03777777:1048575
+04000000:1048576
+04000001:1048577
+04000002:1048578

+3777776:1048574
+3777777:1048575
+4000000:1048576
+4000001:1048577
+4000002:1048578

# Negative

-03777776:-1048574
-03777777:-1048575
-04000000:-1048576
-04000001:-1048577
-04000002:-1048578

-3777776:-1048574
-3777777:-1048575
-4000000:-1048576
-4000001:-1048577
-4000002:-1048578

###############################################################################
# Absolute value is close to 2^21 = 2097152
###############################################################################

# Unsigned

07777776:2097150
07777777:2097151
010000000:2097152
010000001:2097153
010000002:2097154

7777776:2097150
7777777:2097151
10000000:2097152
10000001:2097153
10000002:2097154

# Positive

+07777776:2097150
+07777777:2097151
+010000000:2097152
+010000001:2097153
+010000002:2097154

+7777776:2097150
+7777777:2097151
+10000000:2097152
+10000001:2097153
+10000002:2097154

# Negative

-07777776:-2097150
-07777777:-2097151
-010000000:-2097152
-010000001:-2097153
-010000002:-2097154

-7777776:-2097150
-7777777:-2097151
-10000000:-2097152
-10000001:-2097153
-10000002:-2097154

###############################################################################
# Absolute value is close to 2^22 = 4194304
###############################################################################

# Unsigned

017777776:4194302
017777777:4194303
020000000:4194304
020000001:4194305
020000002:4194306

17777776:4194302
17777777:4194303
20000000:4194304
20000001:4194305
20000002:4194306

# Positive

+017777776:4194302
+017777777:4194303
+020000000:4194304
+020000001:4194305
+020000002:4194306

+17777776:4194302
+17777777:4194303
+20000000:4194304
+20000001:4194305
+20000002:4194306

# Negative

-017777776:-4194302
-017777777:-4194303
-020000000:-4194304
-020000001:-4194305
-020000002:-4194306

-17777776:-4194302
-17777777:-4194303
-20000000:-4194304
-20000001:-4194305
-20000002:-4194306

###############################################################################
# Absolute value is close to 2^23 = 8388608
###############################################################################

# Unsigned

037777776:8388606
037777777:8388607
040000000:8388608
040000001:8388609
040000002:8388610

37777776:8388606
37777777:8388607
40000000:8388608
40000001:8388609
40000002:8388610

# Positive

+037777776:8388606
+037777777:8388607
+040000000:8388608
+040000001:8388609
+040000002:8388610

+37777776:8388606
+37777777:8388607
+40000000:8388608
+40000001:8388609
+40000002:8388610

# Negative

-037777776:-8388606
-037777777:-8388607
-040000000:-8388608
-040000001:-8388609
-040000002:-8388610

-37777776:-8388606
-37777777:-8388607
-40000000:-8388608
-40000001:-8388609
-40000002:-8388610

###############################################################################
# Absolute value is close to 2^24 = 16777216
###############################################################################

# Unsigned

077777776:16777214
077777777:16777215
0100000000:16777216
0100000001:16777217
0100000002:16777218

77777776:16777214
77777777:16777215
100000000:16777216
100000001:16777217
100000002:16777218

# Positive

+077777776:16777214
+077777777:16777215
+0100000000:16777216
+0100000001:16777217
+0100000002:16777218

+77777776:16777214
+77777777:16777215
+100000000:16777216
+100000001:16777217
+100000002:16777218

# Negative

-077777776:-16777214
-077777777:-16777215
-0100000000:-16777216
-0100000001:-16777217
-0100000002:-16777218

-77777776:-16777214
-77777777:-16777215
-100000000:-16777216
-100000001:-16777217
-100000002:-16777218

###############################################################################
# Absolute value is close to 2^25 = 33554432
###############################################################################

# Unsigned

0177777776:33554430
0177777777:33554431
0200000000:33554432
0200000001:33554433
0200000002:33554434

177777776:33554430
177777777:33554431
200000000:33554432
200000001:33554433
200000002:33554434

# Positive

+0177777776:33554430
+0177777777:33554431
+0200000000:33554432
+0200000001:33554433
+0200000002:33554434

+177777776:33554430
+177777777:33554431
+200000000:33554432
+200000001:33554433
+200000002:33554434

# Negative

-0177777776:-33554430
-0177777777:-33554431
-0200000000:-33554432
-0200000001:-33554433
-0200000002:-33554434

-177777776:-33554430
-177777777:-33554431
-200000000:-33554432
-200000001:-33554433
-200000002:-33554434

###############################################################################
# Absolute value is close to 2^26 = 67108864
###############################################################################

# Unsigned

0377777776:67108862
0377777777:67108863
0400000000:67108864
0400000001:67108865
0400000002:67108866

377777776:67108862
377777777:67108863
400000000:67108864
400000001:67108865
400000002:67108866

# Positive

+0377777776:67108862
+0377777777:67108863
+0400000000:67108864
+0400000001:67108865
+0400000002:67108866

+377777776:67108862
+377777777:67108863
+400000000:67108864
+400000001:67108865
+400000002:67108866

# Negative

-0377777776:-67108862
-0377777777:-67108863
-0400000000:-67108864
-0400000001:-67108865
-0400000002:-67108866

-377777776:-67108862
-377777777:-67108863
-400000000:-67108864
-400000001:-67108865
-400000002:-67108866

###############################################################################
# Absolute value is close to 2^27 = 134217728
###############################################################################

# Unsigned

0777777776:134217726
0777777777:134217727
01000000000:134217728
01000000001:134217729
01000000002:134217730

777777776:134217726
777777777:134217727
1000000000:134217728
1000000001:134217729
1000000002:134217730

# Positive

+0777777776:134217726
+0777777777:134217727
+01000000000:134217728
+01000000001:134217729
+01000000002:134217730

+777777776:134217726
+777777777:134217727
+1000000000:134217728
+1000000001:134217729
+1000000002:134217730

# Negative

-0777777776:-134217726
-0777777777:-134217727
-01000000000:-134217728
-01000000001:-134217729
-01000000002:-134217730

-777777776:-134217726
-777777777:-134217727
-1000000000:-134217728
-1000000001:-134217729
-1000000002:-134217730

###############################################################################
# Absolute value is close to 2^28 = 268435456
###############################################################################

# Unsigned

01777777776:268435454
01777777777:268435455
02000000000:268435456
02000000001:268435457
02000000002:268435458

1777777776:268435454
1777777777:268435455
2000000000:268435456
2000000001:268435457
2000000002:268435458

# Positive

+01777777776:268435454
+01777777777:268435455
+02000000000:268435456
+02000000001:268435457
+02000000002:268435458

+1777777776:268435454
+1777777777:268435455
+2000000000:268435456
+2000000001:268435457
+2000000002:268435458

# Negative

-01777777776:-268435454
-01777777777:-268435455
-02000000000:-268435456
-02000000001:-268435457
-02000000002:-268435458

-1777777776:-268435454
-1777777777:-268435455
-2000000000:-268435456
-2000000001:-268435457
-2000000002:-268435458

###############################################################################
# Absolute value is close to 2^29 = 536870912
###############################################################################

# Unsigned

03777777776:536870910
03777777777:536870911
04000000000:536870912
04000000001:536870913
04000000002:536870914

3777777776:536870910
3777777777:536870911
4000000000:536870912
4000000001:536870913
4000000002:536870914

# Positive

+03777777776:536870910
+03777777777:536870911
+04000000000:536870912
+04000000001:536870913
+04000000002:536870914

+3777777776:536870910
+3777777777:536870911
+4000000000:536870912
+4000000001:536870913
+4000000002:536870914

# Negative

-03777777776:-536870910
-03777777777:-536870911
-04000000000:-536870912
-04000000001:-536870913
-04000000002:-536870914

-3777777776:-536870910
-3777777777:-536870911
-4000000000:-536870912
-4000000001:-536870913
-4000000002:-536870914

###############################################################################
# Absolute value is close to 2^30 = 1073741824
###############################################################################

# Unsigned

07777777776:1073741822
07777777777:1073741823
010000000000:1073741824
010000000001:1073741825
010000000002:1073741826

7777777776:1073741822
7777777777:1073741823
10000000000:1073741824
10000000001:1073741825
10000000002:1073741826

# Positive

+07777777776:1073741822
+07777777777:1073741823
+010000000000:1073741824
+010000000001:1073741825
+010000000002:1073741826

+7777777776:1073741822
+7777777777:1073741823
+10000000000:1073741824
+10000000001:1073741825
+10000000002:1073741826

# Negative

-07777777776:-1073741822
-07777777777:-1073741823
-010000000000:-1073741824
-010000000001:-1073741825
-010000000002:-1073741826

-7777777776:-1073741822
-7777777777:-1073741823
-10000000000:-1073741824
-10000000001:-1073741825
-10000000002:-1073741826

###############################################################################
# Absolute value is close to 2^31 = 2147483648
###############################################################################

# Unsigned

017777777776:2147483646
017777777777:2147483647
020000000000:2147483648
020000000001:2147483649
020000000002:2147483650

17777777776:2147483646
17777777777:2147483647
20000000000:2147483648
20000000001:2147483649
20000000002:2147483650

# Positive

+017777777776:2147483646
+017777777777:2147483647
+020000000000:2147483648
+020000000001:2147483649
+020000000002:2147483650

+17777777776:2147483646
+17777777777:2147483647
+20000000000:2147483648
+20000000001:2147483649
+20000000002:2147483650

# Negative

-017777777776:-2147483646
-017777777777:-2147483647
-020000000000:-2147483648
-020000000001:-2147483649
-020000000002:-2147483650

-17777777776:-2147483646
-17777777777:-2147483647
-20000000000:-2147483648
-20000000001:-2147483649
-20000000002:-2147483650

###############################################################################
# Absolute value is close to 2^32 = 4294967296
###############################################################################

# Unsigned

037777777776:4294967294
037777777777:4294967295
040000000000:4294967296
040000000001:4294967297
040000000002:4294967298

37777777776:4294967294
37777777777:4294967295
40000000000:4294967296
40000000001:4294967297
40000000002:4294967298

# Positive

+037777777776:4294967294
+037777777777:4294967295
+040000000000:4294967296
+040000000001:4294967297
+040000000002:4294967298

+37777777776:4294967294
+37777777777:4294967295
+40000000000:4294967296
+40000000001:4294967297
+40000000002:4294967298

# Negative

-037777777776:-4294967294
-037777777777:-4294967295
-040000000000:-4294967296
-040000000001:-4294967297
-040000000002:-4294967298

-37777777776:-4294967294
-37777777777:-4294967295
-40000000000:-4294967296
-40000000001:-4294967297
-40000000002:-4294967298

###############################################################################
# Absolute value is close to 2^33 = 8589934592
###############################################################################

# Unsigned

077777777776:8589934590
077777777777:8589934591
0100000000000:8589934592
0100000000001:8589934593
0100000000002:8589934594

77777777776:8589934590
77777777777:8589934591
100000000000:8589934592
100000000001:8589934593
100000000002:8589934594

# Positive

+077777777776:8589934590
+077777777777:8589934591
+0100000000000:8589934592
+0100000000001:8589934593
+0100000000002:8589934594

+77777777776:8589934590
+77777777777:8589934591
+100000000000:8589934592
+100000000001:8589934593
+100000000002:8589934594

# Negative

-077777777776:-8589934590
-077777777777:-8589934591
-0100000000000:-8589934592
-0100000000001:-8589934593
-0100000000002:-8589934594

-77777777776:-8589934590
-77777777777:-8589934591
-100000000000:-8589934592
-100000000001:-8589934593
-100000000002:-8589934594

###############################################################################
# Absolute value is close to 2^34 = 17179869184
###############################################################################

# Unsigned

0177777777776:17179869182
0177777777777:17179869183
0200000000000:17179869184
0200000000001:17179869185
0200000000002:17179869186

177777777776:17179869182
177777777777:17179869183
200000000000:17179869184
200000000001:17179869185
200000000002:17179869186

# Positive

+0177777777776:17179869182
+0177777777777:17179869183
+0200000000000:17179869184
+0200000000001:17179869185
+0200000000002:17179869186

+177777777776:17179869182
+177777777777:17179869183
+200000000000:17179869184
+200000000001:17179869185
+200000000002:17179869186

# Negative

-0177777777776:-17179869182
-0177777777777:-17179869183
-0200000000000:-17179869184
-0200000000001:-17179869185
-0200000000002:-17179869186

-177777777776:-17179869182
-177777777777:-17179869183
-200000000000:-17179869184
-200000000001:-17179869185
-200000000002:-17179869186

###############################################################################
# Absolute value is close to 2^35 = 34359738368
###############################################################################

# Unsigned

0377777777776:34359738366
0377777777777:34359738367
0400000000000:34359738368
0400000000001:34359738369
0400000000002:34359738370

377777777776:34359738366
377777777777:34359738367
400000000000:34359738368
400000000001:34359738369
400000000002:34359738370

# Positive

+0377777777776:34359738366
+0377777777777:34359738367
+0400000000000:34359738368
+0400000000001:34359738369
+0400000000002:34359738370

+377777777776:34359738366
+377777777777:34359738367
+400000000000:34359738368
+400000000001:34359738369
+400000000002:34359738370

# Negative

-0377777777776:-34359738366
-0377777777777:-34359738367
-0400000000000:-34359738368
-0400000000001:-34359738369
-0400000000002:-34359738370

-377777777776:-34359738366
-377777777777:-34359738367
-400000000000:-34359738368
-400000000001:-34359738369
-400000000002:-34359738370

###############################################################################
# Absolute value is close to 2^36 = 68719476736
###############################################################################

# Unsigned

0777777777776:68719476734
0777777777777:68719476735
01000000000000:68719476736
01000000000001:68719476737
01000000000002:68719476738

777777777776:68719476734
777777777777:68719476735
1000000000000:68719476736
1000000000001:68719476737
1000000000002:68719476738

# Positive

+0777777777776:68719476734
+0777777777777:68719476735
+01000000000000:68719476736
+01000000000001:68719476737
+01000000000002:68719476738

+777777777776:68719476734
+777777777777:68719476735
+1000000000000:68719476736
+1000000000001:68719476737
+1000000000002:68719476738

# Negative

-0777777777776:-68719476734
-0777777777777:-68719476735
-01000000000000:-68719476736
-01000000000001:-68719476737
-01000000000002:-68719476738

-777777777776:-68719476734
-777777777777:-68719476735
-1000000000000:-68719476736
-1000000000001:-68719476737
-1000000000002:-68719476738

###############################################################################
# Absolute value is close to 2^37 = 137438953472
###############################################################################

# Unsigned

01777777777776:137438953470
01777777777777:137438953471
02000000000000:137438953472
02000000000001:137438953473
02000000000002:137438953474

1777777777776:137438953470
1777777777777:137438953471
2000000000000:137438953472
2000000000001:137438953473
2000000000002:137438953474

# Positive

+01777777777776:137438953470
+01777777777777:137438953471
+02000000000000:137438953472
+02000000000001:137438953473
+02000000000002:137438953474

+1777777777776:137438953470
+1777777777777:137438953471
+2000000000000:137438953472
+2000000000001:137438953473
+2000000000002:137438953474

# Negative

-01777777777776:-137438953470
-01777777777777:-137438953471
-02000000000000:-137438953472
-02000000000001:-137438953473
-02000000000002:-137438953474

-1777777777776:-137438953470
-1777777777777:-137438953471
-2000000000000:-137438953472
-2000000000001:-137438953473
-2000000000002:-137438953474

###############################################################################
# Absolute value is close to 2^38 = 274877906944
###############################################################################

# Unsigned

03777777777776:274877906942
03777777777777:274877906943
04000000000000:274877906944
04000000000001:274877906945
04000000000002:274877906946

3777777777776:274877906942
3777777777777:274877906943
4000000000000:274877906944
4000000000001:274877906945
4000000000002:274877906946

# Positive

+03777777777776:274877906942
+03777777777777:274877906943
+04000000000000:274877906944
+04000000000001:274877906945
+04000000000002:274877906946

+3777777777776:274877906942
+3777777777777:274877906943
+4000000000000:274877906944
+4000000000001:274877906945
+4000000000002:274877906946

# Negative

-03777777777776:-274877906942
-03777777777777:-274877906943
-04000000000000:-274877906944
-04000000000001:-274877906945
-04000000000002:-274877906946

-3777777777776:-274877906942
-3777777777777:-274877906943
-4000000000000:-274877906944
-4000000000001:-274877906945
-4000000000002:-274877906946

###############################################################################
# Absolute value is close to 2^39 = 549755813888
###############################################################################

# Unsigned

07777777777776:549755813886
07777777777777:549755813887
010000000000000:549755813888
010000000000001:549755813889
010000000000002:549755813890

7777777777776:549755813886
7777777777777:549755813887
10000000000000:549755813888
10000000000001:549755813889
10000000000002:549755813890

# Positive

+07777777777776:549755813886
+07777777777777:549755813887
+010000000000000:549755813888
+010000000000001:549755813889
+010000000000002:549755813890

+7777777777776:549755813886
+7777777777777:549755813887
+10000000000000:549755813888
+10000000000001:549755813889
+10000000000002:549755813890

# Negative

-07777777777776:-549755813886
-07777777777777:-549755813887
-010000000000000:-549755813888
-010000000000001:-549755813889
-010000000000002:-549755813890

-7777777777776:-549755813886
-7777777777777:-549755813887
-10000000000000:-549755813888
-10000000000001:-549755813889
-10000000000002:-549755813890

###############################################################################
# Absolute value is close to 2^40 = 1099511627776
###############################################################################

# Unsigned

017777777777776:1099511627774
017777777777777:1099511627775
020000000000000:1099511627776
020000000000001:1099511627777
020000000000002:1099511627778

17777777777776:1099511627774
17777777777777:1099511627775
20000000000000:1099511627776
20000000000001:1099511627777
20000000000002:1099511627778

# Positive

+017777777777776:1099511627774
+017777777777777:1099511627775
+020000000000000:1099511627776
+020000000000001:1099511627777
+020000000000002:1099511627778

+17777777777776:1099511627774
+17777777777777:1099511627775
+20000000000000:1099511627776
+20000000000001:1099511627777
+20000000000002:1099511627778

# Negative

-017777777777776:-1099511627774
-017777777777777:-1099511627775
-020000000000000:-1099511627776
-020000000000001:-1099511627777
-020000000000002:-1099511627778

-17777777777776:-1099511627774
-17777777777777:-1099511627775
-20000000000000:-1099511627776
-20000000000001:-1099511627777
-20000000000002:-1099511627778

###############################################################################
# Absolute value is close to 2^41 = 2199023255552
###############################################################################

# Unsigned

037777777777776:2199023255550
037777777777777:2199023255551
040000000000000:2199023255552
040000000000001:2199023255553
040000000000002:2199023255554

37777777777776:2199023255550
37777777777777:2199023255551
40000000000000:2199023255552
40000000000001:2199023255553
40000000000002:2199023255554

# Positive

+037777777777776:2199023255550
+037777777777777:2199023255551
+040000000000000:2199023255552
+040000000000001:2199023255553
+040000000000002:2199023255554

+37777777777776:2199023255550
+37777777777777:2199023255551
+40000000000000:2199023255552
+40000000000001:2199023255553
+40000000000002:2199023255554

# Negative

-037777777777776:-2199023255550
-037777777777777:-2199023255551
-040000000000000:-2199023255552
-040000000000001:-2199023255553
-040000000000002:-2199023255554

-37777777777776:-2199023255550
-37777777777777:-2199023255551
-40000000000000:-2199023255552
-40000000000001:-2199023255553
-40000000000002:-2199023255554

###############################################################################
# Absolute value is close to 2^42 = 4398046511104
###############################################################################

# Unsigned

077777777777776:4398046511102
077777777777777:4398046511103
0100000000000000:4398046511104
0100000000000001:4398046511105
0100000000000002:4398046511106

77777777777776:4398046511102
77777777777777:4398046511103
100000000000000:4398046511104
100000000000001:4398046511105
100000000000002:4398046511106

# Positive

+077777777777776:4398046511102
+077777777777777:4398046511103
+0100000000000000:4398046511104
+0100000000000001:4398046511105
+0100000000000002:4398046511106

+77777777777776:4398046511102
+77777777777777:4398046511103
+100000000000000:4398046511104
+100000000000001:4398046511105
+100000000000002:4398046511106

# Negative

-077777777777776:-4398046511102
-077777777777777:-4398046511103
-0100000000000000:-4398046511104
-0100000000000001:-4398046511105
-0100000000000002:-4398046511106

-77777777777776:-4398046511102
-77777777777777:-4398046511103
-100000000000000:-4398046511104
-100000000000001:-4398046511105
-100000000000002:-4398046511106

###############################################################################
# Absolute value is close to 2^43 = 8796093022208
###############################################################################

# Unsigned

0177777777777776:8796093022206
0177777777777777:8796093022207
0200000000000000:8796093022208
0200000000000001:8796093022209
0200000000000002:8796093022210

177777777777776:8796093022206
177777777777777:8796093022207
200000000000000:8796093022208
200000000000001:8796093022209
200000000000002:8796093022210

# Positive

+0177777777777776:8796093022206
+0177777777777777:8796093022207
+0200000000000000:8796093022208
+0200000000000001:8796093022209
+0200000000000002:8796093022210

+177777777777776:8796093022206
+177777777777777:8796093022207
+200000000000000:8796093022208
+200000000000001:8796093022209
+200000000000002:8796093022210

# Negative

-0177777777777776:-8796093022206
-0177777777777777:-8796093022207
-0200000000000000:-8796093022208
-0200000000000001:-8796093022209
-0200000000000002:-8796093022210

-177777777777776:-8796093022206
-177777777777777:-8796093022207
-200000000000000:-8796093022208
-200000000000001:-8796093022209
-200000000000002:-8796093022210

###############################################################################
# Absolute value is close to 2^44 = 17592186044416
###############################################################################

# Unsigned

0377777777777776:17592186044414
0377777777777777:17592186044415
0400000000000000:17592186044416
0400000000000001:17592186044417
0400000000000002:17592186044418

377777777777776:17592186044414
377777777777777:17592186044415
400000000000000:17592186044416
400000000000001:17592186044417
400000000000002:17592186044418

# Positive

+0377777777777776:17592186044414
+0377777777777777:17592186044415
+0400000000000000:17592186044416
+0400000000000001:17592186044417
+0400000000000002:17592186044418

+377777777777776:17592186044414
+377777777777777:17592186044415
+400000000000000:17592186044416
+400000000000001:17592186044417
+400000000000002:17592186044418

# Negative

-0377777777777776:-17592186044414
-0377777777777777:-17592186044415
-0400000000000000:-17592186044416
-0400000000000001:-17592186044417
-0400000000000002:-17592186044418

-377777777777776:-17592186044414
-377777777777777:-17592186044415
-400000000000000:-17592186044416
-400000000000001:-17592186044417
-400000000000002:-17592186044418

###############################################################################
# Absolute value is close to 2^45 = 35184372088832
###############################################################################

# Unsigned

0777777777777776:35184372088830
0777777777777777:35184372088831
01000000000000000:35184372088832
01000000000000001:35184372088833
01000000000000002:35184372088834

777777777777776:35184372088830
777777777777777:35184372088831
1000000000000000:35184372088832
1000000000000001:35184372088833
1000000000000002:35184372088834

# Positive

+0777777777777776:35184372088830
+0777777777777777:35184372088831
+01000000000000000:35184372088832
+01000000000000001:35184372088833
+01000000000000002:35184372088834

+777777777777776:35184372088830
+777777777777777:35184372088831
+1000000000000000:35184372088832
+1000000000000001:35184372088833
+1000000000000002:35184372088834

# Negative

-0777777777777776:-35184372088830
-0777777777777777:-35184372088831
-01000000000000000:-35184372088832
-01000000000000001:-35184372088833
-01000000000000002:-35184372088834

-777777777777776:-35184372088830
-777777777777777:-35184372088831
-1000000000000000:-35184372088832
-1000000000000001:-35184372088833
-1000000000000002:-35184372088834

###############################################################################
# Absolute value is close to 2^46 = 70368744177664
###############################################################################

# Unsigned

01777777777777776:70368744177662
01777777777777777:70368744177663
02000000000000000:70368744177664
02000000000000001:70368744177665
02000000000000002:70368744177666

1777777777777776:70368744177662
1777777777777777:70368744177663
2000000000000000:70368744177664
2000000000000001:70368744177665
2000000000000002:70368744177666

# Positive

+01777777777777776:70368744177662
+01777777777777777:70368744177663
+02000000000000000:70368744177664
+02000000000000001:70368744177665
+02000000000000002:70368744177666

+1777777777777776:70368744177662
+1777777777777777:70368744177663
+2000000000000000:70368744177664
+2000000000000001:70368744177665
+2000000000000002:70368744177666

# Negative

-01777777777777776:-70368744177662
-01777777777777777:-70368744177663
-02000000000000000:-70368744177664
-02000000000000001:-70368744177665
-02000000000000002:-70368744177666

-1777777777777776:-70368744177662
-1777777777777777:-70368744177663
-2000000000000000:-70368744177664
-2000000000000001:-70368744177665
-2000000000000002:-70368744177666

###############################################################################
# Absolute value is close to 2^47 = 140737488355328
###############################################################################

# Unsigned

03777777777777776:140737488355326
03777777777777777:140737488355327
04000000000000000:140737488355328
04000000000000001:140737488355329
04000000000000002:140737488355330

3777777777777776:140737488355326
3777777777777777:140737488355327
4000000000000000:140737488355328
4000000000000001:140737488355329
4000000000000002:140737488355330

# Positive

+03777777777777776:140737488355326
+03777777777777777:140737488355327
+04000000000000000:140737488355328
+04000000000000001:140737488355329
+04000000000000002:140737488355330

+3777777777777776:140737488355326
+3777777777777777:140737488355327
+4000000000000000:140737488355328
+4000000000000001:140737488355329
+4000000000000002:140737488355330

# Negative

-03777777777777776:-140737488355326
-03777777777777777:-140737488355327
-04000000000000000:-140737488355328
-04000000000000001:-140737488355329
-04000000000000002:-140737488355330

-3777777777777776:-140737488355326
-3777777777777777:-140737488355327
-4000000000000000:-140737488355328
-4000000000000001:-140737488355329
-4000000000000002:-140737488355330

###############################################################################
# Absolute value is close to 2^48 = 281474976710656
###############################################################################

# Unsigned

07777777777777776:281474976710654
07777777777777777:281474976710655
010000000000000000:281474976710656
010000000000000001:281474976710657
010000000000000002:281474976710658

7777777777777776:281474976710654
7777777777777777:281474976710655
10000000000000000:281474976710656
10000000000000001:281474976710657
10000000000000002:281474976710658

# Positive

+07777777777777776:281474976710654
+07777777777777777:281474976710655
+010000000000000000:281474976710656
+010000000000000001:281474976710657
+010000000000000002:281474976710658

+7777777777777776:281474976710654
+7777777777777777:281474976710655
+10000000000000000:281474976710656
+10000000000000001:281474976710657
+10000000000000002:281474976710658

# Negative

-07777777777777776:-281474976710654
-07777777777777777:-281474976710655
-010000000000000000:-281474976710656
-010000000000000001:-281474976710657
-010000000000000002:-281474976710658

-7777777777777776:-281474976710654
-7777777777777777:-281474976710655
-10000000000000000:-281474976710656
-10000000000000001:-281474976710657
-10000000000000002:-281474976710658

###############################################################################
# Absolute value is close to 2^49 = 562949953421312
###############################################################################

# Unsigned

017777777777777776:562949953421310
017777777777777777:562949953421311
020000000000000000:562949953421312
020000000000000001:562949953421313
020000000000000002:562949953421314

17777777777777776:562949953421310
17777777777777777:562949953421311
20000000000000000:562949953421312
20000000000000001:562949953421313
20000000000000002:562949953421314

# Positive

+017777777777777776:562949953421310
+017777777777777777:562949953421311
+020000000000000000:562949953421312
+020000000000000001:562949953421313
+020000000000000002:562949953421314

+17777777777777776:562949953421310
+17777777777777777:562949953421311
+20000000000000000:562949953421312
+20000000000000001:562949953421313
+20000000000000002:562949953421314

# Negative

-017777777777777776:-562949953421310
-017777777777777777:-562949953421311
-020000000000000000:-562949953421312
-020000000000000001:-562949953421313
-020000000000000002:-562949953421314

-17777777777777776:-562949953421310
-17777777777777777:-562949953421311
-20000000000000000:-562949953421312
-20000000000000001:-562949953421313
-20000000000000002:-562949953421314

###############################################################################
# Absolute value is close to 2^50 = 1125899906842624
###############################################################################

# Unsigned

037777777777777776:1125899906842622
037777777777777777:1125899906842623
040000000000000000:1125899906842624
040000000000000001:1125899906842625
040000000000000002:1125899906842626

37777777777777776:1125899906842622
37777777777777777:1125899906842623
40000000000000000:1125899906842624
40000000000000001:1125899906842625
40000000000000002:1125899906842626

# Positive

+037777777777777776:1125899906842622
+037777777777777777:1125899906842623
+040000000000000000:1125899906842624
+040000000000000001:1125899906842625
+040000000000000002:1125899906842626

+37777777777777776:1125899906842622
+37777777777777777:1125899906842623
+40000000000000000:1125899906842624
+40000000000000001:1125899906842625
+40000000000000002:1125899906842626

# Negative

-037777777777777776:-1125899906842622
-037777777777777777:-1125899906842623
-040000000000000000:-1125899906842624
-040000000000000001:-1125899906842625
-040000000000000002:-1125899906842626

-37777777777777776:-1125899906842622
-37777777777777777:-1125899906842623
-40000000000000000:-1125899906842624
-40000000000000001:-1125899906842625
-40000000000000002:-1125899906842626

###############################################################################
# Absolute value is close to 2^51 = 2251799813685248
###############################################################################

# Unsigned

077777777777777776:2251799813685246
077777777777777777:2251799813685247
0100000000000000000:2251799813685248
0100000000000000001:2251799813685249
0100000000000000002:2251799813685250

77777777777777776:2251799813685246
77777777777777777:2251799813685247
100000000000000000:2251799813685248
100000000000000001:2251799813685249
100000000000000002:2251799813685250

# Positive

+077777777777777776:2251799813685246
+077777777777777777:2251799813685247
+0100000000000000000:2251799813685248
+0100000000000000001:2251799813685249
+0100000000000000002:2251799813685250

+77777777777777776:2251799813685246
+77777777777777777:2251799813685247
+100000000000000000:2251799813685248
+100000000000000001:2251799813685249
+100000000000000002:2251799813685250

# Negative

-077777777777777776:-2251799813685246
-077777777777777777:-2251799813685247
-0100000000000000000:-2251799813685248
-0100000000000000001:-2251799813685249
-0100000000000000002:-2251799813685250

-77777777777777776:-2251799813685246
-77777777777777777:-2251799813685247
-100000000000000000:-2251799813685248
-100000000000000001:-2251799813685249
-100000000000000002:-2251799813685250

###############################################################################
# Absolute value is close to 2^52 = 4503599627370496
###############################################################################

# Unsigned

0177777777777777776:4503599627370494
0177777777777777777:4503599627370495
0200000000000000000:4503599627370496
0200000000000000001:4503599627370497
0200000000000000002:4503599627370498

177777777777777776:4503599627370494
177777777777777777:4503599627370495
200000000000000000:4503599627370496
200000000000000001:4503599627370497
200000000000000002:4503599627370498

# Positive

+0177777777777777776:4503599627370494
+0177777777777777777:4503599627370495
+0200000000000000000:4503599627370496
+0200000000000000001:4503599627370497
+0200000000000000002:4503599627370498

+177777777777777776:4503599627370494
+177777777777777777:4503599627370495
+200000000000000000:4503599627370496
+200000000000000001:4503599627370497
+200000000000000002:4503599627370498

# Negative

-0177777777777777776:-4503599627370494
-0177777777777777777:-4503599627370495
-0200000000000000000:-4503599627370496
-0200000000000000001:-4503599627370497
-0200000000000000002:-4503599627370498

-177777777777777776:-4503599627370494
-177777777777777777:-4503599627370495
-200000000000000000:-4503599627370496
-200000000000000001:-4503599627370497
-200000000000000002:-4503599627370498

###############################################################################
# Absolute value is close to 2^53 = 9007199254740992
###############################################################################

# Unsigned

0377777777777777776:9007199254740990
0377777777777777777:9007199254740991
0400000000000000000:9007199254740992
0400000000000000001:9007199254740993
0400000000000000002:9007199254740994

377777777777777776:9007199254740990
377777777777777777:9007199254740991
400000000000000000:9007199254740992
400000000000000001:9007199254740993
400000000000000002:9007199254740994

# Positive

+0377777777777777776:9007199254740990
+0377777777777777777:9007199254740991
+0400000000000000000:9007199254740992
+0400000000000000001:9007199254740993
+0400000000000000002:9007199254740994

+377777777777777776:9007199254740990
+377777777777777777:9007199254740991
+400000000000000000:9007199254740992
+400000000000000001:9007199254740993
+400000000000000002:9007199254740994

# Negative

-0377777777777777776:-9007199254740990
-0377777777777777777:-9007199254740991
-0400000000000000000:-9007199254740992
-0400000000000000001:-9007199254740993
-0400000000000000002:-9007199254740994

-377777777777777776:-9007199254740990
-377777777777777777:-9007199254740991
-400000000000000000:-9007199254740992
-400000000000000001:-9007199254740993
-400000000000000002:-9007199254740994

###############################################################################
# Absolute value is close to 2^54 = 18014398509481984
###############################################################################

# Unsigned

0777777777777777776:18014398509481982
0777777777777777777:18014398509481983
01000000000000000000:18014398509481984
01000000000000000001:18014398509481985
01000000000000000002:18014398509481986

777777777777777776:18014398509481982
777777777777777777:18014398509481983
1000000000000000000:18014398509481984
1000000000000000001:18014398509481985
1000000000000000002:18014398509481986

# Positive

+0777777777777777776:18014398509481982
+0777777777777777777:18014398509481983
+01000000000000000000:18014398509481984
+01000000000000000001:18014398509481985
+01000000000000000002:18014398509481986

+777777777777777776:18014398509481982
+777777777777777777:18014398509481983
+1000000000000000000:18014398509481984
+1000000000000000001:18014398509481985
+1000000000000000002:18014398509481986

# Negative

-0777777777777777776:-18014398509481982
-0777777777777777777:-18014398509481983
-01000000000000000000:-18014398509481984
-01000000000000000001:-18014398509481985
-01000000000000000002:-18014398509481986

-777777777777777776:-18014398509481982
-777777777777777777:-18014398509481983
-1000000000000000000:-18014398509481984
-1000000000000000001:-18014398509481985
-1000000000000000002:-18014398509481986

###############################################################################
# Absolute value is close to 2^55 = 36028797018963968
###############################################################################

# Unsigned

01777777777777777776:36028797018963966
01777777777777777777:36028797018963967
02000000000000000000:36028797018963968
02000000000000000001:36028797018963969
02000000000000000002:36028797018963970

1777777777777777776:36028797018963966
1777777777777777777:36028797018963967
2000000000000000000:36028797018963968
2000000000000000001:36028797018963969
2000000000000000002:36028797018963970

# Positive

+01777777777777777776:36028797018963966
+01777777777777777777:36028797018963967
+02000000000000000000:36028797018963968
+02000000000000000001:36028797018963969
+02000000000000000002:36028797018963970

+1777777777777777776:36028797018963966
+1777777777777777777:36028797018963967
+2000000000000000000:36028797018963968
+2000000000000000001:36028797018963969
+2000000000000000002:36028797018963970

# Negative

-01777777777777777776:-36028797018963966
-01777777777777777777:-36028797018963967
-02000000000000000000:-36028797018963968
-02000000000000000001:-36028797018963969
-02000000000000000002:-36028797018963970

-1777777777777777776:-36028797018963966
-1777777777777777777:-36028797018963967
-2000000000000000000:-36028797018963968
-2000000000000000001:-36028797018963969
-2000000000000000002:-36028797018963970

###############################################################################
# Absolute value is close to 2^56 = 72057594037927936
###############################################################################

# Unsigned

03777777777777777776:72057594037927934
03777777777777777777:72057594037927935
04000000000000000000:72057594037927936
04000000000000000001:72057594037927937
04000000000000000002:72057594037927938

3777777777777777776:72057594037927934
3777777777777777777:72057594037927935
4000000000000000000:72057594037927936
4000000000000000001:72057594037927937
4000000000000000002:72057594037927938

# Positive

+03777777777777777776:72057594037927934
+03777777777777777777:72057594037927935
+04000000000000000000:72057594037927936
+04000000000000000001:72057594037927937
+04000000000000000002:72057594037927938

+3777777777777777776:72057594037927934
+3777777777777777777:72057594037927935
+4000000000000000000:72057594037927936
+4000000000000000001:72057594037927937
+4000000000000000002:72057594037927938

# Negative

-03777777777777777776:-72057594037927934
-03777777777777777777:-72057594037927935
-04000000000000000000:-72057594037927936
-04000000000000000001:-72057594037927937
-04000000000000000002:-72057594037927938

-3777777777777777776:-72057594037927934
-3777777777777777777:-72057594037927935
-4000000000000000000:-72057594037927936
-4000000000000000001:-72057594037927937
-4000000000000000002:-72057594037927938

###############################################################################
# Absolute value is close to 2^57 = 144115188075855872
###############################################################################

# Unsigned

07777777777777777776:144115188075855870
07777777777777777777:144115188075855871
010000000000000000000:144115188075855872
010000000000000000001:144115188075855873
010000000000000000002:144115188075855874

7777777777777777776:144115188075855870
7777777777777777777:144115188075855871
10000000000000000000:144115188075855872
10000000000000000001:144115188075855873
10000000000000000002:144115188075855874

# Positive

+07777777777777777776:144115188075855870
+07777777777777777777:144115188075855871
+010000000000000000000:144115188075855872
+010000000000000000001:144115188075855873
+010000000000000000002:144115188075855874

+7777777777777777776:144115188075855870
+7777777777777777777:144115188075855871
+10000000000000000000:144115188075855872
+10000000000000000001:144115188075855873
+10000000000000000002:144115188075855874

# Negative

-07777777777777777776:-144115188075855870
-07777777777777777777:-144115188075855871
-010000000000000000000:-144115188075855872
-010000000000000000001:-144115188075855873
-010000000000000000002:-144115188075855874

-7777777777777777776:-144115188075855870
-7777777777777777777:-144115188075855871
-10000000000000000000:-144115188075855872
-10000000000000000001:-144115188075855873
-10000000000000000002:-144115188075855874

###############################################################################
# Absolute value is close to 2^58 = 288230376151711744
###############################################################################

# Unsigned

017777777777777777776:288230376151711742
017777777777777777777:288230376151711743
020000000000000000000:288230376151711744
020000000000000000001:288230376151711745
020000000000000000002:288230376151711746

17777777777777777776:288230376151711742
17777777777777777777:288230376151711743
20000000000000000000:288230376151711744
20000000000000000001:288230376151711745
20000000000000000002:288230376151711746

# Positive

+017777777777777777776:288230376151711742
+017777777777777777777:288230376151711743
+020000000000000000000:288230376151711744
+020000000000000000001:288230376151711745
+020000000000000000002:288230376151711746

+17777777777777777776:288230376151711742
+17777777777777777777:288230376151711743
+20000000000000000000:288230376151711744
+20000000000000000001:288230376151711745
+20000000000000000002:288230376151711746

# Negative

-017777777777777777776:-288230376151711742
-017777777777777777777:-288230376151711743
-020000000000000000000:-288230376151711744
-020000000000000000001:-288230376151711745
-020000000000000000002:-288230376151711746

-17777777777777777776:-288230376151711742
-17777777777777777777:-288230376151711743
-20000000000000000000:-288230376151711744
-20000000000000000001:-288230376151711745
-20000000000000000002:-288230376151711746

###############################################################################
# Absolute value is close to 2^59 = 576460752303423488
###############################################################################

# Unsigned

037777777777777777776:576460752303423486
037777777777777777777:576460752303423487
040000000000000000000:576460752303423488
040000000000000000001:576460752303423489
040000000000000000002:576460752303423490

37777777777777777776:576460752303423486
37777777777777777777:576460752303423487
40000000000000000000:576460752303423488
40000000000000000001:576460752303423489
40000000000000000002:576460752303423490

# Positive

+037777777777777777776:576460752303423486
+037777777777777777777:576460752303423487
+040000000000000000000:576460752303423488
+040000000000000000001:576460752303423489
+040000000000000000002:576460752303423490

+37777777777777777776:576460752303423486
+37777777777777777777:576460752303423487
+40000000000000000000:576460752303423488
+40000000000000000001:576460752303423489
+40000000000000000002:576460752303423490

# Negative

-037777777777777777776:-576460752303423486
-037777777777777777777:-576460752303423487
-040000000000000000000:-576460752303423488
-040000000000000000001:-576460752303423489
-040000000000000000002:-576460752303423490

-37777777777777777776:-576460752303423486
-37777777777777777777:-576460752303423487
-40000000000000000000:-576460752303423488
-40000000000000000001:-576460752303423489
-40000000000000000002:-576460752303423490

###############################################################################
# Absolute value is close to 2^60 = 1152921504606846976
###############################################################################

# Unsigned

077777777777777777776:1152921504606846974
077777777777777777777:1152921504606846975
0100000000000000000000:1152921504606846976
0100000000000000000001:1152921504606846977
0100000000000000000002:1152921504606846978

77777777777777777776:1152921504606846974
77777777777777777777:1152921504606846975
100000000000000000000:1152921504606846976
100000000000000000001:1152921504606846977
100000000000000000002:1152921504606846978

# Positive

+077777777777777777776:1152921504606846974
+077777777777777777777:1152921504606846975
+0100000000000000000000:1152921504606846976
+0100000000000000000001:1152921504606846977
+0100000000000000000002:1152921504606846978

+77777777777777777776:1152921504606846974
+77777777777777777777:1152921504606846975
+100000000000000000000:1152921504606846976
+100000000000000000001:1152921504606846977
+100000000000000000002:1152921504606846978

# Negative

-077777777777777777776:-1152921504606846974
-077777777777777777777:-1152921504606846975
-0100000000000000000000:-1152921504606846976
-0100000000000000000001:-1152921504606846977
-0100000000000000000002:-1152921504606846978

-77777777777777777776:-1152921504606846974
-77777777777777777777:-1152921504606846975
-100000000000000000000:-1152921504606846976
-100000000000000000001:-1152921504606846977
-100000000000000000002:-1152921504606846978

###############################################################################
# Absolute value is close to 2^61 = 2305843009213693952
###############################################################################

# Unsigned

0177777777777777777776:2305843009213693950
0177777777777777777777:2305843009213693951
0200000000000000000000:2305843009213693952
0200000000000000000001:2305843009213693953
0200000000000000000002:2305843009213693954

177777777777777777776:2305843009213693950
177777777777777777777:2305843009213693951
200000000000000000000:2305843009213693952
200000000000000000001:2305843009213693953
200000000000000000002:2305843009213693954

# Positive

+0177777777777777777776:2305843009213693950
+0177777777777777777777:2305843009213693951
+0200000000000000000000:2305843009213693952
+0200000000000000000001:2305843009213693953
+0200000000000000000002:2305843009213693954

+177777777777777777776:2305843009213693950
+177777777777777777777:2305843009213693951
+200000000000000000000:2305843009213693952
+200000000000000000001:2305843009213693953
+200000000000000000002:2305843009213693954

# Negative

-0177777777777777777776:-2305843009213693950
-0177777777777777777777:-2305843009213693951
-0200000000000000000000:-2305843009213693952
-0200000000000000000001:-2305843009213693953
-0200000000000000000002:-2305843009213693954

-177777777777777777776:-2305843009213693950
-177777777777777777777:-2305843009213693951
-200000000000000000000:-2305843009213693952
-200000000000000000001:-2305843009213693953
-200000000000000000002:-2305843009213693954

###############################################################################
# Absolute value is close to 2^62 = 4611686018427387904
###############################################################################

# Unsigned

0377777777777777777776:4611686018427387902
0377777777777777777777:4611686018427387903
0400000000000000000000:4611686018427387904
0400000000000000000001:4611686018427387905
0400000000000000000002:4611686018427387906

377777777777777777776:4611686018427387902
377777777777777777777:4611686018427387903
400000000000000000000:4611686018427387904
400000000000000000001:4611686018427387905
400000000000000000002:4611686018427387906

# Positive

+0377777777777777777776:4611686018427387902
+0377777777777777777777:4611686018427387903
+0400000000000000000000:4611686018427387904
+0400000000000000000001:4611686018427387905
+0400000000000000000002:4611686018427387906

+377777777777777777776:4611686018427387902
+377777777777777777777:4611686018427387903
+400000000000000000000:4611686018427387904
+400000000000000000001:4611686018427387905
+400000000000000000002:4611686018427387906

# Negative

-0377777777777777777776:-4611686018427387902
-0377777777777777777777:-4611686018427387903
-0400000000000000000000:-4611686018427387904
-0400000000000000000001:-4611686018427387905
-0400000000000000000002:-4611686018427387906

-377777777777777777776:-4611686018427387902
-377777777777777777777:-4611686018427387903
-400000000000000000000:-4611686018427387904
-400000000000000000001:-4611686018427387905
-400000000000000000002:-4611686018427387906

###############################################################################
# Absolute value is close to 2^63 = 9223372036854775808
###############################################################################

# Unsigned

0777777777777777777776:9223372036854775806
0777777777777777777777:9223372036854775807
01000000000000000000000:9223372036854775808
01000000000000000000001:9223372036854775809
01000000000000000000002:9223372036854775810

777777777777777777776:9223372036854775806
777777777777777777777:9223372036854775807
1000000000000000000000:9223372036854775808
1000000000000000000001:9223372036854775809
1000000000000000000002:9223372036854775810

# Positive

+0777777777777777777776:9223372036854775806
+0777777777777777777777:9223372036854775807
+01000000000000000000000:9223372036854775808
+01000000000000000000001:9223372036854775809
+01000000000000000000002:9223372036854775810

+777777777777777777776:9223372036854775806
+777777777777777777777:9223372036854775807
+1000000000000000000000:9223372036854775808
+1000000000000000000001:9223372036854775809
+1000000000000000000002:9223372036854775810

# Negative

-0777777777777777777776:-9223372036854775806
-0777777777777777777777:-9223372036854775807
-01000000000000000000000:-9223372036854775808
-01000000000000000000001:-9223372036854775809
-01000000000000000000002:-9223372036854775810

-777777777777777777776:-9223372036854775806
-777777777777777777777:-9223372036854775807
-1000000000000000000000:-9223372036854775808
-1000000000000000000001:-9223372036854775809
-1000000000000000000002:-9223372036854775810

###############################################################################
# Absolute value is close to 2^64 = 18446744073709551616
###############################################################################

# Unsigned

01777777777777777777776:18446744073709551614
01777777777777777777777:18446744073709551615
02000000000000000000000:18446744073709551616
02000000000000000000001:18446744073709551617
02000000000000000000002:18446744073709551618

1777777777777777777776:18446744073709551614
1777777777777777777777:18446744073709551615
2000000000000000000000:18446744073709551616
2000000000000000000001:18446744073709551617
2000000000000000000002:18446744073709551618

# Positive

+01777777777777777777776:18446744073709551614
+01777777777777777777777:18446744073709551615
+02000000000000000000000:18446744073709551616
+02000000000000000000001:18446744073709551617
+02000000000000000000002:18446744073709551618

+1777777777777777777776:18446744073709551614
+1777777777777777777777:18446744073709551615
+2000000000000000000000:18446744073709551616
+2000000000000000000001:18446744073709551617
+2000000000000000000002:18446744073709551618

# Negative

-01777777777777777777776:-18446744073709551614
-01777777777777777777777:-18446744073709551615
-02000000000000000000000:-18446744073709551616
-02000000000000000000001:-18446744073709551617
-02000000000000000000002:-18446744073709551618

-1777777777777777777776:-18446744073709551614
-1777777777777777777777:-18446744073709551615
-2000000000000000000000:-18446744073709551616
-2000000000000000000001:-18446744073709551617
-2000000000000000000002:-18446744073709551618

###############################################################################
# Absolute value is close to 2^65 = 36893488147419103232
###############################################################################

# Unsigned

03777777777777777777776:36893488147419103230
03777777777777777777777:36893488147419103231
04000000000000000000000:36893488147419103232
04000000000000000000001:36893488147419103233
04000000000000000000002:36893488147419103234

3777777777777777777776:36893488147419103230
3777777777777777777777:36893488147419103231
4000000000000000000000:36893488147419103232
4000000000000000000001:36893488147419103233
4000000000000000000002:36893488147419103234

# Positive

+03777777777777777777776:36893488147419103230
+03777777777777777777777:36893488147419103231
+04000000000000000000000:36893488147419103232
+04000000000000000000001:36893488147419103233
+04000000000000000000002:36893488147419103234

+3777777777777777777776:36893488147419103230
+3777777777777777777777:36893488147419103231
+4000000000000000000000:36893488147419103232
+4000000000000000000001:36893488147419103233
+4000000000000000000002:36893488147419103234

# Negative

-03777777777777777777776:-36893488147419103230
-03777777777777777777777:-36893488147419103231
-04000000000000000000000:-36893488147419103232
-04000000000000000000001:-36893488147419103233
-04000000000000000000002:-36893488147419103234

-3777777777777777777776:-36893488147419103230
-3777777777777777777777:-36893488147419103231
-4000000000000000000000:-36893488147419103232
-4000000000000000000001:-36893488147419103233
-4000000000000000000002:-36893488147419103234

###############################################################################
# Absolute value is close to 10^1 = 10
###############################################################################

# Unsigned

010:8
011:9
012:10
013:11
014:12

10:8
11:9
12:10
13:11
14:12

# Positive

+010:8
+011:9
+012:10
+013:11
+014:12

+10:8
+11:9
+12:10
+13:11
+14:12

# Negative

-010:-8
-011:-9
-012:-10
-013:-11
-014:-12

-10:-8
-11:-9
-12:-10
-13:-11
-14:-12

###############################################################################
# Absolute value is close to 10^2 = 100
###############################################################################

# Unsigned

0142:98
0143:99
0144:100
0145:101
0146:102

142:98
143:99
144:100
145:101
146:102

# Positive

+0142:98
+0143:99
+0144:100
+0145:101
+0146:102

+142:98
+143:99
+144:100
+145:101
+146:102

# Negative

-0142:-98
-0143:-99
-0144:-100
-0145:-101
-0146:-102

-142:-98
-143:-99
-144:-100
-145:-101
-146:-102

###############################################################################
# Absolute value is close to 10^3 = 1000
###############################################################################

# Unsigned

01746:998
01747:999
01750:1000
01751:1001
01752:1002

1746:998
1747:999
1750:1000
1751:1001
1752:1002

# Positive

+01746:998
+01747:999
+01750:1000
+01751:1001
+01752:1002

+1746:998
+1747:999
+1750:1000
+1751:1001
+1752:1002

# Negative

-01746:-998
-01747:-999
-01750:-1000
-01751:-1001
-01752:-1002

-1746:-998
-1747:-999
-1750:-1000
-1751:-1001
-1752:-1002

###############################################################################
# Absolute value is close to 10^4 = 10000
###############################################################################

# Unsigned

023416:9998
023417:9999
023420:10000
023421:10001
023422:10002

23416:9998
23417:9999
23420:10000
23421:10001
23422:10002

# Positive

+023416:9998
+023417:9999
+023420:10000
+023421:10001
+023422:10002

+23416:9998
+23417:9999
+23420:10000
+23421:10001
+23422:10002

# Negative

-023416:-9998
-023417:-9999
-023420:-10000
-023421:-10001
-023422:-10002

-23416:-9998
-23417:-9999
-23420:-10000
-23421:-10001
-23422:-10002

###############################################################################
# Absolute value is close to 10^5 = 100000
###############################################################################

# Unsigned

0303236:99998
0303237:99999
0303240:100000
0303241:100001
0303242:100002

303236:99998
303237:99999
303240:100000
303241:100001
303242:100002

# Positive

+0303236:99998
+0303237:99999
+0303240:100000
+0303241:100001
+0303242:100002

+303236:99998
+303237:99999
+303240:100000
+303241:100001
+303242:100002

# Negative

-0303236:-99998
-0303237:-99999
-0303240:-100000
-0303241:-100001
-0303242:-100002

-303236:-99998
-303237:-99999
-303240:-100000
-303241:-100001
-303242:-100002

###############################################################################
# Absolute value is close to 10^6 = 1000000
###############################################################################

# Unsigned

03641076:999998
03641077:999999
03641100:1000000
03641101:1000001
03641102:1000002

3641076:999998
3641077:999999
3641100:1000000
3641101:1000001
3641102:1000002

# Positive

+03641076:999998
+03641077:999999
+03641100:1000000
+03641101:1000001
+03641102:1000002

+3641076:999998
+3641077:999999
+3641100:1000000
+3641101:1000001
+3641102:1000002

# Negative

-03641076:-999998
-03641077:-999999
-03641100:-1000000
-03641101:-1000001
-03641102:-1000002

-3641076:-999998
-3641077:-999999
-3641100:-1000000
-3641101:-1000001
-3641102:-1000002

###############################################################################
# Absolute value is close to 10^7 = 10000000
###############################################################################

# Unsigned

046113176:9999998
046113177:9999999
046113200:10000000
046113201:10000001
046113202:10000002

46113176:9999998
46113177:9999999
46113200:10000000
46113201:10000001
46113202:10000002

# Positive

+046113176:9999998
+046113177:9999999
+046113200:10000000
+046113201:10000001
+046113202:10000002

+46113176:9999998
+46113177:9999999
+46113200:10000000
+46113201:10000001
+46113202:10000002

# Negative

-046113176:-9999998
-046113177:-9999999
-046113200:-10000000
-046113201:-10000001
-046113202:-10000002

-46113176:-9999998
-46113177:-9999999
-46113200:-10000000
-46113201:-10000001
-46113202:-10000002

###############################################################################
# Absolute value is close to 10^8 = 100000000
###############################################################################

# Unsigned

0575360376:99999998
0575360377:99999999
0575360400:100000000
0575360401:100000001
0575360402:100000002

575360376:99999998
575360377:99999999
575360400:100000000
575360401:100000001
575360402:100000002

# Positive

+0575360376:99999998
+0575360377:99999999
+0575360400:100000000
+0575360401:100000001
+0575360402:100000002

+575360376:99999998
+575360377:99999999
+575360400:100000000
+575360401:100000001
+575360402:100000002

# Negative

-0575360376:-99999998
-0575360377:-99999999
-0575360400:-100000000
-0575360401:-100000001
-0575360402:-100000002

-575360376:-99999998
-575360377:-99999999
-575360400:-100000000
-575360401:-100000001
-575360402:-100000002

###############################################################################
# Absolute value is close to 10^9 = 1000000000
###############################################################################

# Unsigned

07346544776:999999998
07346544777:999999999
07346545000:1000000000
07346545001:1000000001
07346545002:1000000002

7346544776:999999998
7346544777:999999999
7346545000:1000000000
7346545001:1000000001
7346545002:1000000002

# Positive

+07346544776:999999998
+07346544777:999999999
+07346545000:1000000000
+07346545001:1000000001
+07346545002:1000000002

+7346544776:999999998
+7346544777:999999999
+7346545000:1000000000
+7346545001:1000000001
+7346545002:1000000002

# Negative

-07346544776:-999999998
-07346544777:-999999999
-07346545000:-1000000000
-07346545001:-1000000001
-07346545002:-1000000002

-7346544776:-999999998
-7346544777:-999999999
-7346545000:-1000000000
-7346545001:-1000000001
-7346545002:-1000000002

###############################################################################
# Absolute value is close to 10^10 = 10000000000
###############################################################################

# Unsigned

0112402761776:9999999998
0112402761777:9999999999
0112402762000:10000000000
0112402762001:10000000001
0112402762002:10000000002

112402761776:9999999998
112402761777:9999999999
112402762000:10000000000
112402762001:10000000001
112402762002:10000000002

# Positive

+0112402761776:9999999998
+0112402761777:9999999999
+0112402762000:10000000000
+0112402762001:10000000001
+0112402762002:10000000002

+112402761776:9999999998
+112402761777:9999999999
+112402762000:10000000000
+112402762001:10000000001
+112402762002:10000000002

# Negative

-0112402761776:-9999999998
-0112402761777:-9999999999
-0112402762000:-10000000000
-0112402762001:-10000000001
-0112402762002:-10000000002

-112402761776:-9999999998
-112402761777:-9999999999
-112402762000:-10000000000
-112402762001:-10000000001
-112402762002:-10000000002

###############################################################################
# Absolute value is close to 10^11 = 100000000000
###############################################################################

# Unsigned

01351035563776:99999999998
01351035563777:99999999999
01351035564000:100000000000
01351035564001:100000000001
01351035564002:100000000002

1351035563776:99999999998
1351035563777:99999999999
1351035564000:100000000000
1351035564001:100000000001
1351035564002:100000000002

# Positive

+01351035563776:99999999998
+01351035563777:99999999999
+01351035564000:100000000000
+01351035564001:100000000001
+01351035564002:100000000002

+1351035563776:99999999998
+1351035563777:99999999999
+1351035564000:100000000000
+1351035564001:100000000001
+1351035564002:100000000002

# Negative

-01351035563776:-99999999998
-01351035563777:-99999999999
-01351035564000:-100000000000
-01351035564001:-100000000001
-01351035564002:-100000000002

-1351035563776:-99999999998
-1351035563777:-99999999999
-1351035564000:-100000000000
-1351035564001:-100000000001
-1351035564002:-100000000002

###############################################################################
# Absolute value is close to 10^12 = 1000000000000
###############################################################################

# Unsigned

016432451207776:999999999998
016432451207777:999999999999
016432451210000:1000000000000
016432451210001:1000000000001
016432451210002:1000000000002

16432451207776:999999999998
16432451207777:999999999999
16432451210000:1000000000000
16432451210001:1000000000001
16432451210002:1000000000002

# Positive

+016432451207776:999999999998
+016432451207777:999999999999
+016432451210000:1000000000000
+016432451210001:1000000000001
+016432451210002:1000000000002

+16432451207776:999999999998
+16432451207777:999999999999
+16432451210000:1000000000000
+16432451210001:1000000000001
+16432451210002:1000000000002

# Negative

-016432451207776:-999999999998
-016432451207777:-999999999999
-016432451210000:-1000000000000
-016432451210001:-1000000000001
-016432451210002:-1000000000002

-16432451207776:-999999999998
-16432451207777:-999999999999
-16432451210000:-1000000000000
-16432451210001:-1000000000001
-16432451210002:-1000000000002

###############################################################################
# Absolute value is close to 10^13 = 10000000000000
###############################################################################

# Unsigned

0221411634517776:9999999999998
0221411634517777:9999999999999
0221411634520000:10000000000000
0221411634520001:10000000000001
0221411634520002:10000000000002

221411634517776:9999999999998
221411634517777:9999999999999
221411634520000:10000000000000
221411634520001:10000000000001
221411634520002:10000000000002

# Positive

+0221411634517776:9999999999998
+0221411634517777:9999999999999
+0221411634520000:10000000000000
+0221411634520001:10000000000001
+0221411634520002:10000000000002

+221411634517776:9999999999998
+221411634517777:9999999999999
+221411634520000:10000000000000
+221411634520001:10000000000001
+221411634520002:10000000000002

# Negative

-0221411634517776:-9999999999998
-0221411634517777:-9999999999999
-0221411634520000:-10000000000000
-0221411634520001:-10000000000001
-0221411634520002:-10000000000002

-221411634517776:-9999999999998
-221411634517777:-9999999999999
-221411634520000:-10000000000000
-221411634520001:-10000000000001
-221411634520002:-10000000000002

###############################################################################
# Absolute value is close to 10^14 = 100000000000000
###############################################################################

# Unsigned

02657142036437776:99999999999998
02657142036437777:99999999999999
02657142036440000:100000000000000
02657142036440001:100000000000001
02657142036440002:100000000000002

2657142036437776:99999999999998
2657142036437777:99999999999999
2657142036440000:100000000000000
2657142036440001:100000000000001
2657142036440002:100000000000002

# Positive

+02657142036437776:99999999999998
+02657142036437777:99999999999999
+02657142036440000:100000000000000
+02657142036440001:100000000000001
+02657142036440002:100000000000002

+2657142036437776:99999999999998
+2657142036437777:99999999999999
+2657142036440000:100000000000000
+2657142036440001:100000000000001
+2657142036440002:100000000000002

# Negative

-02657142036437776:-99999999999998
-02657142036437777:-99999999999999
-02657142036440000:-100000000000000
-02657142036440001:-100000000000001
-02657142036440002:-100000000000002

-2657142036437776:-99999999999998
-2657142036437777:-99999999999999
-2657142036440000:-100000000000000
-2657142036440001:-100000000000001
-2657142036440002:-100000000000002

###############################################################################
# Absolute value is close to 10^15 = 1000000000000000
###############################################################################

# Unsigned

034327724461477776:999999999999998
034327724461477777:999999999999999
034327724461500000:1000000000000000
034327724461500001:1000000000000001
034327724461500002:1000000000000002

34327724461477776:999999999999998
34327724461477777:999999999999999
34327724461500000:1000000000000000
34327724461500001:1000000000000001
34327724461500002:1000000000000002

# Positive

+034327724461477776:999999999999998
+034327724461477777:999999999999999
+034327724461500000:1000000000000000
+034327724461500001:1000000000000001
+034327724461500002:1000000000000002

+34327724461477776:999999999999998
+34327724461477777:999999999999999
+34327724461500000:1000000000000000
+34327724461500001:1000000000000001
+34327724461500002:1000000000000002

# Negative

-034327724461477776:-999999999999998
-034327724461477777:-999999999999999
-034327724461500000:-1000000000000000
-034327724461500001:-1000000000000001
-034327724461500002:-1000000000000002

-34327724461477776:-999999999999998
-34327724461477777:-999999999999999
-34327724461500000:-1000000000000000
-34327724461500001:-1000000000000001
-34327724461500002:-1000000000000002

###############################################################################
# Absolute value is close to 10^16 = 10000000000000000
###############################################################################

# Unsigned

0434157115760177776:9999999999999998
0434157115760177777:9999999999999999
0434157115760200000:10000000000000000
0434157115760200001:10000000000000001
0434157115760200002:10000000000000002

434157115760177776:9999999999999998
434157115760177777:9999999999999999
434157115760200000:10000000000000000
434157115760200001:10000000000000001
434157115760200002:10000000000000002

# Positive

+0434157115760177776:9999999999999998
+0434157115760177777:9999999999999999
+0434157115760200000:10000000000000000
+0434157115760200001:10000000000000001
+0434157115760200002:10000000000000002

+434157115760177776:9999999999999998
+434157115760177777:9999999999999999
+434157115760200000:10000000000000000
+434157115760200001:10000000000000001
+434157115760200002:10000000000000002

# Negative

-0434157115760177776:-9999999999999998
-0434157115760177777:-9999999999999999
-0434157115760200000:-10000000000000000
-0434157115760200001:-10000000000000001
-0434157115760200002:-10000000000000002

-434157115760177776:-9999999999999998
-434157115760177777:-9999999999999999
-434157115760200000:-10000000000000000
-434157115760200001:-10000000000000001
-434157115760200002:-10000000000000002

###############################################################################
# Absolute value is close to 10^17 = 100000000000000000
###############################################################################

# Unsigned

05432127413542377776:99999999999999998
05432127413542377777:99999999999999999
05432127413542400000:100000000000000000
05432127413542400001:100000000000000001
05432127413542400002:100000000000000002

5432127413542377776:99999999999999998
5432127413542377777:99999999999999999
5432127413542400000:100000000000000000
5432127413542400001:100000000000000001
5432127413542400002:100000000000000002

# Positive

+05432127413542377776:99999999999999998
+05432127413542377777:99999999999999999
+05432127413542400000:100000000000000000
+05432127413542400001:100000000000000001
+05432127413542400002:100000000000000002

+5432127413542377776:99999999999999998
+5432127413542377777:99999999999999999
+5432127413542400000:100000000000000000
+5432127413542400001:100000000000000001
+5432127413542400002:100000000000000002

# Negative

-05432127413542377776:-99999999999999998
-05432127413542377777:-99999999999999999
-05432127413542400000:-100000000000000000
-05432127413542400001:-100000000000000001
-05432127413542400002:-100000000000000002

-5432127413542377776:-99999999999999998
-5432127413542377777:-99999999999999999
-5432127413542400000:-100000000000000000
-5432127413542400001:-100000000000000001
-5432127413542400002:-100000000000000002

###############################################################################
# Absolute value is close to 10^18 = 1000000000000000000
###############################################################################

# Unsigned

067405553164730777776:999999999999999998
067405553164730777777:999999999999999999
067405553164731000000:1000000000000000000
067405553164731000001:1000000000000000001
067405553164731000002:1000000000000000002

67405553164730777776:999999999999999998
67405553164730777777:999999999999999999
67405553164731000000:1000000000000000000
67405553164731000001:1000000000000000001
67405553164731000002:1000000000000000002

# Positive

+067405553164730777776:999999999999999998
+067405553164730777777:999999999999999999
+067405553164731000000:1000000000000000000
+067405553164731000001:1000000000000000001
+067405553164731000002:1000000000000000002

+67405553164730777776:999999999999999998
+67405553164730777777:999999999999999999
+67405553164731000000:1000000000000000000
+67405553164731000001:1000000000000000001
+67405553164731000002:1000000000000000002

# Negative

-067405553164730777776:-999999999999999998
-067405553164730777777:-999999999999999999
-067405553164731000000:-1000000000000000000
-067405553164731000001:-1000000000000000001
-067405553164731000002:-1000000000000000002

-67405553164730777776:-999999999999999998
-67405553164730777777:-999999999999999999
-67405553164731000000:-1000000000000000000
-67405553164731000001:-1000000000000000001
-67405553164731000002:-1000000000000000002

###############################################################################
# Absolute value is close to 10^19 = 10000000000000000000
###############################################################################

# Unsigned

01053071060221171777776:9999999999999999998
01053071060221171777777:9999999999999999999
01053071060221172000000:10000000000000000000
01053071060221172000001:10000000000000000001
01053071060221172000002:10000000000000000002

1053071060221171777776:9999999999999999998
1053071060221171777777:9999999999999999999
1053071060221172000000:10000000000000000000
1053071060221172000001:10000000000000000001
1053071060221172000002:10000000000000000002

# Positive

+01053071060221171777776:9999999999999999998
+01053071060221171777777:9999999999999999999
+01053071060221172000000:10000000000000000000
+01053071060221172000001:10000000000000000001
+01053071060221172000002:10000000000000000002

+1053071060221171777776:9999999999999999998
+1053071060221171777777:9999999999999999999
+1053071060221172000000:10000000000000000000
+1053071060221172000001:10000000000000000001
+1053071060221172000002:10000000000000000002

# Negative

-01053071060221171777776:-9999999999999999998
-01053071060221171777777:-9999999999999999999
-01053071060221172000000:-10000000000000000000
-01053071060221172000001:-10000000000000000001
-01053071060221172000002:-10000000000000000002

-1053071060221171777776:-9999999999999999998
-1053071060221171777777:-9999999999999999999
-1053071060221172000000:-10000000000000000000
-1053071060221172000001:-10000000000000000001
-1053071060221172000002:-10000000000000000002

###############################################################################
# Absolute value is close to 10^20 = 100000000000000000000
###############################################################################

# Unsigned

012657072742654303777776:99999999999999999998
012657072742654303777777:99999999999999999999
012657072742654304000000:100000000000000000000
012657072742654304000001:100000000000000000001
012657072742654304000002:100000000000000000002

12657072742654303777776:99999999999999999998
12657072742654303777777:99999999999999999999
12657072742654304000000:100000000000000000000
12657072742654304000001:100000000000000000001
12657072742654304000002:100000000000000000002

# Positive

+012657072742654303777776:99999999999999999998
+012657072742654303777777:99999999999999999999
+012657072742654304000000:100000000000000000000
+012657072742654304000001:100000000000000000001
+012657072742654304000002:100000000000000000002

+12657072742654303777776:99999999999999999998
+12657072742654303777777:99999999999999999999
+12657072742654304000000:100000000000000000000
+12657072742654304000001:100000000000000000001
+12657072742654304000002:100000000000000000002

# Negative

-012657072742654303777776:-99999999999999999998
-012657072742654303777777:-99999999999999999999
-012657072742654304000000:-100000000000000000000
-012657072742654304000001:-100000000000000000001
-012657072742654304000002:-100000000000000000002

-12657072742654303777776:-99999999999999999998
-12657072742654303777777:-99999999999999999999
-12657072742654304000000:-100000000000000000000
-12657072742654304000001:-100000000000000000001
-12657072742654304000002:-100000000000000000002
