/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common.xml;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import opennlp.common.util.PerlHelp;
import opennlp.common.xml.XmlUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class NLPDocument
extends Document {
    public static final String WORD_LABEL = "w";
    public static final String TOKEN_LABEL = "t";
    public static final String SENTENCE_LABEL = "s";
    public static final String PARAGRAPH_LABEL = "p";
    private Element _root;
    private int _textLength = 0;

    public NLPDocument() {
        this.setRootElement(new Element("nlpDocument"));
    }

    public NLPDocument(String text) {
        this();
        this.addTextContent(text);
    }

    protected void addTextContent(String text) {
        this._textLength = text.length();
        Element textEl = new Element("text");
        String[] paragraphs = PerlHelp.getParagraphs(text);
        int i = 0;
        while (i < paragraphs.length) {
            Element paraEl = new Element(PARAGRAPH_LABEL);
            Element sentEl = new Element(SENTENCE_LABEL);
            String[] chunksByLine = PerlHelp.split(paragraphs[i], "\n");
            int j = 0;
            while (j < chunksByLine.length) {
                int difference = 80 - chunksByLine[j].trim().length();
                if ((difference > 20 || chunksByLine[j].startsWith("\t") || chunksByLine[j].startsWith("   ")) && sentEl.hasChildren()) {
                    paraEl.addContent(sentEl);
                    sentEl = new Element(SENTENCE_LABEL);
                }
                String[] quasiWords = PerlHelp.splitByWhitespace(chunksByLine[j]);
                int k = 0;
                while (k < quasiWords.length) {
                    sentEl.addContent(NLPDocument.createTOK(quasiWords[k]));
                    ++k;
                }
                ++j;
            }
            paraEl.addContent(sentEl);
            textEl.addContent(paraEl);
            ++i;
        }
        this._root.addContent(textEl);
    }

    public static Element createSENT(String sent) {
        int l = sent.length();
        Element sentEl = new Element(SENTENCE_LABEL);
        if (l > 0) {
            char delim = sent.charAt(l - 1);
            if (delim == '.' || delim == '?' || delim == '!') {
                sentEl.addContent(NLPDocument.createTOK(sent.substring(0, l - 1)));
                sentEl.addContent(NLPDocument.createTOK(String.valueOf(delim)));
            } else {
                sentEl.addContent(NLPDocument.createTOK(sent));
            }
        }
        return sentEl;
    }

    public static Element createTOK(String tok) {
        return new Element(TOKEN_LABEL).addContent(new Element(WORD_LABEL).setText(tok));
    }

    public List getParagraphElements() {
        return XmlUtils.getChildrenNested(this._root, PARAGRAPH_LABEL);
    }

    public String[] getParagraphs() {
        List parEls = this.getParagraphElements();
        String[] pars = new String[parEls.size()];
        int index = 0;
        Iterator i = parEls.iterator();
        while (i.hasNext()) {
            StringBuffer sb = new StringBuffer();
            String[] sents = this.getSentences((Element)i.next());
            int j = 0;
            while (j < sents.length) {
                sb.append(sents[j]).append(' ');
                ++j;
            }
            pars[index++] = sb.toString().trim();
        }
        return pars;
    }

    public List getSentenceElements() {
        return this.getSentenceElements(this._root);
    }

    public List getSentenceElements(Element e) {
        return XmlUtils.getChildrenNested(e, SENTENCE_LABEL);
    }

    public String[] getSentences() {
        return this.getSentences(this._root);
    }

    public String[] getSentences(Element e) {
        List sentEls = this.getSentenceElements(e);
        String[] sents = new String[sentEls.size()];
        int index = 0;
        Iterator i = sentEls.iterator();
        while (i.hasNext()) {
            String[] words = this.getWords((Element)i.next());
            StringBuffer sent = new StringBuffer();
            int j = 0;
            while (j < words.length) {
                sent.append(words[j]).append(' ');
                ++j;
            }
            sents[index++] = sent.toString().trim();
        }
        return sents;
    }

    public List getTokenElements() {
        return this.getTokenElements(this._root);
    }

    public List getTokenElements(Element e) {
        return XmlUtils.getChildrenNested(e, TOKEN_LABEL);
    }

    public List getTokenElementsByType(String type) {
        List allTokens = this.getTokenElements(this._root);
        ArrayList<Element> toksByType = new ArrayList<Element>();
        Iterator allTokIt = allTokens.iterator();
        while (allTokIt.hasNext()) {
            Element tokEl = (Element)allTokIt.next();
            String tokType = tokEl.getAttributeValue("type");
            if (tokType == null || !tokType.equals(type)) continue;
            toksByType.add(tokEl);
        }
        return toksByType;
    }

    public List getWordElements() {
        return this.getWordElements(this._root);
    }

    public List getWordElements(Element e) {
        return XmlUtils.getChildrenNested(e, WORD_LABEL);
    }

    public String[] getWords() {
        return this.getWords(this._root);
    }

    public String[] getWords(Element e) {
        List wordEls = this.getWordElements(e);
        String[] words = new String[wordEls.size()];
        int index = 0;
        Iterator i = this.wordIterator(e);
        while (i.hasNext()) {
            words[index++] = ((Element)i.next()).getText();
        }
        return words;
    }

    public void join(Element startTok, Element endTok) {
        if (startTok == endTok) {
            return;
        }
        Element parentSentence = startTok.getParent();
        if (endTok.getParent() != parentSentence) {
            return;
        }
        List childrenOfSentence = parentSentence.getChildren();
        ArrayList<Object> $childrenOfSentence = new ArrayList<Object>();
        ListIterator i = childrenOfSentence.listIterator();
        while (i.hasNext()) {
            Object $_ = i.next();
            if ($_ == startTok) {
                ArrayList $tokChildren = new ArrayList();
                $tokChildren.addAll(startTok.getChildren());
                while (($_ = i.next()) != endTok) {
                    List nextChildren = ((Element)$_).getChildren();
                    ((Element)$_).removeChildren();
                    $tokChildren.addAll(nextChildren);
                }
                List endChildren = endTok.getChildren();
                endTok.removeChildren();
                $tokChildren.addAll(endChildren);
                startTok.removeChildren();
                startTok.setChildren($tokChildren);
                $childrenOfSentence.add(startTok);
                continue;
            }
            $childrenOfSentence.add($_);
        }
        parentSentence.removeChildren();
        parentSentence.setChildren($childrenOfSentence);
    }

    public static void main(String[] args) {
        NLPDocument doc = new NLPDocument("Here is a sentence. And this is another one.\n\nThis is a sentence in a new paragraph.");
        System.out.println(doc.toXml());
        System.out.println(doc.toString());
    }

    public Iterator paragraphIterator() {
        return this.getParagraphElements().iterator();
    }

    public Iterator sentenceIterator() {
        return this.getSentenceElements().iterator();
    }

    public Iterator sentenceIterator(Element e) {
        return this.getSentenceElements(e).iterator();
    }

    public Document setRootElement(Element root) {
        this._root = root;
        return super.setRootElement(root);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this._textLength);
        List parEls = this.getParagraphElements();
        Iterator i = parEls.iterator();
        while (i.hasNext()) {
            String[] sents = this.getSentences((Element)i.next());
            int j = 0;
            while (j < sents.length) {
                sb.append(sents[j]).append(' ');
                ++j;
            }
            sb.append("\n\n");
        }
        return sb.toString().trim();
    }

    public String toXml() {
        StringWriter sw = new StringWriter();
        try {
            new XMLOutputter("  ", true).output((Document)this, (Writer)sw);
        }
        catch (Exception e) {
            System.out.println("Unable to print document.");
            System.out.println(e);
        }
        return sw.toString();
    }

    public Iterator tokenIterator() {
        return this.getTokenElements().iterator();
    }

    public Iterator tokenIterator(Element e) {
        return this.getTokenElements(e).iterator();
    }

    public Iterator wordIterator() {
        return this.getWordElements().iterator();
    }

    public Iterator wordIterator(Element e) {
        return this.getWordElements(e).iterator();
    }
}

