#!/usr/bin/perl

package eBay::API::XML::Call::RemoveFromWatchList;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. RemoveFromWatchList.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::RemoveFromWatchList

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::RemoveFromWatchList inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::RemoveFromWatchList::RemoveFromWatchListRequestType;
use eBay::API::XML::Call::RemoveFromWatchList::RemoveFromWatchListResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'RemoveFromWatchList';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::RemoveFromWatchList::RemoveFromWatchListRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::RemoveFromWatchList::RemoveFromWatchListResponseType';
}

#
# input properties
#

=head2 setItemID()

The ID of the item to be removed from the
watch list. Either ItemID or RemoveAllItems must
be specified, but NOT both. One or more Item IDs
can be specified, each in it's own ItemID container.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Conditionally
#    Argument: reference to an array  
                      of 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setRemoveAllItems()

If true, then all the items in the user's
watch list are removed. Either ItemID or
RemoveAllItems must be specified, but NOT both.

  RequiredInput: Conditionally
#    Argument: 'xs:boolean'

=cut
       
sub setRemoveAllItems {
   my $self   = shift;
   my $sRemoveAllItems = shift;
   $self->getRequestDataType()->setRemoveAllItems($sRemoveAllItems);
}



#
# output properties
#

=head2 getWatchListCount()

The current number of items in the user's watch list (after those
specified in the call request have been removed)

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getWatchListCount {
   my $self = shift;
   return $self->getResponseDataType()->getWatchListCount();
}

=head2 getWatchListMaximum()

The maximum number of items allowed in watch lists. Currently this value
is 200, and is the same for all sites and all users.

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getWatchListMaximum {
   my $self = shift;
   return $self->getResponseDataType()->getWatchListMaximum();
}





1;   
