#!/usr/bin/perl

package eBay::API::XML::DataType::ContactHoursDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ContactHoursDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ContactHoursDetailsType

=head1 DESCRIPTION

Contains the data for primary and secondary contact hours for a given eBay user.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ContactHoursDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::DaysCodeType;


my @gaProperties = ( [ 'Hours1AnyTime', 'xs:boolean', '', '', '' ]
	, [ 'Hours1Days', 'ns:DaysCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DaysCodeType', '' ]
	, [ 'Hours1From', 'xs:time', '', '', '' ]
	, [ 'Hours1To', 'xs:time', '', '', '' ]
	, [ 'Hours2AnyTime', 'xs:boolean', '', '', '' ]
	, [ 'Hours2Days', 'ns:DaysCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DaysCodeType', '' ]
	, [ 'Hours2From', 'xs:time', '', '', '' ]
	, [ 'Hours2To', 'xs:time', '', '', '' ]
	, [ 'TimeZoneID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setHours1AnyTime()

Indicates whether or not a user is available to be contacted 24 hours a day
during the range of days specified using the Hours1Days element.
True indicates the user is available 24 hours a day, false indicates otherwise.
In the case of this field being true, all values provided for Hours1From and 
Hours1To will be ignored.  In the case of this field being false,
the values provided Hours1From and Hours1To will be considered.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setHours1AnyTime {
  my $self = shift;
  $self->{'Hours1AnyTime'} = shift
}

=head2 isHours1AnyTime()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isHours1AnyTime {
  my $self = shift;
  return $self->{'Hours1AnyTime'};
}


=head2 setHours1Days()

Indicates the range of days for which the primary contact hours 
specified by Hours1AnyTime or Hours1From and Hours1To apply.
If a value of None is provided for this field, the values provided for 
Hours1AnyTime, Hours1From, Hours1To are ignored.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:DaysCodeType'

=cut

sub setHours1Days {
  my $self = shift;
  $self->{'Hours1Days'} = shift
}

=head2 getHours1Days()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:DaysCodeType'

=cut

sub getHours1Days {
  my $self = shift;
  return $self->{'Hours1Days'};
}


=head2 setHours1From()

Indicates the starting time of day this eBay user is available for other eBay 
members to contact for the range of days specified using Hours1Days.
Enter times in 30 minute increments from the top of the hour. That is, enter 
values either on the hour (:00) or 30 minutes past the hour (:30). 
Other values will be will be rounded down to the next closest 30 minute 
increment. Times entered should be local to the value provided for TimeZoneID.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:time'

=cut

sub setHours1From {
  my $self = shift;
  $self->{'Hours1From'} = shift
}

=head2 getHours1From()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:time'

=cut

sub getHours1From {
  my $self = shift;
  return $self->{'Hours1From'};
}


=head2 setHours1To()

Indicates the ending time of day this eBay user is available for other eBay 
members to contact them for the range of days specified using Hours1Days.  
Enter times in 30 minute increments from the top of the hour. That is, enter 
values either on the hour (:00) or 30 minutes past the hour (:30). 
Other values will be will be rounded down to the next closest 30 minute 
increment. Times entered should be local to the value provided for TimeZoneID.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:time'

=cut

sub setHours1To {
  my $self = shift;
  $self->{'Hours1To'} = shift
}

=head2 getHours1To()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:time'

=cut

sub getHours1To {
  my $self = shift;
  return $self->{'Hours1To'};
}


=head2 setHours2AnyTime()

Indicates whether or not a user is available to be contacted 24 hours a day
during the range of days specified using the Hours2Days element.
True indicates the user is available 24 hours a day, false indicates otherwise.
In the case of this field being true, all values provided for Hours2From and 
Hours2To will be ignored.  In the case of this field being false,
the values provided Hours2From and Hours2To will be considered.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setHours2AnyTime {
  my $self = shift;
  $self->{'Hours2AnyTime'} = shift
}

=head2 isHours2AnyTime()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isHours2AnyTime {
  my $self = shift;
  return $self->{'Hours2AnyTime'};
}


=head2 setHours2Days()

Indicates the range of days for which the secondary contact hours 
specified by Hours2AnyTime or Hours2From and Hours2To apply.
If a value of None is provided for this field, the values provided for 
Hours2AnyTime, Hours2From, Hours2To are ignored.
<br>
<b>Note:</b> You cannot set Hours2Days to EveryDay. If Hours1Days 
is set to EveryDay, secondary contact hours do not apply. Hours2Days cannot be 
set to the same value as Hours1Days.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:DaysCodeType'

=cut

sub setHours2Days {
  my $self = shift;
  $self->{'Hours2Days'} = shift
}

=head2 getHours2Days()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:DaysCodeType'

=cut

sub getHours2Days {
  my $self = shift;
  return $self->{'Hours2Days'};
}


=head2 setHours2From()

Indicates the starting time of day this eBay user is available for other eBay 
members to contact for the range of days specified using Hours2Days.
Enter times in 30 minute increments from the top of the hour. That is, enter 
values either on the hour (:00) or 30 minutes past the hour (:30). 
Other values will be will be rounded down to the next closest 30 minute 
increment. Times entered should be local to the value provided for TimeZoneID.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:time'

=cut

sub setHours2From {
  my $self = shift;
  $self->{'Hours2From'} = shift
}

=head2 getHours2From()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:time'

=cut

sub getHours2From {
  my $self = shift;
  return $self->{'Hours2From'};
}


=head2 setHours2To()

Indicates the ending time of day this eBay user is available for other eBay 
members to contact them for the range of days specified using Hours1Days.  
Enter times in 30 minute increments from the top of the hour. That is, enter 
values either on the hour (:00) or 30 minutes past the hour (:30). 
Other values will be will be rounded down to the next closest 30 minute 
increment. Times entered should be local to the value provided for TimeZoneID.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:time'

=cut

sub setHours2To {
  my $self = shift;
  $self->{'Hours2To'} = shift
}

=head2 getHours2To()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:time'

=cut

sub getHours2To {
  my $self = shift;
  return $self->{'Hours2To'};
}


=head2 setTimeZoneID()

Indicates the local time zone of the values provided for Hours1From/Hours1To 
and Hours2From/Hours2To. If you specify a contact hours time range with 
Hours1From and Hours1To, you must provide a local time zone.
Use GeteBayDetails to retrieve a complete list of the TimeZoneID values
supported by eBay.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setTimeZoneID {
  my $self = shift;
  $self->{'TimeZoneID'} = shift
}

=head2 getTimeZoneID()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getTimeZoneID {
  my $self = shift;
  return $self->{'TimeZoneID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
