#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::NotificationEventTypeCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. NotificationEventTypeCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::NotificationEventTypeCodeType

=head1 DESCRIPTION

Defines all notification events that can be used.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 None

Not a notification event.



=cut


use constant None => scalar('None');


=head2 OutBid

Sent to a user when another buyer has placed a higher maximum bid
and the user is no longer the current high bidder.



=cut


use constant OutBid => scalar('OutBid');


=head2 EndOfAuction

Sent when an auction ends. An auction ends either when its duration
expires, the buyer purchases an item with Buy It Now, or the auction is
canceled. Applies to both Chinese and Dutch auctions.



=cut


use constant EndOfAuction => scalar('EndOfAuction');


=head2 AuctionCheckoutComplete

Sent to a seller when a buyer completes the checkout process for an
item. Occurs even when a seller has disabled checkout and the buyer uses
eBayPayments.



=cut


use constant AuctionCheckoutComplete => scalar('AuctionCheckoutComplete');


=head2 FixedPriceEndOfTransaction

Sent to a seller when a fixed-price item is sold and the buyer
completes the checkout process. Not sent when a fixed-price item's duration
expires without purchase.



=cut


use constant FixedPriceEndOfTransaction => scalar('FixedPriceEndOfTransaction');


=head2 CheckoutBuyerRequestsTotal

Sent to a seller each time a buyer requests a total price. Occurs
before checkout is complete.



=cut


use constant CheckoutBuyerRequestsTotal => scalar('CheckoutBuyerRequestsTotal');


=head2 Feedback

Sent to a partner when a buyer leaves feedback for the seller
or the seller leaves feedback for a buyer.



=cut


use constant Feedback => scalar('Feedback');


=head2 FeedbackForSeller

If specified in SetNotificationPreferences, eBay drops this value
and uses Feedback instead.  Applications should remove any
dependencies on this value.



=cut


use constant FeedbackForSeller => scalar('FeedbackForSeller');


=head2 FixedPriceTransaction

Sent to a user when a listing for a fixed price item ends. A fixed
price listing ends when a buyer starts to move through checkout or purchases
the item.



=cut


use constant FixedPriceTransaction => scalar('FixedPriceTransaction');


=head2 SecondChanceOffer

Reserved for future use.



=cut


use constant SecondChanceOffer => scalar('SecondChanceOffer');


=head2 AskSellerQuestion

Sent to a seller when a question is posted about one of the seller's
active listings.



=cut


use constant AskSellerQuestion => scalar('AskSellerQuestion');


=head2 ItemListed

Sent to an eBay partner on behalf of a seller when a seller has
listed an item. Sent for each item the seller lists.



=cut


use constant ItemListed => scalar('ItemListed');


=head2 ItemRevised

Sent to an eBay partner on behalf of a seller when a seller has
revised an item.



=cut


use constant ItemRevised => scalar('ItemRevised');


=head2 BuyerResponseDispute

Sent to an eBay partner on behalf of a seller when a buyer responds
to a dispute the seller has opened. Sent for each response the buyer makes.
This corresponds to the UPIBuyerResponseDispute notification.



=cut


use constant BuyerResponseDispute => scalar('BuyerResponseDispute');


=head2 SellerOpenedDispute

Sent to an eBay partner on behalf of a seller when a seller opens a
dispute. Sent for each dispute the seller opens.
This corresponds to the UPISellerOpenedDispute notification.



=cut


use constant SellerOpenedDispute => scalar('SellerOpenedDispute');


=head2 SellerRespondedToDispute

Sent to an eBay partner on behalf of a seller when a seller responds
to a dispute they had opened. Sent for each response the seller makes.
This corresponds to the UPISellerRespondedToDispute notification.



=cut


use constant SellerRespondedToDispute => scalar('SellerRespondedToDispute');


=head2 SellerClosedDispute

Sent to an eBay partner on behalf of a seller when a seller closes a
dispute they had opened. Sent for each closure the seller performs.
This corresponds to the UPISellerClosedDispute notification.



=cut


use constant SellerClosedDispute => scalar('SellerClosedDispute');


=head2 BestOffer

Sent to a seller when a bidder makes a best offer on an item opted
into the Best Offer feature by the seller.



=cut


use constant BestOffer => scalar('BestOffer');


=head2 MyMessagesAlertHeader

A notification type where a specified user or application is notified
when an alert is sent to My Messages. This notification type sends a
GetMyMessages response at a detail level of ReturnHeaders.
MyMessagesAlertHeader and MyMessagesAlert cannot be subscribed to at the same
time or specified in the same call.



=cut


use constant MyMessagesAlertHeader => scalar('MyMessagesAlertHeader');


=head2 MyMessagesAlert

A notification type where a specified user or application is
notified when an alert is sent to My Messages. This notification type sends
a GetMyMessages response at a detail level of ReturnMessages.
MyMessagesAlertHeader and MyMessagesAlert cannot be subscribed to at the
same time or specified in the same call.



=cut


use constant MyMessagesAlert => scalar('MyMessagesAlert');


=head2 MyMessageseBayMessageHeader

A notification type where a specified user or application is
notified when a message from eBay is sent to My Messages. This notification
type sends a GetMyMessages response at a detail level of ReturnHeaders.
MyMessageseBayMessageHeader and MyMessageseBayMessage cannot be subscribed
to at the same time or specified in the same call.



=cut


use constant MyMessageseBayMessageHeader => scalar('MyMessageseBayMessageHeader');


=head2 MyMessageseBayMessage

A notification type where a specified user or application is
notified when a message from eBay is sent to My Messages. This notification
type sends a GetMyMessages response at a detail level of ReturnMessages.
MyMessageseBayMessageHeader and MyMessageseBayMessage cannot be subscribed
to at the same time or specified in the same call.



=cut


use constant MyMessageseBayMessage => scalar('MyMessageseBayMessage');


=head2 MyMessagesM2MMessageHeader

A notification type where a specified user or application is
notified when a member to member (M2M) message is sent to My Messages. This
notification type sends a GetMyMessages response at a detail level of
ReturnHeaders. MyMessagesM2MMessageHeader and MyMessagesM2MMessage cannot
be subscribed to at the same time or specified in the same call.



=cut


use constant MyMessagesM2MMessageHeader => scalar('MyMessagesM2MMessageHeader');


=head2 MyMessagesM2MMessage

A notification type where a specified user or application is
notified when a member to member (M2M) message is sent to My Messages. This
notification type sends a GetMyMessages response at a detail level of
ReturnMessages. MyMessagesM2MMessageHeader and MyMessagesM2MMessage cannot
be subscribed to at the same time or specified in the same call.



=cut


use constant MyMessagesM2MMessage => scalar('MyMessagesM2MMessage');


=head2 INRBuyerOpenedDispute

A notification type where a specified user or application is
notified on behalf of a buyer when a buyer opens an Item Not Received dispute.
Sent for each dispute the buyer opens.



=cut


use constant INRBuyerOpenedDispute => scalar('INRBuyerOpenedDispute');


=head2 INRBuyerRespondedToDispute

A notification type where a specified user or application is
notified on behalf of a buyer when a buyer responds to Item Not Received
dispute that buyer had opened. Sent for each response the buyer makes.



=cut


use constant INRBuyerRespondedToDispute => scalar('INRBuyerRespondedToDispute');


=head2 INRBuyerClosedDispute

A notification type where a specified user or application is
notified on behalf of a buyer when a buyer closes Item Not Received
dispute that buyer had opened. Sent for each closure the buyer performs.



=cut


use constant INRBuyerClosedDispute => scalar('INRBuyerClosedDispute');


=head2 INRSellerRespondedToDispute

A notification type where a specified user or application is
notified on behalf of a seller when a seller responds to an Item Not Received
dispute that buyer had opened. Sent for each response the seller makes.



=cut


use constant INRSellerRespondedToDispute => scalar('INRSellerRespondedToDispute');


=head2 Checkout

A notification type where an application is notified
that checkout has been handled by eBay Express.



=cut


use constant Checkout => scalar('Checkout');


=head2 WatchedItemEndingSoon

A notification type where the listing of the watched item is about
to end. This event has a property with which caller can specify the TimeLeft
before the listing ends.



=cut


use constant WatchedItemEndingSoon => scalar('WatchedItemEndingSoon');


=head2 ItemClosed

Specifies an ItemClosed notification event. Applies to eBay Motors
Pro applications only.



=cut


use constant ItemClosed => scalar('ItemClosed');


=head2 ItemSuspended

Specifies an ItemSuspended notification event. Applies to eBay Motors
Pro applications only.



=cut


use constant ItemSuspended => scalar('ItemSuspended');


=head2 ItemSold

Specifies an ItemSold notification event. Applies to eBay Motors Pro
applications only.



=cut


use constant ItemSold => scalar('ItemSold');


=head2 ItemExtended

Specifies an ItemSold notification event. Applies to eBay Motors Pro
applications only.



=cut


use constant ItemExtended => scalar('ItemExtended');


=head2 UserIDChanged

The userid was changed. Available for SMS on the UK and Germany
sites. Not applicable to Platform Notifications.



=cut


use constant UserIDChanged => scalar('UserIDChanged');


=head2 EmailAddressChanged

The email address was changed. Available for SMS on the UK and
Germany sites. Not applicable to Platform Notifications.



=cut


use constant EmailAddressChanged => scalar('EmailAddressChanged');


=head2 PasswordChanged

The password was changed. Available for SMS on the UK and Germany
sites. Not applicable to Platform Notifications.



=cut


use constant PasswordChanged => scalar('PasswordChanged');


=head2 PasswordHintChanged

The password hint was changed. Available for SMS on the UK and
Germany sites. Not applicable to Platform Notifications.



=cut


use constant PasswordHintChanged => scalar('PasswordHintChanged');


=head2 PaymentDetailChanged

The payment detail was changed. Available for SMS on the UK and
Germany sites. Not applicable to Platform Notifications.



=cut


use constant PaymentDetailChanged => scalar('PaymentDetailChanged');


=head2 AccountSuspended

The account was suspended. Available for SMS on the UK and Germany
sites. Not applicable to Platform Notifications.



=cut


use constant AccountSuspended => scalar('AccountSuspended');


=head2 AccountSummary

An informational alert about account activity.
A user can subscribe to receive an account activity summary via SMS.
The user can specify the period (time range) for the account summary and can
select how often the summary is to be sent. It is not triggered by an event
but rather by an eBay daemon process that monitors a schedule database.



=cut


use constant AccountSummary => scalar('AccountSummary');


=head2 ThirdPartyCartCheckout

Sent to a third party when their cart completes checkout on eBay Express.



=cut


use constant ThirdPartyCartCheckout => scalar('ThirdPartyCartCheckout');


=head2 ItemRevisedAddCharity

Sent to an eBay partner on behalf of a seller when a seller has
revised an item and added charity.



=cut


use constant ItemRevisedAddCharity => scalar('ItemRevisedAddCharity');


=head2 ItemAddedToWatchList

Sent to a subscribing third party when a user adds an item to her or his watch list.



=cut


use constant ItemAddedToWatchList => scalar('ItemAddedToWatchList');


=head2 ItemRemovedFromWatchList

Sent to a subscribing third party when a user removes an item from her or his watch list.



=cut


use constant ItemRemovedFromWatchList => scalar('ItemRemovedFromWatchList');


=head2 ItemAddedToBidGroup

Sent to a subscribing third party when a user adds an item to her or his bid group.



=cut


use constant ItemAddedToBidGroup => scalar('ItemAddedToBidGroup');


=head2 ItemRemovedFromBidGroup

Sent to a subscribing third party when a user removes an item from her or his bid group.



=cut


use constant ItemRemovedFromBidGroup => scalar('ItemRemovedFromBidGroup');


=head2 FeedbackLeft

Sent to a subscribing third party when a buyer leaves feedback for the seller
or the seller leaves feedback for a buyer.



=cut


use constant FeedbackLeft => scalar('FeedbackLeft');


=head2 FeedbackReceived

Sent to a subscribing third party when the buyer leaves feedback for a seller
or the seller leaves feedback for a buyer.



=cut


use constant FeedbackReceived => scalar('FeedbackReceived');


=head2 FeedbackStarChanged

Sent to a subscribing third party when a user's feedback star level changes.



=cut


use constant FeedbackStarChanged => scalar('FeedbackStarChanged');


=head2 BidPlaced

Sent to a subscribing third party for the buyer when a user places a bid for an item.



=cut


use constant BidPlaced => scalar('BidPlaced');


=head2 BidReceived

Sent to a subscribing third party for the seller when a user places a bid for an item.



=cut


use constant BidReceived => scalar('BidReceived');


=head2 ItemWon

Sent to a subscribing third party for the buyer when a user bought an item.



=cut


use constant ItemWon => scalar('ItemWon');


=head2 ItemLost

Sent to a subscribing third party for the buyer when a user lost a bid for an item.



=cut


use constant ItemLost => scalar('ItemLost');


=head2 ItemUnsold

Sent to a subscribing third party for the seller when an item was not sold.



=cut


use constant ItemUnsold => scalar('ItemUnsold');


=head2 CounterOfferReceived

Sent to a subscribing third party for a buyer when a seller makes a counter offer to the buyer's best offer on an item opted	into the Best Offer feature by the seller.



=cut


use constant CounterOfferReceived => scalar('CounterOfferReceived');


=head2 BestOfferDeclined

Sent to a subscribing third party for a buyer when a seller rejects the buyer's best offer on an item opted into the Best Offer feature by the seller.



=cut


use constant BestOfferDeclined => scalar('BestOfferDeclined');


=head2 BestOfferPlaced

Sent to a subscribing third party for a buyer who makes a best offer on an item opted into the Best Offer feature by a seller.



=cut


use constant BestOfferPlaced => scalar('BestOfferPlaced');


=head2 ItemsCanceled

Sent to a subscribing third party when a Customer Service Representative ends one or more items.



=cut


use constant ItemsCanceled => scalar('ItemsCanceled');


=head2 TokenRevocation

An informational alert sent to a subscribing application when a user token has been revoked.



=cut


use constant TokenRevocation => scalar('TokenRevocation');


=head2 CustomCode

Reserved for future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
