#!/usr/bin/perl

package eBay::API::XML::DataType::PriceRangeFilterType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PriceRangeFilterType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::PriceRangeFilterType

=head1 DESCRIPTION

One of the data filters used when searching for items using
GetSearchResults. Allows filtering based on the current price of items.
Properties allow for defining a range within prices must fall to be
returned in the result set, a minimum price for items returned, or a
maximum price for items returned.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::PriceRangeFilterType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;


my @gaProperties = ( [ 'MaxPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'MinPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setMaxPrice()

Specifies the maximum current price an item listing can have to be included in
the searches result set. Use alone to specify a maximum price or with MinPrice
to define a range the items' prices must be.
See "Data Types" in the eBay Web Services Guide for information about specifying
double values.

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setMaxPrice {
  my $self = shift;
  $self->{'MaxPrice'} = shift
}

=head2 getMaxPrice()

#    Returns: 'ns:AmountType'

=cut

sub getMaxPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MaxPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setMinPrice()

Specifies the minimum current price an item listing can have to be included in
the searches result set. Use alone to specify a minimum price or with MaxPrice
to define a range the items' prices must be.
See "Data Types" in the eBay Web Services Guide for information about specifying
double values.

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setMinPrice {
  my $self = shift;
  $self->{'MinPrice'} = shift
}

=head2 getMinPrice()

#    Returns: 'ns:AmountType'

=cut

sub getMinPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MinPrice'
		,'eBay::API::XML::DataType::AmountType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
