use strict;
use HTML::WikiConverter;

my $num_opts = scalar(@ARGV);
my %options = ();

while(@ARGV) {
   parseOption(shift);

}


my $html;
if (exists $options{'file'}) {
  open FH, "< $options{'file'}";
  $html = join "", <FH>;
  close FH;
}
else {
   $html = join "", <>;
}

my $wc = new HTML::WikiConverter( dialect => $options{'dialect'},   base_uri => $options{'base_uri'}); 
#             browser => $options{'browser'}, base_uri => $options{'base_uri'}, 
#                                     group => $options{'group'}); 

if (exists $options{'file'}) {
  open FH, "> $options{'file'}";
  print FH $wc->html2wiki($html);  
  close FH; 
  my $lockfile = $options{'file'} . ".lock";
  unlink($lockfile);
}
else {
   print $wc->html2wiki($html);  
}





sub parseOption {
my $opt_string = shift;
return "" if !$opt_string;
$opt_string =~ s/^--//;
$opt_string =~ s/\-/_/;

my ($name, $value) = split('=', $opt_string);
$options{$name} = $value;


}

sub getOption {
my $opt_string = shift;
return "" if !$opt_string;
return (split('=', $opt_string))[1];

}



