use v6.c;

use Pod::To::Pager::Handlers;

class Pod::To::Pager
{
	multi method render(@pod is copy)
	{
		@pod .= grep({ $_.WHAT ~~ Pod::Block::Named }) if (1 < @pod.elems);

		self.render(@pod[0]);

		return;
	}

	multi method render(Any:U)
	{
		say "No usable Perl 6 Pod found in the given file";
		exit 1;
	}

	multi method render(Any:D $pod)
	{
		print handle-pod($pod);
	}
}

# vim: ft=perl6 noet
