#!/usr/bin/env perl
use strict;
use warnings;
use utf8;
use Locale::Maketext::Extract;
use Locale::Maketext::Extract::Plugin::Xslate;
use File::Find::Rule;

my $extract = Locale::Maketext::Extract->new(
    plugins  => {
        perl => [qw/pl pm js/],
        xslate  => {
            syntax     => 'TTerse',
            extensions => [qw/ tt /],
        },
    },
    warnings => 1,
    verbose  => 1,
    header   => << 'POT',
# GENERATED BY amon2-xgettext.pl (Amon2::Plugin::L10N)
#
#, fuzzy
msgid ""
msgstr ""
"Project-Id-Version: PACKAGE VERSION\n"
"POT-Creation-Date: YEAR-MO-DA HO:MI+ZONE\n"
"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\n"
"Last-Translator: FULL NAME <EMAIL@ADDRESS>\n"
"Language-Team: LANGUAGE <LL@li.org>\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
POT
);

mkdir 'po';
for my $lang (@ARGV) {
    $extract->read_po("po/$lang.po") if -f "po/$lang.po";

    $extract->extract_file($_) for (
        File::Find::Rule->file()->name(qr/.*\.(?:pm|pl)/)->in('lib'),
        File::Find::Rule->file()->name('*.tt')->in('tmpl')
    );

    $extract->compile(1);
    $extract->write_po("po/$lang.po");
}
