#!/usr/bin/env perl

=pod

=head1 NAME

kaplan.t - unit test for ...

=head1 DESCRIPTION



=cut

# MODULE IMPORTS
########################
# Pragmas
#----------------------#
use 5.10.1;
use strict;
use warnings;
use utf8;

# CPAN/Core Imports
#----------------------#
use Capture::Tiny qw(:all);
use Carp qw(verbose carp confess croak);
use Const::Fast;
use DateTime;
use File::HomeDir;
use Log::Log4perl qw(:easy);
use Path::Tiny;
use Sub::Override;
use Test::Most;
use Try::Tiny;

# VARIABLES/CONSTANTS
########################
const my $DEBUG                 => $ENV{DEBUG} // 1;
const my $TEST                  => $ENV{TEST} // 1;

const my $ROBOTS_TXT            => <<'TXT';
# All robots - Dont crawl - Mit Telmore
User-agent: *
Disallow: /mit-telmore
Disallow: /website
Disallow: /flows
Disallow: /t2

# All robots - Dont crawl - Old shop
#User-agent: *
Disallow: /categoryList.action
Disallow: /error404.action
Disallow: /newProductSignUp.action
Disallow: /searchResult.action
Disallow: /AdvancedSearch.action
Disallow: /welcome.action

# All robots - Dont crawl - 2012 julesider
#User-agent: *
Disallow: /julekalender-2012
Disallow: /julekonkurrence2012
Disallow: /takkeside-julekonkurrence2012

# All robots - Dont crawl - Search
#User-agent: *
Disallow: /sider/soeg
Disallow: /soeg

# Angular
#User-agent: *
Disallow: /api/account
Disallow: /api/account/change_password
Disallow: /api/account/sessions
Disallow: /api/audits/
Disallow: /api/logs/
Disallow: /api/users/
Disallow: /api/cms/
Disallow: /api/shop/
Disallow: /metrics/
Disallow: /health/
Disallow: /trace/
Disallow: /dump/
Disallow: /shutdown/
Disallow: /beans/
Disallow: /configprops/
Disallow: /info/
Disallow: /autoconfig/
Disallow: /env/
Disallow: /trace/
Disallow: /v2/api-docs/
Disallow: /configuration/
Disallow: /protected/
Disallow: /shop/*.action

# Allow crawlers to use JavaScript and CSS
#User-Agent: *
Allow: /*.js
Allow: /*.css
TXT

# RUNTIME CONFIGURATION
########################
BEGIN {
    $| = 1;
    Log::Log4perl->easy_init($TRACE);
    use_ok('CrawlerCommons::RobotRulesParser');
}

# SM Imports
########################

# BODY
########################
# Setup
#----------------------#
try {
    my $parser = CrawlerCommons::RobotRulesParser->new;
    my $robot_rules =
      $parser->parse_content(
      "www.telmore.dk", $ROBOTS_TXT, "text/plain", 'SearchmetricsBot'
      );

    is($robot_rules->is_allowed("https://www.telmore.dk/shop/addToCart.action?bundle=b_MV1000H40GB4GMUSIC201603SHOP&instalment=161_24&product=348874&voucherCode=&preOrderToken="), 0);
}
catch {
    say "Testing ended unexpectedly: $_";
};

done_testing;

# SUBROUTINES
########################
#-----------------------------------------------------------------------------#
#-----------------------------------------------------------------------------#
